+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2021-07-26T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1626825145/media/2021/07/sqDMMO-Travelers-JosephLattanziChristianSanders_oosbsf.jpg"
primary_image_credit = "Joseph Lattanzi (Hawkins Fuller) and Christian Sanders (Timothy Laughlin) in Des Moines Metro Opera's production of Fellow Traveles, 2021. Photo: Duane Tinkey."
related_articles = ["articles/fellow-travelers-is-luminous-in-chicago.md", "articles/fellow-travelers-a-cathartic-necessary-affair.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/christian-sanders.md", "scene/people/joseph-lattanzi.md"]
short_description = "The heart wrenching scenes we did get were truly compelling, but I found myself getting impatient in the less exciting sections. The brief flashes of forbidden passion just weren’t enough to keep the momentum going, and I just wanted them to skip to the juicy parts!"
slug = "dmmos-fellow-travelers-no-happy-ending-but-perseverance"
title = "DMMO's Fellow Travelers: no happy ending, but perseverance"
youtube_url = ""

+++
There are a few recently composed American operas that seem to be making the rounds throughout regional opera companies, and [_Fellow Travelers_](https://desmoinesmetroopera.org/productions/fellowtravelers/), written by Gregory Spears and Greg Pierce, has clearly captured the attention of the opera world since its premiere in 2016. [Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) brought this touching tale of forbidden love and hidden identities to the stage for an exclusive one night performance, a contemporary operatic work surrounded by the vintage beauty of the historical Hoyt Sherman Place.

Carolyn Watson led the orchestra in a deft and nuanced performance of Gregory Spears' score. The orchestration encompassed a wide variety of emotions, often ranging from intimate to cinematic and sometimes managed to capture both feelings simultaneously. Spears also slips in subtle references to other operatic styles with hints of baroque dances or bel canto ornamentation. While the score calls for a small chamber orchestra, it was often difficult to hear certain singers over the ensemble. This is a common acoustic problem in Hoyt Sherman Place's performance space due to the lack of a true orchestra pit which resulted in the instruments being level with the audience. This issue was particularly prevalent with the lower voices in the cast but only when the orchestration was at its fullest. During the post show talk back with the opera's creative team, it became clear that the score for _Fellow Travelers_ is deceptively tricky. The music gives the impression of simplicity, but both the singers and orchestra navigated the changing time signatures and vulnerable melodies with precision and heart. Watson admitted in the panel discussions that this was her first time conducting this opera, and I wholeheartedly hope that she will get further opportunities to explore this work and bring her musical insights to Spears' composition.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626825237/media/2021/07/DMMO-Travelers-JosephLattanziChristianSanders_vrlhhc.jpg){{% /md %}}

<figcaption>Joseph Lattanzi (Hawkins Fuller) and Christian Sanders (Timothy Laughlin) in Des Moines Metro Opera's production of Fellow Traveles, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

As far as the pacing of the opera, both musically and dramatically, _Fellow Travelers_ suffered from some stagnation in the second act. Librettist Greg Pierce condensed down the expansive novel by Thomas Mallon, focusing on the love story between Timothy Laughlin and Hawkins Fuller. My understanding from the author's comments during the post show panel is that the original novel contains more political references and covers a large span of time, and I think Greg Pierce was wise to narrow his narrative. However, as an opera lover, I just wanted more romanticism and drama throughout the piece. The intimate scenes between the two men were beautifully realistic, exposed but tender. Some of the dialogue was cringey, including lines like "I own you" and "Irish tiger cub," but believably cringey for bedroom talk.

The heart wrenching scenes we did get were truly compelling, but I found myself getting impatient in the less exciting sections. The brief flashes of forbidden passion just weren’t enough to keep the momentum going, and I just wanted them to skip to the juicy parts!

The characters themselves were fascinating in their contradictions and complexities. Each individual felt like a real, fully fleshed out person. Hawk and Tim were both uniquely likable and frustrating, but for some reason, I just wasn't rooting for them as a couple. Since I didn't buy into their romance, the betrayal at the end of the opera came across as annoying rather than heartbreaking. I know many operas convince us that people are in love with way less, but without the balls to the walls emotional punch of romanticism, the relationship between the two men, although dangerous and forbidden, fell flat for me. Perhaps I was expecting an over the top love affair in the wrong opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626825313/media/2021/07/DMMO-Travelers-ChristianSandersGraceKahlAmandaSheriff_fdj3vd.jpg){{% /md %}}

<figcaption>(l-r) Christian Sanders (Timothy Laughlin), Grace Kahl (Mary Johnson) and Amanda Sheriff (Miss Lightfoot) in Des Moines Metro Opera's production of Fellow Traveles, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

The scenic design by Victoria Tzykun emphasized the rigidity and claustrophobia of 1950s bureaucracy. A simple park bench opened the opera, and the two main characters had both their meet cute and their bittersweet goodbye in this simplistic setting. Timothy's room was reminiscent of a small dorm room or a monk's cell--a fitting abode for the naive Catholic youth. The office environment was especially intimidating. Rows of file cabinets dominated the stage, corralling the characters. An ominous red curtain hovered above like the Red Scare lingering in the minds of all the government workers. Nate Wheatley's lighting design further highlighted the menacing moments of the plot, harsh overhead lights beating down during the interrogation scene in particular. Most striking at the end of the opera, the back curtain rose to reveal a wall covered in photographs. These faces symbolized the victims of the Lavender Scare, over 3000 men and women that lost their jobs for their "deviant" tendencies. Confronting the audience with the human toll of our nation's past was powerful, and considering the prejudices that continue to this day, remembering this impact is crucial.

Paul Carey and Heather Lesieur delivered costumes that celebrated the classic 1950s aesthetics, aided by the pristine hair and make-up designs by Sondra Nottingham. Sharp suits and pencil skirts were the armor of the government workers. Even if they were hiding less than conventional desires, they each had to make sure they looked the part of an ideal American man or woman.

The cast of Des Moines Metro Opera's production was small but mighty. Many of the performers took on multiple small characters throughout the story, and all set changes were assisted by the singers who maintained their personas seamlessly even while shuttling set pieces across the stage. Many of the performers had the daunting task of portraying real historical characters, and they did so quite convincingly.

> Grace Kahl sang the role of Mary with vocal clarity and emotional vulnerability.

Benjamin Taylor brought a political sleeziness to the role of Tommy McIntyre. He demonstrated the duality of DC, both befriending Timothy Laughlin at his job interview and hinting at the darker aspects of the political game. Taylor's steady baritone came across as subtly menacing as he revealed his blackmailing schemes, his tone lighthearted but his intentions less so.

Craig Juricka sang the role of Senator Charles Potter as a blustery grump with humorous moments. Juricka embodied the senator’s physical disability in a believable manner, triggering flashing lights in his canes to emphasize the character’s emotions. This quirky customization of his accessories earned the senator the nickname of Citizen Canes, and Juricka embraced the comedic and serious sides of the character.

Nathaniel Hill portrayed the most infamous person of the opera, Senator Joseph McCarthy. While only physically appearing in one scene, McCarthy's presence loomed over the entire story. He represented the prejudices and persecutions of the era in many ways, and when the audience is finally confronted with him, McCarthy is almost disappointingly normal. The man had a profound effect on so many lives, but he wasn’t some boogeyman. I appreciated this realistic approach to the character.

While _Fellow Travelers_ seemed to be a world dominated by men, there were a few female characters that were crucial to the story. Amanda Sheriff reveled in the role of Miss Lightfoot, the nosy office gossip who doesn't hesitate to rat out her boss when she suspects he is a homosexual. Sheriff managed to make this antagonistic admin both threatening and amusing. Even at the Christmas party when she’s cutting loose with coworkers, she made time for lurking around corners and eavesdropping with drink in hand. Sheriff embraced the pettiness and suspicion in Miss Lightfoot, a stark but effective contrast to her more sympathetic coworker, Mary Johnson.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626825454/media/2021/07/DMMO-Travelers-ClaireLopatkaJosephLattanzi_ii2qjb.jpg){{% /md %}}

<figcaption>Claire Lopatka (Lucy) and Joseph Lattanzi (Hawkins Fuller) in Des Moines Metro Opera's production of Fellow Traveles, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Grace Kahl sang the role of Mary with vocal clarity and emotional vulnerability. This character is the only caring confidant that both Timothy and Hawk have in their lives, and while she goes through her own secret problems, she is always willing to be there for these two men. While musically, this role did not seem to showcase Kahl’s full vocal abilities, the soprano still managed to touch the heart with her performance, a beacon of humanity in the backstabbing political plot.

The charismatic Hawkins Fuller was performed by baritone [Joseph Lattanzi](/scene/people/joseph-lattanzi/), a role which he premiered in the original 2016 production. Lattanzi has an obvious intimate connection to the character of Hawk, evident by his mastery of the physical and vocal demands of the role. Hawk is the older, more experienced man in the opera's romance. He moved across the stage with a suave control like a panther. He pursued Timothy with laser focus, but he also had to maintain his public persona. It was this dichotomy of professional façade and hidden hedonism that made Hawk such a compelling character. Even when they are alone together, Hawk never lets his guard down. Despite his calm and collected exterior, the music reveals Hawk's inner turmoil. His vocal lines do not have the passionate energy of his young lover, but the florid flurries beneath Lattanzi's aria evoked the character’s sense of longing.

> I hope that both men will continue to perform these roles in future productions, growing and developing the characters even further as they do.

On the opposite end of the emotional spectrum was Hawk's "Irish tiger cub" Timothy Laughlin. Tenor [Christian Sanders](/scene/people/christian-sanders/) sang the role of Timothy with an innocent vulnerability and vocal clarity. Sanders’ voice cut through the orchestra despite the venue’s acoustic issues, connecting to the audience on a visceral level. Timothy, like Hawkins, is a man of contradictions. He is experiencing romantic love for the first time in his life, and despite his religious upbringing, he embraces the relationship with naïve enthusiasm. Timothy is a bit of a timid little lamb at the beginning of the opera, and his vocal lines often reflect that. Sanders’ voice captured this sense of vulnerability with deceptive ease, and the fresh-faced tenor gave the most compelling dramatic performance of the evening, a feat that is all the more impressive considering this was his first time singing the role. Timothy's aria in the church after his first night in Hawk’s arms was a tender expression of first love's rush, and Sanders perfectly captured the beauty and tragedy of this moment. Both Sanders and Lattanzi managed to create believable portrayals of these contradictory characters, and their ability to perform quick changes onstage was impressive to say the least. Their chemistry together onstage was dynamic, and I hope that both men will continue to perform these roles in future productions, growing and developing the characters even further as they do.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626825434/media/2021/07/DMMO-Travelers-cast_qpbwuq.jpg){{% /md %}}

<figcaption>The cast of Des Moines Metro Opera's production of Fellow Traveles, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

[_Fellow Travelers_](https://desmoinesmetroopera.org/productions/fellowtravelers/) is a glimpse into the dangerous and restricted life many Americans experienced in our not so recent past. Often operas can be an escape from reality, tales of far off places with crazy plot lines, but _Fellow Travelers_ is impactful because of its realism. To this day, people are still attacked, ostracized, and shamed for the people they choose to love, and while it can be easy and convenient to pretend the Lavender Scare was a fluke of the past, violence and hate towards the LGBTQIA+ community has not disappeared. Des Moines Metro Opera's production reminded the audience that while the world has made some progress since the 1950s, we cannot forget history or ignore our current cultural failings. _Fellow Travelers_ is a story about ordinary men loving each other in the face of adversity, and while we may not get a happy ending, that sense of perseverance gives us a glimmer of hope at the end of the day.