+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2023-07-24T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1690230489/sqDMMO-Oranges-Catherine_Martin_as_Clarice_Alexander_Birch_Elliott_as_L%C3%A9andre_Sun-Ly_Pierce_as_Sm%C3%A9raldine.jpg"
primary_image_credit = "Catherine Martin as Clarice, Alexander Birch Elliott as Léandre and Sun-Ly Pierce as Sméraldine in Des Moines Metro Opera's production of The Love for Three Oranges, 2023. Photo: Duane Tinkey."
related_articles = ["articles/dmmo-bluebeard.md", "articles/dmmo-carmen.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = [""]
short_description = "Every scene was controlled chaos, and despite the insanity onstage, I couldn't look away."
slug = "an-absolute-triumph-of-comedy-dmmos-love-for-three-oranges"
title = "An absolute triumph of comedy: DMMO's Love for Three Oranges"
youtube_url = ""

+++
[Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) ventured into the whimsical and absurd with their production of Prokoviev's [_The Love for Three Oranges_](https://desmoinesmetroopera.org/productions/oranges/). The farcical fairy tale is a rarely performed operatic treat, a light hearted contrast to the rest of their summer season that had the audience chuckling from start to finish.

The playful humor of this opera was evident before the music even began. The audience was welcomed to a vibrant vaudeville stage, a set full of amusing details and hints of the chaos to come. Jacob A. Climer captured the essence of this theatrical setting in both the scenic and costume designs. The sheer variety of characters and costumes was overwhelming at times–medieval villains, colorful cowboys, boxing bears, showgirl princesses, commedia dell’arte clowns, and more! Brittany V.A. Rappise's hair and makeup designs were equally extravagant and fun, inspired by iconic theatrical looks. There was never a dull moment, and despite the volume of roles required for this singular show, the attention to detail was consistent throughout, the most minor characters just as visually stunning as the leads.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690230488/DMMO_Oranges-Christopher_Sokolowski_as_the_Prince_in_Des_Moines_Metro_Opera_s_The_Love_for_Three_Oranges_photo_by_Duane_Tinkey.jpg){{% /md %}}

<figcaption>Christopher Sokolowski as the Prince in Des Moines Metro Opera's production of The Love for Three Oranges, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Connie Yun's lighting design enhanced the ever changing world of the opera, capturing the chimeric moods of the plot. The primary constant onstage was a large sign reading "VAUDEVILLE" which would light up in varying colors, and when the villains graced the stage, only the letters "EVIL" or "DEVIL" would glow in sinister green or red, an amusing detail that never failed to make the audience laugh. 

Climer's scenic designs struck just the right balance between realistic and bizarre. The theatrical setting of the opera worked in favor of the disjointed narrative, and any idiosyncrasies that occurred with the performance felt intentional for this very reason. I often found myself baffled when new oddities emerged, such as a hot pink buffalo rising from the stage or giant ladle wielding puppet, but in this production, the constant confusion just worked. The story and the production kept the audience guessing in a way that was engaging and fun. _The Love for Three Oranges_ is the kind of opera that you could watch numerous times, and you would discover something new about it each time…even if you still wouldn't understand it any better.

The orchestra navigated Prokoviev's sprightly yet deceptively tricky composition under the baton of Michael Sakir. The music underpinned the comedic antics with complex nuance, and despite the potential pitfalls, the collaboration between the instrumentalists and the vocalists was absolutely seamless. Prokoviev's score was pleasing overall but not particularly memorable. I didn't leave humming any catchy tunes nor was I blown away by any vocal fireworks, but the music served the narrative well enough.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690230488/DMMO_Oranges-Alexander_Birch_Elliott_as_L%C3%A9andre_Catherine_Martin_as_Clarice_Alexandra_LoBianco_as_Fata_Morgana_Sun-Ly_Pierce_as_Sm%C3%A9raldine.jpg){{% /md %}}

<figcaption>Alexander Birch Elliott as Léandre, Catherine Martin as Clarie, Alexandra LoBianco as Fata Morgana, and Sun-Ly Pierce as Sméraldine in Des Moines Metro Opera's production of The Love for Three Oranges, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

_The Love for Three Oranges_ is truly an ensemble piece, and the supporting cast played an integral role in the production. The chorus, supernumeraries, and dancers were the cohesive force that held an otherwise disjointed tale together. Their comedic antics provided a lively backdrop for the main characters and produced plenty of laughs from the crowd. The dancers in particular embodied a variety of wacky characters, and Isaac Martin Lerner's choreography embraced the absurdity of each situation with gusto. Most importantly, I could sense that each performer onstage was genuinely enjoying themselves, and because even the most minor characters were having fun, so did the audience.

This opera had a lot of characters, and sometimes it was difficult to remember how they each fit into the topsy turvy tale. It began simply enough with the King of Clubs and his advisor Pantalon, portrayed by Scott Connor and Benjamin Taylor respectively. These two characters welcomed the audience into the satirical fairy tale and set up the premise of the hijinks to come. Connor and Taylor captured both the sincerity and comedy of these roles, their performances grounded by solid vocal deliveries. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690230488/DMMO_Oranges-Michael_Porter_as_Trouffaldino_and_Benjamin_Taylor_as_Pantalon.jpg){{% /md %}}

<figcaption>Michael Porter as Trouffaldino and Benjamin Taylor as Pantalon in Des Moines Metro Opera's production of The Love for Three Oranges, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

I have to admit that the villains really stole the show, and there are plenty of scoundrels to spare in this story. The primary antagonists were a delightful trio consisting of Alexander Birch Elliot as Léandre, Catherine Martin as Clarice, and Sun-Ly Pierce as Sméraldine. These three never failed to crack up the audience every time they graced the stage. Birch Elliot was constantly leering and creeping around the stage, and before he even sang a note, you could tell the prime minister was up to no good. Martin’s presence was manipulative and overbearing in contrast, the instigator set to benefit most from the Prince's demise. Pierce rounded out the group as the servant of Fata Morgana, carrying out their scheme with sinister glee. Birch Elliot, Martin, and Pierce all sang their roles with playful maliciousness that was reminiscent of classic cartoon villains, an approach that was perfect for this campy opera.

As with any proper fairytale, there was a magical element driving the plot. In this opera, the magician Tchélio, sung by Anthony Reed, and the witch Fata Morgana, sung by Alexandra LoBianco, were locked in a card game (literally and figuratively) to determine the fate of the Prince. Reed portrayed Tchélio as a doddering but well meaning magician whose illusions often fall short but whose interventions eventually saved the day. LoBianco was outrageously wicked as Fata Morgana, vacillating between malevolent and ridiculous. Her powerful vocals and outlandish cackles resounded in the theater, and the soprano clearly enjoyed the opportunity to be the baddie for a change.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690230488/DMMO_Oranges-Flora_Hawk_as_Ninette_and_Christopher_Sokolowski_as_the_Prince_in_DMMO_s_The_Love_for_Three_Oranges.jpg){{% /md %}}

<figcaption>Flora Hawk as Ninette and Christopher Sokolowski as the Prince in Des Moines Metro Opera's production of The Love for Three Oranges, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

As the Prince went on his adventures, he encountered even more strange beings along the way. Farfarello, sung by José Olivares, was a demon who conjured winds to aid the hero on his quest. Olivares made the most of this brief role, garnering quite a few chuckles as he brandished his red feathered fans. Matt Boehler sang the role of the Cook, a larger than life character that was portrayed with the aid of puppetry. Boehler was a particular favorite with the audience, decked out in cabaret makeup and pink glitter as the disembodied puppeted hands threatened the heroes with a giant ladle. Boehler demonstrated his vocal and expressive versatility, and his exaggerated acting elicited some of the biggest laughs of the night–no mean feat considering he was only onstage for a single scene. I would love to see what the bass could manage if given the opportunity to sing a lengthier buffo role.

No fairytale would be complete without a princess, and this satirical story comes with three: Linette sung by Ariana Maubach, Nicolette sung by Maggie Reneé, and Ninette sung by Flora Hawk. Unfortunately for the first two princesses, their time was fleeting, but Maubach and Reneé had the audience chuckling through their comedic death scenes, their performances charming however short lived. Ninette managed to survive long enough to get a happy ending with the Prince, however, and Hawk provided the bright bubbly vocals and humorous delivery to win her beloved as well as the hearts of the audience. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690230489/DMMO_Oranges-Christopher_Sokolowski_as_the_Prince_and_Michael_Porter_as_Trouffaldino.jpg){{% /md %}}

<figcaption>Christopher Sokolowski as the Prince and Michael Porter as Trouffaldino in Des Moines Metro Opera's production of The Love for Three Oranges, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

At the center of this farcical adventure lies a buddy comedy, a series of hijinks shared by the Prince and the court jester Trouffaldino. Michael Porter sang the role of Trouffaldino with infectious charm, and ironically enough, his clownish character was often the voice of reason as he accompanied the besotted Prince on his quest. Porter nailed the physical comedy required for the role, and the scene where he evaded the killer Cook was a particular crowd pleaser. 

Christopher Sokolowski was delightful and suitably silly as the Prince. This ridiculous royal began the opera as a melancholy hypochondriac then found himself on the wrong end of a witch’s curse which had him falling madly in love with three oranges. Sokolowski navigated the ever changing and equally absurd moods of the Prince with finesse, and his chemistry with Porter brought a playful energy to an otherwise confusing narrative. Sokolowski's heroic tenor voice turned the hapless Prince into a compelling hero, his clear tone and skillful technique making the most of Prokoviev's score. Anyone who can successfully navigate an entire quest in bunny slippers has my respect!

Considering this opera has a plethora of crazy characters and an absolutely bananas plot line, it runs the risk of overwhelming the audience or losing them entirely. Rather than trying to work against these elements, however, stage director Chas Rader-Shieber embraced the nonsensical joy, and the end result was an absolute triumph of comedy. Every scene was controlled chaos, and despite the insanity onstage, I couldn't look away.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690230488/DMMO_oranges-Anthony_Reed_as_Tch%C3%A9lio_and_Alexandra_LoBianco_as_Fata_Morgana.jpg){{% /md %}}

<figcaption>Anthony Reed as Tchélio and Alexandra LoBianco as Fata Morgana in Des Moines Metro Opera's production of The Love for Three Oranges, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Des Moines Metro Opera's production of _The Love for Three Oranges_ was an unexpected treat and a celebration of absurdity, featuring a remarkable cast all too willing to showcase the weird and wonderful musical satire. I was truly surprised by this lesser known comedic work. Did I have any idea what was going on for most of the opera? No. But did I have fun watching it? Heck yes! Would I go see it again? Absolutely!