+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2019-07-01T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Des Moines Metro Opera's [production of _La bohème_](http://desmoinesmetroopera.org/productions/boheme/) runs through July 21."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1562029435/media/2019/07/sqDMMOBohemeDSC_4076.jpg"
primary_image_credit = "La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera."
related_articles = ["articles/a-fiercely-queer-opera-for-halloween.md", "articles/hype-atg-boheme.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/joshua-guerrero.md"]
short_description = "The main factor that makes or breaks a production of La bohème is the cast. The six lead characters must have comedic timing, dramatic chops, and believable chemistry. This opera is so popular precisely because all the characters are realistic and likeable."
slug = "bring-your-tissues-to-dmmos-la-boheme"
title = "Bring your tissues to DMMO's La bohème"
youtube_url = ""

+++
[Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) delivers an archetypal production of [Puccini's _La Bohème_](http://desmoinesmetroopera.org/productions/boheme/) for their 47th summer season. This beloved opera has been a fan favorite for decades, and while there have been many interpretations that modernize the setting (such as outer space or hipsters?), sometimes the standard approach is best. Audiences have romanticized the bohemian lifestyle and the Latin Quarter for so long that it has become a timeless aesthetic, so why change something that already works?

The design teams created a classic production that felt familiar and realistic. From the impoverished intimacy of the artists' apartment to the bustling chaos at Café Momus, the scenery, lighting, costumes, hair, and make up all combined to create a cohesive environment for Puccini's beloved characters to inhabit.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562029495/media/2019/07/DMMOBohemeDSC_3864.jpg){{% /md %}}

<figcaption>La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

The chorus under the direction of Lisa Hasson sparkled onstage in Act II, capturing the lively charm of the holidays in Paris. At times the space felt a bit congested with the chorus in full force, but I also wish more of them had remained onstage for all the Café Momus scenes to create a backdrop of activity behind the main characters. Even if they are not needed to sing, a chorus of strong actors can enhance a scene dramatically, and it just didn’t feel like the busy streets of Paris without the constant presence of people.

Conductor [Michael Christie](/talking-with-conductors-michael-christie/) led the orchestra in a quintessential performance of Puccini’s beautiful music. There were a few moments where the ensemble overpowered the singers, but the balance got better as the opera progressed. Puccini's orchestration is equal parts powerful and vulnerable, and without the instrumental underpinning, much of the raw emotional impact would be lost. (When I cried in the final scene, I hold the orchestra as partially to blame for my smudged eyeliner!)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562029465/media/2019/07/DMMOBohemeDSC_3773.jpg){{% /md %}}

<figcaption>La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

The main factor that makes or breaks a production of _La bohème_ is the cast. The six lead characters must have comedic timing, dramatic chops, and believable chemistry. This opera is so popular precisely because all the characters are realistic and likeable.

>These four bros give each other shit constantly, but they also aren't afraid to call each other out on their bullshit.

The poor bohemians are funny and flawed, and while they are sometimes pitted against landlords and dinner tabs, there are no true villains (unless you count TB). Matthew Lau portrayed both Benoit and Alcindoro, the financially stable old men that get duped by the starving artists. Lau demonstrated clever comedic acting as well as a strong vocal performance which made both men come across as affable despite their apparent opposition to the main characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562029476/media/2019/07/DMMOBohemeDSC_2646-1.jpg){{% /md %}}

<figcaption>La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

The four male friends - Rodolfo, Marcello, Colline, and Schaunard - had a convincing connection onstage together. The opera may take place centuries ago, but the nature of true friendship has remained the same. These four bros give each other shit constantly, but they also aren't afraid to call each other out on their bullshit. The staging between these men was often physical and playful which was a welcome relief from the more tragic moments. (I do have to complain, however, that it felt absurd that these famished artists would use their last loaf of bread for a food fight. Hunger outweighs humor every time!)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562029511/media/2019/07/DMMOBohemeDSC_2091.jpg){{% /md %}}

<figcaption>La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Brian Vu sang the role of Schaunard the musician with a charming energy. He relished the drama as a spectator at Café Momus and mastered the art of the snarky sidebar comments to Colline at Marcello's expense. Timothy J. Bruno brought comedic charisma to the role of Colline, and he delivered a touching somber aria in the final act with vocal gravitas.

>We've all known couples like this who break up and get back together again every other week, and like Schaunard and Colline, we just stop trying to figure out what the current relationship status is.

Thomas Glass had impressive vocal chops and was a solid dramatic presence throughout the opera as the painter Marcello. It truly is a shame that his character is the only one without an aria. Glass showed a strong acting range, playful and bold with his friends then passionate and temperamental with his lover. I wish the staging had highlighted some of his more tender interactions with Musetta, particularly in the final scenes, to show that underneath all their drama, real love is present.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562029528/media/2019/07/DMMOBohemeDSC_2313.jpg){{% /md %}}

<figcaption>La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Mané Galoyan sang the role of Musetta like a fiery, fickle coquette. She had men _literally_ falling at her feet during the famous "Quando m'en vo" aria which felt a little too on the nose, and while her vocal delivery was gorgeous, I wish they had given her more interesting staging during this crucial scene. Galoyan clearly could have conveyed the magnetic seductive powers of Musetta, but it just didn't come across.

Together Galoyan and Glass created a textbook portrayal of the toxic couple in the friend group. We've all known couples like this who break up and get back together again every other week, and like Schaunard and Colline, we just stop trying to figure out what the current relationship status is. Marcello and Musetta might not have the healthiest relationship, but in spite of all their bickering, we're rooting for them.

>Joshua Guerrero was lovable and heart wrenching as the lovelorn poet, Rodolfo.

In stark contrast is the overly in love, super mushy couple in the friend group that kind of makes you sick. Rodolfo and Mimì are already madly in love on day one of their relationship, and while their friends tease them about the poetic declarations, they accept Mimì into their circle immediately.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562029541/media/2019/07/DMMOBohemeDSC_2037.jpg){{% /md %}}

<figcaption>La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Julie Adams performed the role of the tragic heroine, Mimì, with a velvety vocal tone. Unfortunately, compared to her lively companions, Adams' Mimì came across as a bit bland and reserved in the second act. The soprano started to come out of her shell more in last two acts, especially on her deathbed, but I didn't get emotionally invested in Mimì from the start, which lessened the impact of her demise. I realize that Mimì is more guarded than her lover, but when Rodolfo is pouring his guts out, I just wanted a little more from her. Hopefully as the season progresses, their romantic dynamic will blossom further.

[Joshua Guerrero](/scene/people/joshua-guerrero/) was lovable and heart wrenching as the lovelorn poet, Rodolfo. His rendition of "Che gelida manina" started out timid and vulnerable then built up to the glorious high notes. I had trouble hearing him over the orchestra in his lower register at times, but the balance seemed to get corrected by the second act. Rodolfo is a character that bears his soul eagerly. He's madly in love with Mimì right away, but he also exhibits some big red flags from the start. His jealousy rears its ugly head on their first date, so we can tell it's not going to be the most stable relationship. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1562029554/media/2019/07/DMMOBohemeDSC_1979.jpg){{% /md %}}

<figcaption>La bohème, Des Moines Metro Opera, 2019. Photo: Duane Tinkey for Des Moines Metro Opera.</figcaption>

</figure>

Despite his flaws, Rodolfo's primary concern is Mimì's well-being (even if he is terrible at communicating it). Guerrero's raw emotional performance in combination with Puccini's moving orchestration was what ultimately pushed me over the edge and brought me to tears in the finale. It's a recipe for success: tragic tenor + swelling instrumentals = cathartic release. (Damn you, Puccini.)

> Regardless of all the other factors in a production, Puccini's music remains at the heart of it.

_La bohème_ is a lot like the pumpkin spice latte for me. I feel kind of like a basic bitch for admitting that I love it so much, but it never fails to satisfy. I know what I'm getting, and I know I’m going to enjoy it. Puccini's music always delivers, and he will always make me cry as Mimì dies in Rodolfo's arms. Regardless of all the other factors in a production, Puccini's music remains at the heart of it, and that is exactly why we keep coming back for more. 

If you're also a basic bitch looking for your tragic operatic fix, then I highly recommend that you catch one of Des Moines Metro Opera's [remaining performances](http://desmoinesmetroopera.org/productions/boheme/) of the musical masterpiece. Make sure to bring your tissues!