+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2023-07-24T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1690231434/sqDMMO_Rising-Tess_Altiveros_as_the_Soldier.jpg"
primary_image_credit = "Tess Altiveros in Des Moines Metro Opera's production of The Falling and the Rising, 2023. Photo: Duane Tinkey."
related_articles = ["articles/dmmo-bluebeard.md", "articles/dmmo-carmen.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/tess-altiveros.md"]
short_description = "While this contemporary work has had several productions in recent years, these two performances are the first to take place on an active military base, a location that makes the touching story all the more poignant."
slug = "dmmos-the-falling-and-the-rising-forces-you-to-feel"
title = "DMMO's The Falling and the Rising forces you to feel"
youtube_url = ""

+++
[Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) demonstrated once again their commitment to partnering with the community with their production of [_The Falling and the Rising_](https://desmoinesmetroopera.org/productions/rising/). This opera is the company's third collaboration with the Iowa National Guard, and while this contemporary work has had several productions in recent years, these two performances are the first to take place on an active military base, a location that makes the touching story all the more poignant.

_The Falling and the Rising_ is one of multiple recent operas exploring the experiences of soldiers. The inspiration for this opera was conceived by Sergeant First Class Benjamin Hilgert, an idea that led to the first opera commissioned by the US Army Field Band and Soldiers' Chorus. Hilgert then worked with composer Zach Redler and librettist Jerre Dye to interview real soldiers. The stories they heard were incorporated into the opera, and that veracity brought emotional weight to the piece. 

The production design was fairly utilitarian, a fitting choice for a military setting. Costumes and hair/makeup, by Ashleigh Poteat and Margaret Sackman respectively, fell within the real world regulations of the army. The singers wore an assortment of uniforms, ranging from fatigues to scrubs to more ceremonial attire. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690231434/DMMO_Rising-Matt_Boehler_as_Colonel.jpg){{% /md %}}

<figcaption>Matt Boehler as the Colonel in Des Moines Metro Opera's production of The Falling and the Rising, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Adam Whittridge's scenery consisted of scaffolding draped in camo netting which provided a monochromatic backdrop to the drama. A large humvee, loaned to the production by the National Guard, added a sense of legitimacy to the minimalist set, and the incorporation of television screens provided another layer of visual stimulation throughout the opera. The Soldier must rely on technology to stay connected to her daughter, and when she went into a coma, the screens continued to act as a tether to the real world as she navigated toward recovery. Bridget S. Williams' lighting design accentuated the lows and highs experienced during this journey, disorienting and surreal at times and soft and subdued at others. 

Joshua Borths staging demonstrated the strength of simplicity. He utilized the small cast in a versatile manner that allowed the audience to focus on each scene, supporting the emotions rather than distracting from them. Borths maintained a narrative thread throughout the Soldier's journey, stringing the various stories together through her discovery of dog tags across the stage. His creative incorporation of the military props was clever and refreshing. One particularly memorable scene had three of the singers using a parachute to mimic the clouds, evoking the weightless wonder with an otherwise practical piece of equipment. I have to commend Borths for understanding how to let Redler's and Dye's emotional opera soar without weighing it down.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690231434/DMMO_Rising-Tess_Altiveros_as_Soldier_and_Sam_Mathis_as_Jumper.jpg){{% /md %}}

<figcaption>Tess Altiveros as Soldier and Sam Mathis as Jumper in Des Moines Metro Opera's production of The Falling and the Rising, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

The orchestra brought Redler's stunning score to life under the baton of Michael Sakir. The small ensemble delivered big emotions in the intimate space, uplifting the equally stirring performances of the vocalists. Redler's music was invigorating and often epic, and the experience reminded me of why I love opera so much–the art form's unrivaled ability to evoke staggering emotions across the spectrum. _The Falling and the Rising_ grasped the audience by the heart and didn't let go for eighty minutes straight.

Des Moines Metro Opera assembled an outstanding cast for this production. All five singers delivered touching performances, proving their acting skills as well as their vocal prowess. This opera is truly an ensemble piece which relies on the four supporting singers to embody multiple characters throughout the Soldier's comatose odyssey. The group worked as a cohesive unit, connecting to each other and the audience in a performance that packed an emotional punch.

Sun-Ly Pierce portrayed Toledo, the first character the Soldier encounters as her brain grapples with her medically induced coma. Pierce brought a commanding presence to the role of Toledo, her brassy and sassy vocal delivery adding to her physical swagger. Pierce managed to capture the compelling dichotomy of the character, delivering both the defensive attitude and the raw pain hidden beneath it. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690231434/DMMO_Rising-Sankara_Harouna_as_Homecoming_Soldier.jpg){{% /md %}}

<figcaption>Sankara Harouna as Homecoming Soldier in Des Moines Metro Opera's production of The Falling and the Rising, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

The Soldier next encounters Jumper, sung by Sam Mathis. Mathis' uplifting tenor voice was well suited to the skydiving soldier, his vocals shimmering as his character floated above the clouds. Jumper provided some much needed optimism and humor amid the heavier emotions of the opera, and Mathis buoyed the spirits of the audience like a breath of fresh air.

I feel personally victimized by Matt Boehler’s performance as the Colonel. No one told me I needed to bring tissues to this opera! Boehler delivered a gut wrenching portrayal of love and grief, a vocal and dramatic delivery that had the audience in tears. Boehler sang with compelling versatility, his bold bass voice capable of illustrating tender sorrow and excruciating anguish within a single phrase. Truly a stellar scene that left the crowd stunned by the end, a symphony of sniffles audible throughout the darkened room.

As the Soldier nears the end of her journey, she meets the Homecoming Soldier, sung by Sankara Harouna. Harouna's rich and soulful tone was well suited to the scene, delivering some of the most impactful lines of the opera as an injured soldier trying to adjust to his new reality. Harouna was a calm and grounding presence on the stage, and his character brought an understated wisdom after a series of tumultuous emotions–a wisdom based on the words of real soldiers and their experiences.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690231434/DMMO_Rising-Matt_Boehler_as_Colonel.jpg){{% /md %}}

<figcaption>Matt Boehler as Colonel in Des Moines Metro Opera's production of The Falling and the Rising, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Tess Altiveros originated the role of the Soldier, and her deep connection to this character was evident as soon as she stepped onstage. Altiveros' soaring soprano voice was warm and pliant, excelling in Redler's evocative score. Her understanding of the Soldier's complex and nuanced transformation was undeniable, and she conveyed the character's many conflicting emotions with a convincing sincerity that gripped the heart. Altiveros shone bright in her solo moments, but she also complimented her fellow singers, matching their energy and providing cohesive vocals for every scene. You could feel Altiveros' passion for this opera and her dedication to sharing these true stories with the audience. I hope she will continue to share that passion in many more productions to come.

As if the opera hadn't already emotionally bombarded the audience, the finale upped the ante even more. A chorus of active military members and veterans, under the direction of Zach Rohlwing, joined the cast onstage for the final number, and the impact of that moment was astounding. Redler's music and Dye's words were already powerful enough on their own, but hearing it through the voices of actual soldiers added a deeper layer of meaning to it. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1690231434/DMMO_Rising-Tess_Altiveros_as_Soldier_and_Matt_Boehler_as_Colonel.jpg){{% /md %}}

<figcaption>Tess Altiverso as Soldier and Matt Boehler as Colonel in Des Moines Metro Opera's production of The Falling and the Rising, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

As always with their Second Stages Series, Des Moines Metro Opera finished the evening with a post show panel featuring local community participants. The audience got to hear the reactions of real soldiers after the opera which further grounded the narrative. Sergeant First Class Benjamin Hilgert was also present for opening night, and it was particularly meaningful to hear his story on the conception of the opera as well as his experiences interviewing the soldier’s that inspired it. 

Des Moines Metro Opera's production of _The Falling and the Rising_ was truly an unexpectedly emotional experience. The power of music to touch the soul is woven into the opera, a cathartic blend of love, sorrow, and resilience. I hope that the operatic world will see more from Zach Redler and Jerry Dye in the future, because their first full length collaboration is astounding. If you're looking for a contemporary opera that forces you to feel something, then look no further. [_The Falling and the Rising_](https://desmoinesmetroopera.org/productions/rising/) will bring you along for the emotional ride, lifting to you new heights and dropping you to new depths. Just remember to bring some tissues with you!