+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2023-07-18T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = "_dwb (driving while black)_ is onstage through July 21. [Find full details here](https://desmoinesmetroopera.org/productions/dwb/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1689688005/sqDMMO_dwb_Roberta_Gumbel_as_the_Mother_photo_by_Luke_Behaunek_4.jpg"
primary_image_credit = "Roberta Gumbel as The Mother in Des Moines Metro Opera's production of dwb (driving while black), 2023. Photo: Luke Behaunek."
related_articles = ["articles/dmmo-bluebeard.md", "articles/dmmo-carmen.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = [""]
short_description = "White audience members were challenged to confront the discomfort brought on by the opera and the discussion, to sit with the trauma as black individuals must each and every day."
slug = "sharing-the-burden-dwb-driving-while-black"
title = "Sharing the burden: dwb (driving while black)"
youtube_url = ""

+++
[Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) brought a powerful contemporary narrative to their 2nd Stages Series this summer with their production of [_dwb (driving while black)_](https://desmoinesmetroopera.org/productions/dwb/). This stirring musical experience evoked complex emotions, proving once again that art and music have the power to transcend divisions and promote empathy within the community.

Composer Susan Kander and librettist Roberta Gumbel first conceived the idea for _dwb (driving while black)_ when they were discussing Roberta's son acquiring his driving permit and her resulting fears. This experience is one shared by black parents across the nation, a trauma that must be relived every time they or their loved ones get behind the wheel. Kander and Gumbel channeled these maternal anxieties into a stunning 45-minute monodrama, featuring a soprano, cellist, and percussionist – an intimate musical experience that speaks to the dangers of being black in America.

Roberta Gumbel portrayed the mother at the center of this moving story, a meaningful performance heightened by the fact that she was sharing her own personal experiences with the audience. It is rare to see the librettist sing their own words, and this detail brought a special nuance and emotional weight to the opera. Gumbel bared her soul onstage. She utilized an array of vocal styles to convey the complex emotional palette of the mother's journey. Ranging from playful anticipation to raw grief, Gumbel demonstrated her vocal prowess and dramatic skills. She made the audience laugh and cry alongside the mother as she grappled with the joys and fears of watching her son grow up in a dangerous world. Truly a powerhouse performance supported by a deeply personal connection to the text.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1689688005/DMMO_dwb_Roberta_Gumbel_as_the_Mother_with_Cremaine_Booker_cello_and_David_Leon_Verin_percussion_photo_by_Luke_Behaunek1.jpg){{% /md %}}

<figcaption>Roberta Gumbel as The Mother with Cremaine Booker, cellist, and David Leon Verin, percussion, in Des Moines Metro Opera's production of dwb (driving while black), 2023. Photo: Luke Behaunek.</figcaption>  
</figure>

Cellist Cremaine Booker and percussionist David Leon Verin played equally crucial roles to the musical and dramatic tapestry of the opera. The performance was a true collaboration between three musicians. The instrumentalists were not merely there to support the singer. Booker and Verin often spoke or sang parts of the dialogue, interacting with Gumbel throughout the story. 

Kander's composition required the instrumentalists to perform unorthodox techniques to evoke the narrative's emotions, such as deflating balloons or utilizing their own bodies as percussive instruments. These unexpected methods added a rich variety of timbres and textures to the opera. Kander's orchestration proves how to get the most out of a small ensemble, especially when the score is in the hands of musician's as skilled as Gumbel, Booker, and Verin. _dwb (driving while black)_ may appear minimalist on paper, but there was nothing sparse about the evocative performance. 

The production design for the monodrama was also efficient but effective. This was partially out of necessity as each of the four performances took place in different locations, but this decision also allowed the audience to focus on the emotional weight of the narrative with little distraction. Chip Miller kept the staging simple, all the movement revolving around a small platform and four chairs representing the focus of the mother's fears – the car.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1689688005/DMMO_dwb_Roberta_Gumbel_as_the_Mother_photo_by_Luke_Behaunek.jpg){{% /md %}}

<figcaption>Roberta Gumbel as the Mother in DMMO's production of dwb (driving while black), 2023. Photo: Luke Behaunek.</figcaption>  
</figure>

This setting is familiar to us all, but the danger it poses to black Americans is not one shared by everyone in the audience. Each time the mother got into this symbolic vehicle with her son, we were confronted by her growing fears. Even mundane drives can lead to death if something goes wrong, and _dwb (driving while black)_ forces the white members of the audience to confront their privilege as they watch the mother's journey and hear real stories of the trauma black men and boys have suffered. Trauma that will continue if we fail to dismantle the systems of oppression that enable this cycle to continue. 

Perhaps the most important aspect of Des Moines Metro Opera's 2nd Stages Series is the post-show panel discussion. After the opera, the audience was invited to return and engage with a panel of local black community leaders and activists to discuss the message of the show and their reactions to it. This dialogue was just as emotionally powerful as the production itself. The panelists and black audience members were able to share the way _dwb (driving while black)_ impacted them as well as their lived experiences that mirrored the mother's story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1689688006/DMMO_dwb_Roberta_Gumbel_as_the_Mother_photo_by_Luke_Behaunek_2.jpg){{% /md %}}

<figcaption>Roberta Gumbel as the Mother in DMMO's production of dwb (driving while black), 2023. Photo: Luke Behaunek.</figcaption>
</figure>

White audience members were challenged to confront the discomfort brought on by the opera and the discussion, to sit with the trauma as black individuals must each and every day. As a white woman, there were sobering moments that made me realize my ignorance and privilege, but I found myself embracing those difficult emotions as I listened to the stories of black members of my community. The overall atmosphere of the conversation was one of hope. Despite the dangers and difficulties built into our society, each of the panelists expressed a true belief that change can be achieved. They were optimistic in the face of adversity, and at the end of the day, they emphasized the need for empathy and advocacy. The black community cannot bear the burden alone. We must all speak up to change our community for the better.

Des Moines Metro Opera proved once again their willingness to highlight narratives that are relevant to local audiences. Their production of _dwb (driving while black)_ was a potent demonstration of the power of music to get to the heart of the human experience and to bring diverse people together. At the end of the day, the memories of the emotional narrative will continue to linger in the audience's mind, and hopefully, those memories will inspire each person to push for change in their own communities, to make the fears at the center of this opera irrelevant for generations to come.
