+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2023-07-04T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1688479837/sqTaylor-Raven-as-Carmen-with-Matthew-Cairns-as-Don-Jos%C3%A9-in-Act-IV-of-Bizet_s-Carmen_-photo-by-Duane-Tinkey.jpg"
primary_image_credit = "Taylor Raven as Carmen with Matthew Cairns as Don José in Des Moines Metro Opera's production of Carmen, 2023. Photo: Duane Tinkey."
related_articles = ["articles/pov-carmen.md", "articles/an-absolute-triumph-koskys-carmen.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/matthew-cairns.md", "scene/people/brenna-corner.md", "scene/people/taylor-raven.md"]
short_description = "Carmen is an audience favorite for a reason, so why change what already works? The historical setting is familiar and expected, but the themes of this passionate tale still hit hard."
slug = "des-moines-metro-opera-offers-musically-triumphant-carmen"
title = "Des Moines Metro Opera offers musically triumphant Carmen"
youtube_url = ""

+++
[Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/) overcame an _alarming_ opening night with [their production of Bizet's _Carmen_](https://desmoinesmetroopera.org/productions/carmen/), and I mean that literally! The fire alarm went off about two thirds of the way into the second act of the opera, and the entire building was forced to evacuate until the fire department arrived. Once it was deemed safe to return, the rendezvous at Lillas Pastia's resumed, and the audience was seamlessly transported back to Seville. Truly the cast, orchestra, and crew must be commended for their unfaltering professionalism in the face of adversity. Despite the unexpected intermission, the drama _onstage_ reigned supreme.

Des Moines Metro Opera chose to go with a traditional aesthetic for this production. _Carmen_ is an audience favorite for a reason, so why change what already works? The historical setting is familiar and expected, but the themes of this passionate tale still hit hard. 

The scenic design by David P. Gordon was the perfect balance of vibrant and gritty. The world Carmen occupies is one of stark contradictions, and the visual environment reflected that. The chimeric emotions of the story were accentuated by the lighting, designed by Kate Ashton. The audience could feel the sweltering heat of sunny Seville in one scene and the tense chill of the smuggler's mountain camp the next. The use of spotlights in particularly dramatic moments was effective, drawing the eye to Carmen and Don José against a startling red backdrop – ominously foreshadowing their tragic fates.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688479837/The_chorus_of_CARMEN_photo_by_Duane_Tinkey.jpg){{% /md %}}

<figcaption>The chorus of Des Moines Metro Opera's production of Carmen, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

The costume design for the production presented a rich color palette to match the lively crowds of Seville. Brittany V.A. Rappise's hair and makeup designs were flawless, flattering to each member of the diverse cast. From the scruffy street urchin to the preening matadors, each character was believable and visually intriguing. I did wish that both Carmen and José would visually stand out from the crowd a bit more, especially in the first two acts. Carmen in particular should command the audience's focus, but her garb did little to accentuate her magnetic personality. Designer Jacob A. Climer did deliver a stunning scarlet gown for the leading lady in the second half of the opera, and while Carmen is fated to die in the final act, she looked damned good as she took her final breath.

Conductor Kelly Kuo made his company debut, leading the orchestra in a colorful and nuanced performance of Bizet's beloved score. The chorus, under the direction of Lisa Hasson, provided a lively musical and dramatic backdrop for the main characters. The children's chorus, directed by Sandy Miller and Mary Craven Bartemes, was an audience favorite. Whether they were mimicking soldiers or cheering on bullfighters, the adorable gaggle was irresistibly charming. Some of Bizet's most infectious tunes occur in large ensemble scenes, and the choruses delivered stellar performances of each and every earworm.

Des Moines Metro Opera assembled a strong cast of singers for this production. Bizet's score is full of popular and familiar music, and expectations can be high as a result. However, each singer proved they had the vocal chops to live up to the hype. The singing was solid across the board. The cast also handled the French dialogue with convincing dramatic conviction, an aspect of this opera that can often fall short.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688479837/Taylor_Raven_as_Carmen_with_Matthew_Cairns_as_Don_Jos%C3%A9_photo_by_Duane_Tinkey.jpg){{% /md %}}

<figcaption>Taylor Raven as Carmen and Matthew Cairns as Don José in Des Moines Metro Opera's production of Carmen, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Sankara Harouna drew the audience into the story from the opening scene in the role of Moralès. With a strong and rich baritone voice, Harouna was a commanding presence, however, he seemed far too nice in his interactions with Micaëla. This scene is the first to highlight the misogyny woven throughout the narrative, and his invitation should at least be subtly threatening, even with a smile upon his face. 

In contrast, Allen Michael Jones' portrayal of Zuniga was palpably despicable. The bass sang with a simmering cruelty that made the skin crawl, interspersed with sudden glimpses of his rage. There is nothing subtle about Zuniga's misogyny, and Jones brought a captivating malevolence to a character that can often be overlooked.

Carmen's smuggling companions provided some much needed levity to an otherwise dark tale. Ryan Wolfe and Daniel Esteban Lugo sang the roles of Dancaïro and Remendado with humor and just the right touch of danger. They were particularly delightful in the [infamous smugglers' quintet](/the-elton-john-act-iv-fiddly-for-the-fingers-the-smugglers-quintet-from-carmen/) in act two, and this ensemble number brought an effervescent energy that felt like a breath of fresh air. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688479837/Ryan_Wolfe_as_Dancairo_Allen_Michael_Jones_as_Zuniga_Daniel_Esteban_Lugo_as_Remendado_in_Act_II_of_CARMEN_photo_by_Duane_Tinkey.jpg){{% /md %}}

<figcaption>Ryan Wolfe as Dancaïro, Allen Michael Jones as Zuniga, and Daniel Esteban Lugo as Remendado in Des Moines Metro Opera's production of Carmen, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Their female companions, Frasquita and Mercédès, sung by Emma Marhefka and Imara Miles, delivered mischievous charm every time they graced the stage. Even when they were relegated to the background, the two women captured the eye. Marhefka and Miles showed off their vocal prowess in the well-known card trio of act three, and their contrasting vocal tones were a complimentary musical combination. Both singers nailed the comedic aspects of their roles, but they also displayed deeper emotions, particularly in the final act as they plead with Carmen to steer clear of her crazy ex. Frasquita and Mercédès are the only voices of reason in the face of the impending tragedy.

Micaëla provides a foil to the titular seductress of the opera. Sometimes this good girl character can come across as a bit flat and boring compared to her rival, but Yunuet Laguna brought a quiet and compelling strength to the role. Laguna gave a glorious vocal performance, especially in her powerful upper register. Some of the lower vocal lines didn't pack the same punch as her high notes, but any inconsistencies were forgotten as she soared above the orchestra. Her third act aria was one of the highlights of the night, giving the audience chills with a performance that was both musically and emotionally stunning.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688479837/Emma-Marhefka-as-Frasquita-and-Imara-Miles-as-Merc%C3%A9d%C3%A8s-in-Act-III-of-Bizet_s-CARMEN_-photo-by-Duane-Tinkey.jpg){{% /md %}}

<figcaption>Emma Markefka as Frasquita and Imara Miles as Mercédès in Des Moines Metro Opera's production of Carmen, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Christian Pursell certainly brought swagger to the role of Escamillo, the famous toreador and Don José's rival for Carmen's heart. Pursell's Escamillo was a bit of a pretty boy with long flowing locks and a flashy sense of fashion. The baritone performed arguably the catchiest tune of the opera with his act two aria, strutting the stage like a true peacock. Pursell's vocal performance was satisfying, but I wanted him to turn up the machismo just a few more notches. The chemistry between Escamillo and Carmen led to the most convincing flirtation of the opera, and their interactions in the final act were surprisingly tender.

Matthew Cairns sung the role of Don José with technical skill and emotional nuance. His portrayal of José was a journey from insecure naivety to clingy obsession. Cairns seemed reserved in the first half of the opera, but we finally got a glimpse of José's mad passion in his act two aria. Considering he delivered this dramatic solo in the wake of the fire alarm chaos, Cairns' touching entreaty to his beloved was all the more impressive. The dynamic between Carmen and José lacked some of the feral attraction that makes his descent truly compelling. José is won over with a few gyrations and a singular passionate kiss. I wanted to feel the fire between them, but it felt like more of a glowing ember instead of a roaring blaze. Cairns did manage to deliver the crazed energy needed in the final act. José is both pathetic and dangerous as he begs Carmen to take him back, ultimately killing the very woman he desires when he cannot accept her rejection.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688479838/Christian_Pursell_as_Escamillo_with_Taylor_Raven_as_Carmen_in_Act_IV_of_CARMEN_photo_by_Duane_Tinkey.jpg){{% /md %}}

<figcaption>Christian Pursell as Escamillo with Taylor Raven as Carmen in Des Moines Metro Opera's production of Carmen, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Taylor Raven brought a controlled confidence to the role of Carmen. The mezzo soprano's voice was velvet smooth and surprisingly agile, perfectly suited to Bizet's music. She performed all three of Carmen's beloved arias with skill, but her rendition of the Seguidilla was the most captivating. I enjoyed Carmen's casual indifference in the first act. Often Carmen is portrayed as very physically seductive, but Raven's restrained magnetism seemed to emphasize just how little the character desires the attention of her many would-be suitors. It is only when she needs something from José that Carmen actively seduces him, and even then, the enamored tenor does most of the work for her. This indifference, however, did not work as well in the other acts of the opera. I wanted more sexual tension between the lovers, more push and pull physically and emotionally. A toxic relationship like theirs should be full of conflicting but powerful emotions. Carmen should run hot and cold with José, sometimes luring him then pushing him away. I can appreciate an interpretation of Carmen that doesn't focus entirely on her sexual power, but this interpretation seemed to downplay her seductive skills too much. Carmen should embrace her sexuality even if the men in her story do not.

The staging of this opera felt safe. Brenna Corner excelled at staging the ensemble scenes, bringing the streets of Seville to life in a way that was interesting without being distracting. I had forgotten how many fight scenes occur in this opera, and while Brian Robertson's combat choreography was well paced and not overly complicated, the performers were undermined by the intimacy of the theater. Many of the fights took place in the playing circle which is mere feet away from the audience, and the close quarters often produced unconvincing results. Carmen's escape from imprisonment felt particularly clumsy. Todd Rhoades choreographed the dance sequences of the opera, and while the singers performed the routines well enough, I felt that the scene at Lillas Pastia's inn would have been greatly enhanced by the use of a few professional dancers. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688479837/Taylor_Raven_as_Carmen_and_Matthew_Cairns_as_Don_Jos%C3%A9_in_Act_II_of_CARMEN_photo_by_Duane_Tinkey.jpg){{% /md %}}

<figcaption>Taylor Raven as Carmen and Matthew Cairns as Don José in Des Moines Metro Opera's production of Carmen, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

In general, I felt the production as a whole lacked a strong narrative stance. The story of _Carmen_ can be interpreted in many ways, offering an opportunity to comment on misogyny and feminism of the past and present. The lack of sexual energy in the staging neutered an opera that is renowned for its seductive qualities. I can get behind the idea of reining in the sexually explicit excesses of previous interpretations, but there are ways to convey the dangerous attraction between Carmen and José in a tasteful manner. We don't need to see Carmen fuck to know that she does. Even more perplexing was the decision to have José strangle Carmen instead of stabbing her. I'm not sure this choice did anything to enhance or change the narrative. Carmen burns bright, determined to live and die passionately. Instead, she was slowly smothered, the fight draining out of a woman known for being uncompromising. 

Overall, Des Moines Metro Opera's _Carmen_ was a musical triumph despite some underwhelming dramatic choices. The stellar cast and orchestra performed Bizet's cherished masterpiece with infectious energy and undeniable skill. Despite the alarming interruption, the evening was an auspicious beginning to the company’s 51st season.
