+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2023-07-04T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1688483242/sqViktoria_Vizin_as_Prologue_and_Sara_Gartland_as_Judith_with_the_three_dancers_photo_by_Duane_Tinkey.jpg"
primary_image_credit = "Viktoria Vizin as Prologue and Sara Gartland as Judith with the three dancers in Des Moines Metro Opera's production of Bluebeard's Castle, 2023. Photo: Duane Tinkey."
related_articles = ["articles/bluebeard-s-castle.md", "articles/in-review-bluebeards-castle-erwartung.md"]
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/christian-van-horn.md", "scene/people/sara-gartland.md"]
short_description = "Des Moines Metro Opera's cutting edge production of Bluebeard's Castle breathed new life into an underrated opera, blending the digital and traditional in a seamless immersive display."
slug = "dark-romance-psychological-horror-in-des-moines-metro-operas-bluebeard"
title = "Dark romance & psychological horror in Des Moines Metro Opera's Bluebeard"
youtube_url = ""

+++
[Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/)'s production of [Bartok's _Bluebeard's Castle_](https://desmoinesmetroopera.org/productions/bluebeard/) was a marriage of powerful music and stunning visuals, a combination that pushed this often overlooked operatic masterpiece to new heights. As with most fairy tales, the story of Bluebeard's ill-fated bride is full of compelling contradictions, and this production struck just the right balance of dark romance mixed with psychological horror.

The orchestra, under the baton of David Neely, brought Bartok's lush score to life. As Judith opens the doors of the castle, new horrors and wonders are revealed, and the orchestra plays a pivotal role in illustrating Bluebeard's hidden secrets. Ranging from murky darkness to epic glory, Neely and the orchestra navigated these dramatic fluctuations with finesse, supporting the singers in a true collaboration.

Viktoria Vizin introduced the tragic tale in the speaking role of the Prologue. Her clear diction and commanding presence set the tone for the story to come, drawing the audience in and hinting at the uncertainty of the unfolding drama.

This production made a clever choice to bring Bluebeard’s former wives to life through movement. Three dancers, Erin Arndorfer, Melissa Dahms, and Chiyo Nishida, portrayed the doomed brides with haunting grace. The choreography by Lisa Thurrell was fluid and entrancing, hinting at the love and sorrow each experienced at their captor's hands.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688483242/Sara_Gartland_as_Judith_and_Christian_Van_Horn_as_Duke_Bluebeard_photo_by_Duane_Tinkey.jpg){{% /md %}}

<figcaption>Sara Gartland as Judith and Christian Van Horn as Duke Bluebeard in Des Moines Metro Opera's production of Bluebeard's Castle, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

[Christian Van Horn](/scene/people/christian-van-horn/)'s dark baritone voice was perfectly suited for the titular role of Bluebeard. In an opera featuring only two characters, chemistry between Bluebeard and Judith is crucial, and Van Horn complimented his demanding bride's vacillating emotions with sinister stoicism and malevolent ambiguity. Bluebeard must be both seductive and frightening. Judith must desire him enough to disregard his many warnings, and Van Horn skillfully conveyed the sorrow and horror Bluebeard experiences as Judith exposes each of his secrets.

Much of the dramatic weight of this opera falls upon the shoulders of Bluebeard's inquisitive bride, Judith. [Sara Gartland](/scene/people/sara-gartland/) carried this burden with undeniable charisma, her lush voice and nuanced acting on display from start to finish. Judith begins the opera as a seemingly innocent girl, but Gartland managed to gradually reveal the true depth hidden beneath this facade. Her hopeful outlook on love is slowly transformed as her husband's dark secrets come to light, and the audience experiences curiosity and revulsion alongside the heroine. Judith is not just a helpless victim, however. She actively pursues her fate, seductive and demanding as she requests each key from Bluebeard. Gartland brought a staggering strength to the role in a performance that ensured the experimental production maintained its emotional core.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688483242/Sara_Gartland_as_Judith_and_Christian_Van_Horn_as_Duke_Bluebeard_photo_by_Duane_Tinkey_iii.jpg){{% /md %}}

<figcaption>Sara Gartland as Judith and Christian Van Horn as Duke Bluebeard in Des Moines Metro Opera's production of Bluebeard's Castle, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Perhaps the true breakout star of the evening was the state of the art digitally enhanced set. Des Moines Metro Opera collaborated with local artist Oyoram to incorporate hundreds of LED screens into the scenic design, creating an ever changing, interactive backdrop upon which the drama could enfold. Most productions of _Bluebeard's Castle_ are minimalist, using stark sets and lighting to hint at the marvels behind each door. Director Kristine McIntyre saw the potential to utilize technology to defy this expectation, bringing the heavy symbolism to life visually as well as musically. The vibrant, evolving backdrop allowed the audience to experience the grand vistas of Bluebeard's domain as well as the chilling blood soaked walls of his torture chamber. Hearing Judith describe these sights is moving, but seeing them with your own eyes is truly breathtaking.

The production design was deeply influenced by the art nouveau style prevalent when this opera originally premiered. References to Klimt and other artists were ingrained in every aspect of the opera's aesthetic, a feat that was achieved through the use of a controversial source–AI generated artwork. The effect of these artificially designed backgrounds was somewhat unnerving. If the audience looked too closely, the irregularities and imperfections became apparent, but that uncanny valley seemed fitting in this disturbing storyline.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688483243/Christian_Van_Horn_as_Duke_Bluebeard_and_Sara_Gartland_as_Judith_photo_by_Duane_Tinkey_vii.jpg){{% /md %}}

<figcaption>Christian Van Horn as Duke Bluebeard and Sara Gartland as Judith in Des Moines Metro Opera's production of Bluebeard's Castle, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Scenic designer Luke Cantarella complimented the digital displays by framing the technology with more traditional features. Piles of treasure lined the edges of the stage. Paintings and sculptures of naked women hinted at Bluebeard's former muses, emphasized when he begins to sketch his bride as she drapes jewels around her neck. There is a sordid opulence to Bluebeard's realm. A spiral staircase ascended from the depths, and Judith begins and ends the opera on this impressive structure, towering over the awaiting darkness. This gilded set piece was particularly striking, holding its own in a sea of LED screens.

The costume design by Kaye Voyce also drew inspiration from art nouveau, as did the hair and makeup by Brittany V.A. Rappise. Stark white garb allowed both Judith and Bluebeard to stand out against the colorful backdrops, alluding to the past yet somehow timeless. Judith in particular looked like a painting come to life, as if Klimt had made the finishing brush strokes just moments before she stepped onstage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688483243/Christian_Van_Horn_as_Duke_Bluebeard_and_Sara_Gartland_as_Judith_photo_by_Duane_Tinkey_viii.jpg){{% /md %}}

<figcaption>Christian Van Horn as Duke Bluebeard and Sara Gartland as Judith in Des Moines Metro Opera's production of Bluebeard's Castle, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Kristine McIntyre's staging was a refreshing twist on an usually tragic tale. When Bluebeard opens the final door, Judith discovers the fate of his three previous wives. The women are captives on display, muses frozen in time. Bluebeard reveals that his fourth bride, Judith herself, is to join their ranks, and at first she submits to her doom, allowing him to drape the midnight mantle over her shoulders. Then in a moment of defiance, Judith casts the garment aside, and the other brides follow suit. The four women flee the castle, ascending the spiral staircase and returning to the light once more. In the end, the women are triumphant, and Bluebeard is left in his crumbling mansion, alone in the dark. The final visual was a powerful one, the four brides and the Prologue joining hands in solidarity as their tormentor mourned below. The beauty of a fairy tale is its ability to evolve, resonating with the audience time and time again.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1688483243/Christian_Van_Horn_as_Duke_Bluebeard_and_Sara_Gartland_as_Judith_photo_by_Duane_Tinkey_v.jpg){{% /md %}}

<figcaption>Christian Van Horn as Duke Bluebeard and Sara Gartland as Judith in Des Moines Metro Opera's production of Bluebeard's Castle, 2023. Photo: Duane Tinkey.</figcaption>  
</figure>

Des Moines Metro Opera's cutting edge production of _Bluebeard's Castle_ breathed new life into an underrated opera, blending the digital and traditional in a seamless immersive display. The immortal power of this dark love story proved just as potent in this new format, and I can't wait to see how the opera company continues to push the boundaries of this technology in future productions.