+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-09-29T11:39:00-04:00"
lastmod = "2017-09-29T21:50:00-04:00"
preamble = "What would opera singers be without their stretchy, malleable tempos? More specifically, where would they be without the unwritten rules - \"performance practice\", they're often called - about when you simply **must** take some extra time? Opera is no place for heartless clockwork; but when it comes to mastering operatic skills, sometimes being a cold metronome is a clarifying experiment.\n\nWe've picked three examples of places where ignoring tradition (and many recordings) can help you see the forest for the trees:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506702339440/2017-09-29---Clock.jpg.jpg"
publishDate = "2017-09-29T21:33:00-04:00"
related_articles = ["articles/the-practice-tip-you-dont-want-to-hear.md","articles/surprising-practice-tips-4-arias-to-try-too-fast.md"]
short_description = "What would opera singers be without their stretchy, malleable tempos? More specifically, where would they be without the unwritten rules - &quot;performance practice&quot;, they&#039;re often called - about when you simply must take some extra time? Opera is no place for heartless clockwork; but when it comes to mastering operatic skills, sometimes being a cold metronome is a clarifying experiment."
slug = "ditch-rubato"
title = "Tick tock, singers! 3 spots to ditch the rubato (for now)"
+++

## The mini-cadenza in "Caro nome"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506702119015/2017-09-29---Caro-Nome.jpg.jpg)
</figure>

This aria from *Rigoletto* contains one of the most common unwritten rules in operatic repertoire: thou shalt make a gloriously stretchy moment out of the trip from the A-sharp up to that sexy C-natural, and then slide back into tempo. Some sopranos even grab an extra bit of time in the last note of the bar, hanging on to the first syllable of "sarà!"

It's definitely a great moment, and though Verdi didn't explicity ask the soprano to pull back the tempo for this moment, the musical gesture really does beg for it. 

The thing about stretching the tempo, though, is that there has to be a tempo in place to stretch. In other words, if you've never sung this *a tempo*, in equal sixteenth notes with zero rubato, you don't really know what you're jazzing up. If you jump to the "performance practice" too soon, you'll only be offering imitation. Yes, it's no fun to sing this bar without some ebb and flow to it, but starting literally is the only way to end up with something that's organic and your own. 

## Those high notes in "O mio babbino caro"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506702126833/2017-09-29---Babbino.jpg.jpg)
</figure>

It's almost a crime to sing this aria from *Gianni Schicchi* without some extra hang time on the high A-flat at the end of this first line. It's the beginning of a trend of milking high A-flats throughout this aria, all of which add up to Lauretta's beautiful - if a bit whiny - pleading with her father to let her marry the guy she loves. 

Puccini didn't write anything resembling a *fermata* at this moment; that doesn't mean it's not a great idea to stretch the high note, but a smart singer will start with the cold, hard facts. Similarly to the "Caro nome" example, this is a spot that surely begs extra time on the A-flat; but in Puccini (and Verdi, for that matter), it's always about how you snap back into tempo after you're done showing off.

While this aria is still fresh, resist the urge to habitually add extra time on that high note, and sing the line in the simple 6/8 rhythm Puccini wrote. If you've never felt the tempo contrinue through "mi piace, è bello, bello", it'll be hard for you manipulate it later.

## *That moment* in "Vainement, ma bien aimée"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506702132491/2017-09-29---Vainement.jpg.jpg)
</figure>

There's a glaring difference in this example from Lalo's *Le roi d'Ys*: here, there's actually a *rallentando* marked in the score. So, if you have permission from the composer to slow down and enjoy yourself, why be a masochist who makes an exercise out of speeding through the bar as though there's no change in tempo?

Fair question, and I've got two answers for you. Firstly, a *rallentando* is a gradual, progressive gesture, not necessarily a major change that comes on quickly; at the moment where a *rallentando* is marked in the score, you're arguably still in the original tempo, just starting to slow down. Trying this bar with no tempo change gives you a starting point, and from there you can add the gradual slowing down; it's a lot easier to pace after you've internalized the basic rhythm without any funny business.

Secondly, there's a syncopated rhythm in this bar. *Who cares?* you may ask, at this point exasperated with my stealing all your fun. Syncopations are about tension, and in this case the tension peaks at the end of that high A, where the note stretches into beat 2 of the bar. The figure loses a bit of power if the singer doesn't feel that moment where the harmony changes underneath him. Again, it's easier to find the shape of this bar in a strict tempo, before complicating it with the *rallentado*.


