+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-06-01T22:13:00-04:00"
lastmod = "2018-07-02T18:48:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546219956/media/2018/12/sqSS053018NYCO0347.jpg"
primary_image_credit = "Brokeback Mountain, New York City Opera, 2018. Photo: Sarah Schatz."
publishDate = "2018-06-01T22:13:00-04:00"
related_companies = ["scene/companies/nyc-opera-renaissance.md"]
related_people = ["scene/people/daniel-okulitch.md"]
short_description = "I would say that Wuorinen has done Proulx&#039;s story justice, and breathed new, interesting life into what is already considered an important narrative in LGBTQ storytelling."
slug = "distant-emotional-brokeback-mountain-a-paradoxical-success"
title = "Distant, Emotional Brokeback Mountain A Paradoxical Success"

+++
Ever since Ang Lee's seminal film version of Annie Proulx's short story *Brokeback Mountain*, many have called the tale of two gay cowboys an important story in the world of LGBTQ representation. With this thought in mind, the production notes of [New York City Opera's production of Charles Wuorinen's opera](https://nycopera.com/shows/brokeback-mountain/) based on the same source seem to indicate misplaced priorities on the part of the creative staff: much is made of how the music emulates the landscapes the story takes place in, to the point that one might be forgiven if they felt the emotional core of this tale is lost. And yet, those who are familiar with the original short story know that this is exactly the same impressionistic effect Proulx employed: her prose contains many descriptions of the Wyoming countryside, and gives merely impressions of moments. This oddly gives the short story much of its emotional weight; the effect the concentration on the landscape has is that it prevents the story from indulging in the kind of schmaltz that might otherwise tarnish a story such as this, which thus amplifies the palpable sense of regret that Ennis Del Mar feels by the story's conclusion.

This paradox thrives in the center of Wuorinen's score, which is Boulezian in a way that might initially seem out of place to depict a romance. At first, the strident, incessant dissonance featured throughout seems cold and distant; the opera also moves at a breakneck pace, to the point that some of the first act's dramatic beats barely had enough time to land. However, as the opera treads on to its tragic finale, the score's outright denial of maudlin sentiment becomes its greatest strength: this became apparent in the handling of the dramatic beats in the second act, and even despite the dissonance in the rest of the score Ennis' discovery of Jack's death felt like a punch to the gut in just the right way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527905321878/SS053018NYCO_0186.jpg.jpg)
<figcaption>Daniel Okulitch and Glenn Seven Allen in *Brokeback Mountain*, New York City Opera, 2018. Photo: Sarah Schatz.</figcaption>
</figure>

The score also does not lack any kind of personality, as the musical locations all had their own distinct flavor of music that was easily identifiable — a rarity for an extremely modernist score such as this. The deep, cavernous notes that signify the titular mountain keep returning, and they are instantly recognizable in contrast to the fast, repetitious use of consonant intervals that defines the domestic world that Alma inhabits. They are also not static, as their coloring changes with the score's needs: the repetitious, fast rhythms that define Alma's world seem bright and sparkly when Alma buys her wedding dress, but they turn into a sinister refrain that almost mocks the characters when Alma and Ennis have their climactic argument over the dishes when Alma finally has enough of Ennis' lies and calls him to task for his trysts with Jack. So, too, does the mountain morph with the story, and it inhabits many spaces from the grand, fear-inspiring place that the characters sing about to the fond, tender memory of romance that Ennis and Jack allude to the mountain having for them later in the opera.

In other words, Wuorinen's score achieves the same effect that Proulx's prose does, such that it becomes difficult to imagine the score beign done in any other way by the time the final black-out occurs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527905329694/SS053018NYCO_0060.jpg.jpg)
<figcaption>Daniel Okulitch, Melissa Parks, and Glenn Seven Allen in *Brokeback Mountain*, New York City Opera, 2018. Photo: Sarah Schatz.</figcaption>
</figure>

Of course, to perform such a score as this, one needs to find truly brave performers that are up to the challenge of realizing such difficult music. Clearly, some of the singers seemed more comfortable inhabiting Wuorinen's sound world than others: Christopher Job, for instance, seemed to take a little bit of time to warm up to Aguirre. However, a majority of the singers were on the ball from the get-go, and those that were exhibited excellent acting, which was no doubt helped by the fact Wuorinen's score gives them plenty to work with. Much of the minor cast managed to work quite a lot of character into their short scenes: here, Kevin Courtemanche added an authoritative edge to Jack's father that perfectly conveyed the resentment he felt at his son's last wishes for his ashes, and Melissa Parks made the most of her brief scene as a bartender that suggests that Jack and Ennis bring whiskey to the peak of the mountain. There was no lack of commitment from the central characters, either: it would be fairly easy to make Alma Beers a one-note spurned wife given the way she is written, but Heather Buck grounds the character with a sense of held-back resentment, and while Hilary Ginther's Lureen did not get a whole lot to do she still made quite the unforgettable impression as Jack Twist's equally put-upon wife.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527905338215/SS053018NYCO_0573.jpg.jpg)
<figcaption>Heather Buck, Glenn Seven Allen, and Daniel Okulitch in *Brokeback Mountain*, New York City Opera, 2018. Photo: Sarah Schatz.</figcaption>
</figure>

The highlight of the evening, however, was Daniel Okulitch and Glenn Seven Allen as the two lovers in the center of the story. Allen easily stole the show as Jack Twist, and his strident tenor voice was a perfect match for Jack's cocky and impulsive personality. He also brought a sense of lyricism to his ideas of the life he wanted to live with Ennis, and his strident tenor voice grew punchier as he eventually began to grow more exasperated with Ennis' inability to get over the sentiment of his time. Okulitch, however, grounded the entire evening with his voice: he held back on his tone color in the beginning when his vocal lines were more clipped, which played perfectly with the way Wuorinen's score gradually allows Ennis to express his non-stop doubts about what was between him and Jack. He only let the full richness of his voice out in his final aria that ends the work, and this amplified the sense of regret that the rest of the opera did so much to set up. They also were both excellent actors, both of them bodily conveying their characters, whether it be with Jack's confident swagger or the way Ennis always seemed to hunch into himself when he was not around Jack.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527905353425/SS053018NYCO_0834.jpg.jpg)
<figcaption>Heaher Buck and Daniel Okulitch in *Brokeback Mountain*, New York City Opera, 2018. Photo: Sarah Schatz.</figcaption>
</figure>

All of the cast were also amply supported by outstanding playing from the chamber orchestra that inhabited the pit. I cannot imagine that the orchestra had an easy time of it considering that Wuorinen's vivid orchestration is almost a character in and of itself, but their confident, top-notch playing supported the action excellently. I imagine much of the orchestration's subtleties would have been lost, however, if not for conductor Kazem Abdullah: he directed the score with such precision and command of the score’s subtleties that it almost felt like the composer was controlling the pit.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527905380622/SS053018NYCO_1181.jpg.jpg)
<figcaption>Daniel Okulitch in *Brokeback Mountain*, New York City Opera, 2018. Photo: Sarah Schatz.</figcaption>
</figure>

I cannot imagine that such a briskly paced score would make any production designer's life terribly easy: however, Jacopo Spirei brought life to the production by centering on the performances of the characters and their plight. On this, he brought out the best in his cast of singers. His design team also created a sparse production which implied a lot with very little. Eva Musil's scenic designs in particular were inspired: they implied setting with very few materials, and I felt it was a particularly inspired touch that she used a corner of the set piece that created the titular mountain as the floor of what eventually becomes Jack's room at his family house: such a subtle use of scenery amplified the opera's theme of regret in an interesting way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527905391589/SS053018NYCO_1117.jpg.jpg)
<figcaption>Daniel Okulitch in *Brokeback Mountain*, New York City Opera, 2018. Photo: Sarah Schatz.</figcaption>
</figure>

Of course, there were questionable moments that occurred throughout the evening, and unfortunately they are flaws in Wuorinen's score. For me, I felt that Act 1's ending was a little awkwardly placed: it perhaps would have been wiser to place the end of Act 1 after Jack and Ennis have reunited after the first four-year time skip. I also have to wonder why Proulx and Wuorinen included the Act 2 scene in which Lureen has a conversation with the ghost of her dead father: the scene seemed to intrude from a completely different opera, given that it injected an odd supernatural element that was never alluded to anywhere else in the evening. Some aspects of the production also did not aid the score: Musil's scenery design did eventually involve some scenic transitions in Act 2 that were perhaps a little slower than was really advisable, and the fact that the slowest scene changes dragged out some of the silent breaks in Wuorinen's score had the effect of sucking out some of the tension that the music had cultivated.

Oddly, though, I feel that the silences that stretched out too long thanks to the scenic transitions also highlighted one of the opera's strengths. It is a strange, almost anti-operatic contradiction that one would approach the work by denying the music any kind of sentimentality, but it's difficult to imagine the opera inhabiting any other kind of space by the time it concludes. I would say that Wuorinen has done Proulx's story justice, and breathed new, interesting life into what is already considered an important narrative in LGBTQ storytelling.