+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-04-27T14:44:00-04:00"
lastmod = "2017-04-28T11:40:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493319059317/2017-04-27---Square---LouisRiel-SI-1272.jpg.jpg"
primary_image_credit = "Russell Braun as Louis Riel in the Canadian Opera Company's new production of Louis Riel, 2017, photo: Sophie I'anson."
publishDate = "2017-04-28T11:20:00-04:00"
related_articles = ["articles/in-review-written-on-skin-at-roh.md","articles/tarrare-the-freak-i-just-want-to-be-full.md","articles/in-review-the-exterminating-angel-at-roh.md","articles/dont-miss-luminatos-bearing.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/russell-braun.md","scene/people/allyson-mchardy.md","scene/people/simone-osborne.md","scene/people/michael-colvin.md","scene/people/charles-sy.md","scene/people/clarence-frazer.md","scene/people/aaron-sheppard.md","scene/people/jeanphilippe-fortierlazure.md","scene/people/johannes-debus.md","scene/people/james-westman.md","scene/people/keith-klassen.md","scene/people/andrew-haji.md","scene/people/peter-barrett.md","scene/people/alain-coulombe.md"]
short_description = "Perhaps without Hinton&#039;s supernumeraries, Louis Riel might have been more &quot;comfortable&quot; for Toronto audiences. With the faces of the affected placed right amid a piece of theatre that comes out of a Western European tradition, the production seems to mirror the slow, significant steps being taken by Canada as a whole, beginning with the acknowledgement of injustice within our country&#039;s short history."
slug = "discomfort-louis-riel-at-the-coc"
title = "Discomfort: Louis Riel at the COC"
+++

"*Louder, please*," barked the inconsiderate, entitled man sitting in an upper ring of the Four Seasons Centre, as Cole Alvis (The Activist) welcomed the audience to the [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s new production of Harry Somers' [*Louis Riel*](http://www.coc.ca/PerformancesAndTickets/1617Season/LouisRiel.aspx).

The interruption seemed to set the tone for the opera, written in 1967 for Canada's centennial, which tells the story of the Métis leader who founded the province of Manitoba, and led two resistance movements against prime minister Sir John A. Macdonald. The story is one of racism and xenophobia, cloaked transparently in the guise of establishing - or preserving, as the case may be - a "great" country.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493319355109/2017-04-27---LouisRiel-MC-0015.jpg.jpg)
<figcaption>Cole Alvis as The Activist in the Canadian Opera Company’s new production of *Louis Riel*, 2017, photo: Michael Cooper.</figcaption>
</figure>

*Louis Riel* is an uncomfortable opera. The score assaults the ear with dissonance and cacophonous noise, and Somers seems to press the singers right up against the boundary between vocal expression and vocal abuse. The hate from both sides of Canada is founded in ignorance and fear, and the real-life-inspired characters seem to embolden their own national pride with their loathing for the "other". Even in 2017, Canada's neighbour is a country with a government which preys on the same kind of stupid, ignorance-fueled racism that existed in the 19th century; for white, anglophone Canadians, *Louis Riel* should be a reminder that our own country's history comes with similar shame.

Even seasoned operagoers will find themselves heavily laden with the story of Louis Riel, the music of Harry Somers, and the opera's new production by Peter Hinton. Where does one begin to talk about it? To say you "liked" it is sort of like saying you "liked" *An Inconvenient Truth* or you "liked" the Memorial to the Murdered Jews of Europe in Berlin. *Louis Riel* offers no toe-tapping tunes, and few characters who are entirely unpacked; it's an honest approach by Somers and librettists Mavor Moore and Jacques Languirand, to tell this story through a series of keyholes which allow us to see what a character does or says, but perhaps not entirely why.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493319390990/2017-04-27---LouisRiel-MC-0624.jpg.jpg)
<figcaption>(l-r) Peter Barrett as Col. Garnet Wolseley, James Westman as Sir John A. Macdonald, Jean-Philippe Fortier-Lazure as Sir George-Étienne Cartier and Alain Coulombe as Bishop Taché in the Canadian Opera Company's new production of *Louis Riel*, 2017, photo: Michael Cooper.</figcaption>
</figure>

With an enormous cast and a complicated score, it's an impressive feat to present *Louis Riel* at all. Hinton's production introduces the conveyor belt of new characters with great specificity; Dr. Schultz the opportunist, Donald Smith the businessman, and Bishop Taché the manipulated were made crystal clear with precious little stage time. Gillian Gallow's ingenious costumes and Michael Gianfrancesco's looming sets seemed to keep the story and its characters in every time period, reminding us of what was, and what still is.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493319373754/2017-04-27---LouisRiel-MC-0556.jpg.jpg)
<figcaption>(centre) Andrew Love as Dr. Schultz in the Canadian Opera Company’s new production of *Louis Riel*, 2017, photo: Michael Cooper.</figcaption>
</figure>

Louis Riel - sung desperately by [Russell Braun](/scene/people/russell-braun/) - is a large figure who seemed to take up too much space. [James Westman](/scene/people/james-westman/) is a beautifully exaggerated figure in Riel's adversary, Sir John A. Macdonald; almost laughably so, the Prime Minister shows himself a man whose world is surprisingly small, considering the vast country he runs. Though there is more justice in Riel's cause, both leaders come with flaws, and they both make decisions that are impossible, despite a "right" answer's being clear to the outsider.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493319364797/2017-04-27---LouisRiel-MC-0334.jpg.jpg)
<figcaption>(l-r) Russell Braun as Louis Riel, Alain Coulombe as Bishop Taché and Allyson McHardy as Julie Riel in the Canadian Opera Company's new production of *Louis Riel*, 2017, photo: Michael Cooper.</figcaption>
</figure>

The cast of Canadians is strong, and each artist seems to approach their role with a certain deference, acutely aware of the public eye that is focused on this new production in Canada's 150th year. To the large cast and chorus, Peter Hinton adds a "silent chorus" of sorts, a group of non-speaking, non-singing Métis and indigenous performers, contemporarily dressed in red, and later in black. "They are in all of the action, they frame the action, they resist the action, and they are affected by everything that happens, but they are silent," Hinton told [Michael Cooper of *The New York Times*](https://www.nytimes.com/2017/04/19/arts/music/canada-turns-150-but-a-silent-chorus-isnt-celebrating.html)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493319424519/2017-04-27---LouisRiel-MC-0796.jpg.jpg)
<figcaption>Simone Osborne as Marguerite Riel in the Canadian Opera Company's new production of *Louis Riel*, 2017, photo: Michael Cooper.</figcaption>
</figure>

It's perhaps a retroactive bandaid-like response to the fact that, among the many people onstage, shockingly few of the vocal performers are of First Nations descent. A late fix though it may be, Hinton's silent chorus is a thoughtful addition to *Louis Riel*, one that marks the societal changes between 1967 and today. These silent performers are a strong visual presence throughout the production, and so it draws the eye when their movements and choreography are less than uniform. There was a disappointing moment, during Marguerite Riel's moving lullaby (sung powerfully by [Simone Osborne](/scene/people/simone-osborne/)), when two members of the silent chorus stuck out like sore thumbs, their movements full of bored insolence while having a visible conversation amongs themselves.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493319406279/2017-04-27---LouisRiel-MC-0679.jpg.jpg)
<figcaption>(centre) Justin Many Fingers (Mii-Sum-Ma-Nis-Kim) as The Buffalo Dancer in a scene from the Canadian Opera Company's new production of *Louis Riel*, 2017, photo: Michael Cooper.</figcaption>
</figure>

Perhaps without Hinton's supernumeraries, *Louis Riel* might have been more "comfortable" for Toronto audiences. With the faces of the affected placed right amid a piece of theatre that comes out of a Western European tradition, the production seems to mirror the slow, significant steps being taken by Canada as a whole, beginning with the acknowledgement of injustice within our country's short history.

Maybe it's a function of Somers' opera that the story and its affect still seem muddled in my head. Is *Louis Riel* more "objective" than our history books? Is discomfort a good first step towards honesty and reparations? Am I, a white anglophone Canadian, like those Ontarians of the 19th century?

>Louis Riel runs at the Four Seasons Centre until May 13. For details, and to purchase tickets, [click here.](http://www.coc.ca/PerformancesAndTickets/1617Season/LouisRiel.aspx) For more production images, click on our gallery below.
