+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2022-02-03T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Boston Lyric Opera's digital production of _Svadba_ is [available to stream on operabox.tv](https://blo.org/svadba/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1643903737/media/2022/02/sqBLO-2022-Svadba_zh6mhl.jpg"
primary_image_credit = "Victoria L. Awkward (Milica) in Svadba, Boston Lyric Opera, 2022. Photo courtesy of BLO."
related_articles = ["articles/enigma-opera-s-curlew-river-a-transcendent-experience.md", "articles/installation-la-traviata-intimate-and-effective-production.md", "articles/canadian-pride-boston-s-svadba-looks-like-a-must-watch.md"]
related_companies = ["scene/companies/boston-lyric-opera-1.md"]
related_people = []
short_description = "I have to admit, after a while, the music did draw me in. This is an opera I suspect some people will have to sit with, but it will pull you into its language. And when it does, it does feel remarkably transformative afterwards."
slug = "digital-svadba-a-ritualistic-enigma-with-some-confusion"
title = "Digital Svabda a ritualistic enigma, with some confusion"
youtube_url = ""

+++
When one thinks about opera, the traditional ideas of opera are often that, even accounting for how opera plays with emotional time, the plot of any given opera should be presented in a relatively objective manner. The opera house rarely leaves room for more abstract pieces, and whenever the more abstract piece does come along presenting it can be a challenge that not everyone can realize effectively. How, then, do you present something like this in video format?

We thus turn to [Boston Lyric Opera](/scene/companies/boston-lyric-opera/)'s next digital offering, this time on Ana Sokolovic's [_Svabda_](https://blo.org/svadba/), which spins a tale about a bride-to-be and the rituals she goes through preparing for the wedding the day before. I say it spins a tale, but perhaps it's not quite a tale that it spins as much as an experience: there is a heavily ritualistic quality both in Sokolovic's musical language and especially in the words she chooses to set that tends towards non-literal storytelling. It is an uncanny blend of the setting of _Les Noces_, the frequent use of more abstract text of a Philip Glass opera, and the minimalist musical language of _The Little Matchgirl Passion_.

> This is an opera I suspect some people will have to sit with, but it will pull you into its language.

What is more, the opera is sung almost entirely _a capella_: the only thing resembling an orchestra are various pieces of handheld percussion the singers handle as well as an ocarina that makes an appearance about forty minutes in, but the rest is sung entirely by _a capella_, and with only women singers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1643903799/media/2022/02/BLO-2022-Svadba-4_jveoe0.jpg){{% /md %}}

<figcaption>Victoria L. Awkward (Milica, centre) in Svadba, Boston Lyric Opera, 2022. Photo courtesy of BLO.</figcaption>  
</figure>

Some purists will question whether or not the work's more abstract nature will lend itself to being called opera. Indeed, all the touches are quite abstract: one section of the text is essentially Serbian nursery rhymes and recitations of the Serbian alphabet used to create the effect of a conflict, and there is an entire section that describes the bride essentially washing her hair in starlight. Even when the text is direct (and admittedly, it is more often direct than not), it is often repeated for stretches of several minutes, which strips it of a certain dramatic urgency. However, in my estimation, the longer you sit with the musical language the more it makes sense to use this kind of music to describe what is, essentially, a ritualistic process: the music is aiming to give an impression, not a literal representation, and when you take that into account I feel it certainly does count as opera.

As for whether it put me under its spell? I have to admit, after a while, the music did draw me in. This is an opera I suspect some people will have to sit with, but it will pull you into its language. And when it does, it does feel remarkably transformative afterwards.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1643903831/media/2022/02/BLO-2022-Svadba-1_vz4ocz.jpg){{% /md %}}

<figcaption>Jay Breen (Danica, left) and Victoria L. Awkward (Milica, in white) in Svadba, Boston Lyric Opera, 2022. Photo courtesy of BLO.</figcaption>  
</figure>

If only the video supported that! Staging _Svabda_ comes with its own set of pitfalls afterwards, and unfortunately I do not know if Boston Lyric Opera’s filmed production quite lived up to the ritualism of the music. They opted to film this work as if it were _Les Noces_, where the bride, her mother, and the bridesmaids are portrayed by a small group of dancers that do various things that constitute wedding rituals, some of which involve dance but most of which do not.

I get the sense that a successful staging of _Svabda_ requires that, whether you treat the visual element super literally or match the text in its abstractions, you find some way to match the text with what is happening on-screen; with the filmed production here only occasionally does it feel like it struck gold, and I feel that the parts that are not successful are unsuccessful because of a concerted disconnect between what the music and text are actually saying and what we are seeing on-screen.

For instance, in the aforementioned bit where the bride "washes her hair in starlight", the video interprets that as the bride essentially sleeping on the beach. This is intercut with several flashbacks to earlier things in the filmed production, including a segment where she has a brief flurry of imagination wishing she had chosen somebody else to marry. It lends itself to the kind of nocturnal contemplation that the "washing hair in starlight" implies, and it synced up really well there.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1643903861/media/2022/02/BLO-2022-Svadba-2_tpnnqu.jpg){{% /md %}}

<figcaption>Victoria L. Awkward (Milica, centre) in Svadba, Boston Lyric Opera, 2022. Photo courtesy of BLO.</figcaption>  
</figure>

Where it syncs up less well, the effect can be jarring, and in some cases it was enough to take me out of the experience. In particular is a segment in which the Serbian alphabet and a few Serbian nursery rhymes are recited, set in a way where the vocal ensemble is almost clashing with each other – a note to this effect is even made in the film's closed captioning. This part goes on for a long while, and I would have expected there to be more of an argument scene out of it visually. But for some reason, something is only made of this about halfway into the section when the bride and maid of honor get into some kind of dance where they are mock opposing each other: the first half is the bridesmaids tasting a jam the mother has made for the morning feast, and then the bride and her bridesmaids going down to the beach to enact that dance. The apparent disconnect in this and other similar sections kind of took me out of the experience a little bit, and prevented me from being fully lost in the ritualism of the music.

> I found Sokolovic's work to be quite fascinating.

What further does not help is the fact that BLO opted to cut between the dancers enacting the sung scenario and the vocal ensemble in the recording studio recording the work. These cuts tend to be very abrupt and very sudden, and I personally found these cuts more distracting to look at than supplementary to the material in any way. Even when the ocarina comes in and we see the singer actually play the ocarina, I felt like it pulled the attention more towards "ah, the singer can sing and play" than what was actually in the opera.

I know that BLO called attention to the novelty of an _a capella_ opera, and I get the sense that these cuts are entirely about showcasing this aspect of the opera, but I feel like that novelty loses at least a little bit of its alluring magic when the videography calls attention to it. The production would have done better without these cuts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1643903885/media/2022/02/BLO-2022-Svadba-3_gsfmsr.jpg){{% /md %}}

<figcaption>Victoria L. Awkward (Milica) and Jackie Davis (Lena) in Svadba, Boston Lyric Opera, 2022. Photo courtesy of BLO.</figcaption>  
</figure>

At the very least, it looks pretty: with the exception of one very distracting and very obvious use of night filter, the shots with the dancers are well-framed and convey a certain stylistic use of color that is enriching to the eye. It also has a certain professional sheen to it that I noticed off the bat: with streamed productions becoming more frequent throughout the COVID-19 pandemic, I wondered what one such production would look like with a bit more money behind it, and I do find myself liking the results.

Alas, the production as a whole feels more middling than anything. The video part of the production only occasionally allows _Svabda_ to be as enchanting as it could be, and this production showed that in the few flashes of brilliance it displayed. For my part, I found Sokolovic's work to be quite fascinating: I just wish it had been supported by a film that paid more attention to the work than it presently does.