+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2017-02-22T13:53:00+00:00"
lastmod = "2017-02-25T11:00:00+00:00"
preamble = "If you don't recognize the term, you definitely recognize the device. [Diegetic music](https://en.wikipedia.org/wiki/Diegesis#Film_sound_and_music) in a show - be it television, film, or even opera - is essentially music that the characters hear as well as the audience. In film and TV, often we realize that music is diegetic because it stops when a character switches off a radio, or pulls headphones out of their ears.\n\nBy design, most of the music in opera is non-diegetic, meaning the characters in opera do not hear it. But often composers will get creative with the medium of opera, using the music itself to bring the audience closer to the character's experience.\n\nWe've come up with a few great examples of diegetic music in opera, and how the device can offer comic relief, dramatic irony, and even shows within the show."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487780297878/2017-02-22---Radio.jpg.jpg"
publishDate = "2017-02-25T10:50:00+00:00"
related_articles = ["articles/5-people-who-would-make-great-opera-roles.md","articles/4-opera-scenes-that-should-have-happened.md","articles/opera-spin-off.md","articles/schoenbergbach-other-unlikely-pairs-atg-theatre-heads-to-tiff.md","articles/bel-canto-creating-a-diva.md"]
short_description = "One of the most moving examples of this diegetic music technique is in that shattering finale of Poulenc&#039;s Dialogues des Carmélites. The nuns sing the &quot;Salve regina&quot; as they are led hopelessly to the guillotine; one by one, the voices peter out, and Poulenc even adds the horrific sound of a guillotine, as though he wants to make you wince and weep."
slug = "diegetic-music-in-opera-3-ways-to-use-it"
title = "Diegetic music in opera: 3 ways to use it"
+++

## Plot-device performances

The most obvious use of diegetic music in opera comes in the "show-within-a-show" device, where a character is giving a performance as part of the plot. It happens in *Don Giovanni*, when Giovanni, armed with a guitar and a sultry baritone, serenades a woman from outside her window. It happens in *Le nozze di Figaro*, when Cherubino sings his little ditty, "Voi che sapete" for a meager audience of Susanna and the Countess. In *Manon Lescaut*, diegetic music comes with the musicians hired to entertain the leading lady; in *Tannhäuser* it's found in the the whole Minnesinger scene. 

Or if you prefer, Strauss' *Der Rosenkavalier* has a moment of diegetic opera music within an opera, as the Italian Singer shows up to serenade the Marschallin.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/omFIvIqDhWo?start=2345" frameborder="0" allowfullscreen></iframe>
</figure>

## Comic relief

Using diegetic music can also be a great opportunity for some comic relief. There's the [adorable scene in Britten's *A Midsummer Night's Dream*](https://youtu.be/ysEuB-eAXp0?t=4364) where the fairies make a little band of themselves, providing some dance music for Bottom. There's also the [cute moment in *Les contes d'Hoffmann*](https://youtu.be/Usbhh-O7w3I?t=551) with Fritz, the well-meaning-but-deaf-as-a-doorknob servant, who tries out his singing talents to disappointing results.

One of our favourites, though, is the much-needed moment of lightness in Wagner's *Siegfried*, when Siegfried tries to imitate a bird song with a reed pipe (we always think of the English horn player that gets to show off their best "bad" sound). In the midst of a story full of magic and beauty, Siegfried's awkward honking is a great reminder that the hero is very much a bored, curious teenager making unnecessary noise. Wagner wavers between diegetic and non-diegetic music throughout this scene, creating a stark difference between what Siegfried experiences, and the reality of the world around him.

Siegfried switches to playing his horn, and fares much better. Perhaps the coolest part of this moment is how Wagner brings us out of the diegetic music, and into some of the most awesome non-diegetic music of the opera (ie. Dragon music at 1:58:48!).

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/7Y2-aiKrvAw?start=6824" frameborder="0" allowfullscreen></iframe>
</figure>

## Dramatic gut-punchers

In true operatic fashion, diegetic music can amplify the intensity of a scene that's already tugging at your heartstrings. In Act III of *La traviata*, we hear the [happy strains of a Carnavale parade](https://youtu.be/1-jHIfm3_oI?t=6940), outside Violetta's room where she's dying of tuberculosis. In case we needed more reasons to cry, Verdi is maximizing the contrast between the lonely life of a dying young woman, and the life-goes-on sounds of bustling Paris. In Act I of *Tosca*, Scarpia conceals his lust and vengeance within the sounds of the [Te Deum](https://youtu.be/FHOJCdfBFQg), hiding in plain sight as a heathen among the pious, and singing his own version of worship (Tosca, really) to the same tune as the truly god-fearing.

One of the most moving examples of this diegetic music technique is in that shattering finale of Poulenc's *Dialogues des Carmélites*. The nuns sing the "Salve Regina" as they are led hopelessly to the guillotine; one by one, the voices peter out, and Poulenc even adds the horrific sound of a guillotine, as though he wants to make you wince and weep.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/eFL2iu4faEU" frameborder="0" allowfullscreen></iframe>
</figure>
