+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-09-13T09:41:00-04:00"
lastmod = "2017-09-13T10:36:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505310182345/2017-09-12---square---Die-Zauberflote-09-09-17-ROH-3585-SIOBHAN-STAGG-AS-PAMINA%2C-MAURO-PETER-AS-TAMINO%2C-MIKA-KARES-AS-SARASTRO-(C)-ROH.-PHOTO-TRISTRAM-KENTON.jpg.jpg"
primary_image_credit = "Siobhan Stagg (Pamina), Mauro Peter (Tamino) and Mika Kares (Sarastro) in Die Zauberflöte, ROH, 2017. Photo: Tristam Kenton. "
publishDate = "2017-09-13T10:33:00-04:00"
related_articles = ["articles/in-review-peter-deutsch-at-wigmore-hall.md","articles/in-review-cocflute-sparkles.md","articles/a-refreshing-gateway-drug-the-magic-flute-at-o17.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/siobhan-stagg.md","scene/people/mauro-peter.md","scene/people/mika-kares.md","scene/people/julia-jones.md","scene/people/sabine-devieilhe.md","scene/people/peter-bronder.md"]
short_description = "Speaking of maniacal, the Monostatos of Peter Bronder brought the house down. This creepy and twisted creature slithered about the stage, more screaming his lines than singing, which made the actions of him and his evil band of goons thrilling to watch. Bronder is the kind of performer who we could glean meaning from only seeing his eyes peering through a black curtain - every movement is filled with intention."
slug = "die-zauberflote-at-roh"
title = "Brisk &amp; wicked: Die Zauberflöte at ROH"
+++

Fifteen years after its first performance, the David McVicar production of [*Die Zauberflöte*](http://www.roh.org.uk/productions/die-zauberflote-by-david-mcvicar) opened last night at the [Royal Opera House](/scene/companies/royal-opera-house/) in Covent Garden. Being one of the quickest *Flutes* that I've ever seen, conductor [Julia Jones](/scene/people/julia-jones/) did seem in a hurry to get through the evening. In some cases, I was grateful for these speedy tempi - it's easy to remember waiting for the second act to get to the final chorus as the music of Sarastro's men drags through mud. There was no mud in Jones' *Flute*, although at times the high-speed sacrificed the text of the singers.

A consequence of Jones' fast tempi came almost immediately with the entrance of the three ladies. As the music whizzed by, the trio struggled to keep up, often not having enough time to sound pitches and actually sing. Their delivery seemed to be heavy with "sprech" but not enough "sing," which is a shame, as the three ladies have some beautiful musical moments that went unrealized.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505312899327/2017-09-12---Die-Zauberflote-09-09-17-ROH-1326-MAURO-PETER-AS-TAMINO-ROH.-PHOTO-TRISTRAM-KENTON.jpg.jpg)
<figcation>Mauro Peter as Tamino in *Die Zauberflöte*, ROH, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

Bass [Mika Kares](/scene/people/mika-kares/) was clearly at odds with the tempi of his numbers - after Jones started "In diesen heil'gen Hallen," Kares used his phrasing to slow the tempo down by what must have been ten notches on the metronome. Kares tried this trick again in his trio with Pamina and Tamino, "Soll ich dich teurer nicht mehr sehen," but his efforts were futile as [Siobhan Stagg](/scene/people/siobhan-stagg/) and [Mauro Peter](/scene/people/mauro-peter/) were game to move with Jones instead of work against her.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505312913940/2017-09-12---Die-Zauberflote-09-09-17-ROH-968-RODERICK-WILLIAMS-AS-PAPAGENO%2C-SIOBHAN-STAGG-AS-PAMINA-ROH.-PHOTO-TRISTRAM-KENTON.jpg.jpg)
<figcation>Roderick Williams as Papageno and Siobhan Stagg as Pamina in *Die Zauberflöte*, ROH, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

There is certainly no "right" tempo for the numbers in this opera, to assign a definite number of beats per minute to any piece of music is banal, and I do not think that just because every conductor takes a particular tempo for a certain aria it should always be performed that way. Because of this, it was refreshing to hear Julia Jones' take on this frequently staged opera. I do, however, have an issue with the text being incomprehensible, as was the case in the music of the three ladies.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505312935103/2017-09-12---Die-Zauberflote-09-09-17-ROH-137-MAURO-PETER-AS-TAMINO-ROH.-PHOTO-TRISTRAM-KENTON.jpg.jpg)
<figcation>Mauro Peter as Tamino in *Die Zauberflöte*, ROH, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

[Roderick Williams](/scene/people/roderick-williams/) had absolutely no trouble in delivering any of his text. Every word was filled with charisma and the energy of his carefree and genuine Papageno, and the audience became massively involved during his suicide aria - I heard someone from the balcony shout "Don't do it!" Swiss tenor [Mauro Peter](/scene/people/mauro-peter/)'s impressive voice suited the role of Tamino extremely well, while giving one of the campier Tamino's I have seen performed. Camping it up a little seemed to be a good choice for Peter, and he came off as a fairy-tale tenor playing the part of the hero. [Sabine Devieilhe](/scene/people/sabine-devieilhe/) made quite an elegant Covent Garden debut as the Queen of the Night. Her voice was beautiful yet wicked, and her glorious coloratura passages were done as an aside from the rest of the characters, as a maniacal laughter to herself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505312945400/2017-09-12---Die-Zauberflote-09-09-17-ROH-519-SABINE-DEVIEILHE-AS-QUEEN-OF-THE-NIGHT-ROH.-PHOTO-TRISTRAM-KENTON.jpg.jpg)
<figcation>Sabine Devieilhe as the Queen of the Night in *Die Zauberflöte*, ROH, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

Speaking of maniacal, the Monostatos of [Peter Bronder](/scene/people/peter-bronder/) brought the house down. This creepy and twisted creature slithered about the stage, more screaming his lines than singing, which made the actions of him and his evil band of goons thrilling to watch. Bronder is the kind of performer who we could glean meaning from only seeing his eyes peering through a black curtain - every movement is filled with intention.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505312952500/2017-09-12---Die-Zauberflote-09-09-17-ROH-2034-PETER-BRONDER-AS-MONOSTATOS-ROH.-PHOTO-TRISTRAM-KENTON.jpg.jpg)
<figcation>Peter Bronder as Monostatos in *Die Zauberflöte*, ROH, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

The misogynistic elements of Schikaneder's libretto are still there, and it was heartening to hear the London audience snigger in disbelief as text about the uselessness of women appeared in the surtitles. Siobhan Stagg seemed to make a clear choice in her performance to not accept Sarastro's words of needing a man to guide her to her destiny, and indeed gave a strong Pamina throughout the evening. The sound of her voice was rich and moved with ease, giving an extremely heartfelt performance of Pamina's suicide aria.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505312965941/2017-09-12---Die-Zauberflote-09-09-17-ROH-3663-DIE-ZAUBERFLOTE-PRODUCTION-IMAGE-ROH.-PHOTO-TRISTRAM-KENTON.jpg.jpg)
<figcation>Production image from *Die Zauberflöte*, ROH, 2017. Photo: Tristam Kenton.</figcaption>
</figure>

David McVicar's 2003 production is as beautiful and relevant as ever, definitely proving to be timeless in its enchanting pictures of the starry night and radiant day. Whether this is your first opera or your fiftieth, I recommend seeing this one. [*Die Zauberflöte*](http://www.roh.org.uk/productions/die-zauberflote-by-david-mcvicar) runs until mid-October (including a [live cinema broadcast on September 20](http://www.roh.org.uk/showings/the-magic-flute-live-2017)), so there are plenty of chances to have a magical evening with Mozart at the Royal Opera House.
