+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-01-29T02:43:19+00:00"
disclaimer = ""
image_gallery = []
postamble = "For more with the London Philharmonic Orchestra, check out their [season line-up](https://www.lpo.org.uk/what-s-on/introduction-to-the-lpo-s-2018-19-london-season.html)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548730237/media/2019/01/sqValkyriesinLondonPhilharmonicOrchestraDieWalku%CC%88reatRoyalFestivalHallonSunday27thJanuary2019CreditSimonJayPrice.jpg"
primary_image_credit = "The Valkyries in Die Walküre, London Philharmonic Orchestra, conducted by Vladimir Jurowski, 2019. Photo: Simon Jay Price."
related_articles = ["articles/in-review-siegfried.md", "articles/in-review-fidelio-other-first-operas.md"]
related_companies = []
related_people = ["scene/people/claudia-mahnke.md", "scene/people/markus-marquardt.md", "scene/people/stuart-skelton.md", "content/scene/people/ruxandra-donose.md"]
short_description = "This semi-staged production at the Southbank Centre's Royal Festival Hall with the London Philharmonic Orchestra had none of that. Well, except for the drama. There was a lot of drama."
slug = "there-was-a-lot-of-drama-the-lpos-die-walkure"
title = "There was a lot of drama: the LPO's Die Walküre"
youtube_url = ""

+++
Wagner, for me, has always conjured up images of grandeur. I think of massive, fantastical set pieces, rich, other-worldly costumes, and heavy drama. This semi-staged production at the Southbank Centre's Royal Festival Hall with the [London Philharmonic Orchestra](https://www.lpo.org.uk/) had none of that. Well, except for the drama. There was a lot of drama. Expecting to be disappointed by the lack of production value, I was pleasantly surprised by how relieved I was for the lack of distractions in a production that was stripped back, subtle, and that touched at the very heart of the story. It is rare in opera for the orchestra to have so much of our attention, but this really made the music the primary focus and it presented a different and effective way to produce opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548730199/media/2019/01/LPOWalkureLPO.jpg){{% /md %}}

<figcaption>The London Philharmonic Orchestra plays Wagner's Die Walküre, conducted by Vladimir Jurowski, 2019. Photo: Simon Jay Price.</figcaption>

</figure>

The drama exists in the music and the text. Beyond that, not much more is needed. The singers were limited in their staging due to the constrictions of the stage but they were able to make good use of what space they had. All of the character relationships were clear. The music and the text intertwine to give us a sense of the inner emotional worlds of these characters. There is so much scope and imagination in the music which was beautifully and subtly handled by the London Philharmonic with Vladimir Jurowski at the helm. It is a rich, textured score, expansive in its reach; memorable, yet forever surprising and complex. The storytelling was aided through the use of subtle lighting changes, and simple, evocative but unobtrusive projections, and nothing more.

> What the production did quite efficiently, is prove that opera does not require all its usual trappings to work.

Vocally, it is an extremely involved piece and a massive undertaking for which all the performances deserve to be commended. But it was mezzo soprano[ Ruxandra Donose](/scene/people/ruxandra-donose/) in the role of Sieglinde who gave one of my favourite performances of the evening. She had one of the most easy-sounding voices on stage and was a beautiful, sensitive actress. Her actions were always very clear, and thoughtful. Watching carefully, particularly in the long instrumental interludes between singing that Wagner is so famous for, I noticed she was able to stay in character the entire time. She told us Sieglinde's story through her expressions, so much of which, we never learn from the text itself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548730483/media/2019/01/LPOWalkureDonose.jpg){{% /md %}}

<figcaption>Ruxana Donose (Sieglinde) in Die Walküre, London Philharmonic, conducted by Vladimir Jurowski, 2019. Photo: Simon Jay Price.</figcaption>

</figure>

Heldon tenor [Stuart Skelton](/scene/people/stuart-skelton/) was wonderful in the role of Siegmund and a definite draw for many in the audience as he has steadily been making a name for himself internationally. He somehow managed to achieve the colossal task of making it look easy. A few of his high notes were over pressurized and strained but I was able to forgive this as I felt he was taking a risk for dramatic purposes and was still able to produce an extraordinary sound. Most importantly, he gave a soulful performance with a fully realized character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548730796/media/2019/01/LPOWalkureSkelton.jpg){{% /md %}}

<figcaption>Stuart Skelton (Siegmund) in Die Walküre, London Philharmonic, conducted by Vladimir Jurowski, 2019. Photo: Simon Jay Price.</figcaption>

</figure>

Though soprano Svetlana Sozdateleva gave a valiant performance as Brünnhilde, I felt she struggled with the size of the role. Unexpectedly, some of her most connected singing was in her final aria in Act III but in general it was weak and unsure. Her staging did not feel fully integrated and she lacked a lot of the penetrating energy expected from a Brünnhilde. I have no doubts though that it will be a role she will continue to sing increasingly well in the future.

I was particularly unimpressed with bass baritone [Markus Marquardt](/scene/people/markus-marquardt/) in the role of Wotan. Though it was quite a remarkable voice, it lacked variation of colour which caused him to come across quite bland and insensitive. Wotan is a complicated character and I would have liked to see a little more of his internal struggle as he grapples to make some very difficult decisions over the course of the opera. A lot of this contention was missing from the performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548730614/media/2019/01/LPOWalkureMarquardtSozdateleva.jpg){{% /md %}}

<figcaption>Markus Marquardt (Wotan) and Svetlana Sozdateleva (Brünnhilde, background) in Die Walküre, London Philharmonic, conducted by Vladimir Jurowski, 2019. Photo: Simon Jay Price.</figcaption>

</figure>

Mezzo-soprano [Claudia Mahnke](/scene/people/claudia-mahnke/) in the role of Fricka was another favourite of the evening. I am used to seeing this character portrayed by an older singer, so it was very refreshing to watch someone take on the role in the prime of her career. She was fearsome, focused, and confident. She has an extremely versatile instrument; powerful and yet always in control. I would be very interested to see her on stage again.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548730570/media/2019/01/LPOWalkureMahnke.jpg){{% /md %}}

<figcaption>in Die Walküre, London Philharmonic, conducted by Vladimir Jurowski, 2019. Photo: Simon Jay Price.</figcaption>

</figure>

The performance was a great success; that much was clear from the eruption of the audience as the final notes of the opera ended. The Philharmonic brought a sense of simplicity and purity to the score that I think would have pleased many a Wagnerian. What the production did quite efficiently, is prove that opera does not require all its usual trappings to work. It is the marriage of the music and words that create these characters in relationship. All the rest can easily be left up to our imaginations.