+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2017-11-08T20:08:00-05:00"
lastmod = "2017-11-08T21:58:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189665022/2017-11-09---Christine-Goerke_DIE-WALKU%CC%88RE_37A5016a_c.Cory-Weaver.jpg.jpg"
primary_image_credit = "Christine Goerke (Brünnhilde) in Die Walküre, Lyric Opera of Chicago, 2017. Photo: Cory Weaver."
publishDate = "2017-11-08T21:58:00-05:00"
related_articles = ["articles/in-review-die-walkre-at-the-coc.md","articles/the-ride-of-the-dragkyries-how-to-name-an-opera-drag-queen.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/christine-goerke.md","scene/people/brandon-jovanovich.md","scene/people/elisabet-strid.md","scene/people/tanja-ariane-baumgartner.md","scene/people/eric-owens.md"]
short_description = "This is a dark and ponderous tale that is driven by the psychologies of the handful of principal characters who share between themselves several lengthy dialogues. Wagner&#039;s worlds are inherently immense and overly ambitious (that is, garish) productions of his Ring in particular merely distract."
slug = "die-walkure"
title = "&quot;Truly gripping&quot;: Die Walküre at Lyric Opera of Chicago"
+++

With this month's run of [Wagner's *Die Walküre*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/die-walkure-opera-tickets), the Lyric Opera of Chicago marks a glorious second installment of their new four-year-long *Ring Cycle*. Sir Andrew Davis (to whom this production is dedicated in honor of his 30th anniversary on the LOC podium) and director David Pountney brought aural and visual splendor that was at once poignantly understated and epic in all the right degrees.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189115949/2017-11-09---DIE-WALKU%CC%88RE_37A1143_c.Cory-Weaver.jpg.jpg)
<figcaption>A scene from *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
Singers aside for the moment, the undisputed star of the show to my ears was the LOC orchestra, ever-impressive for their stylistic flexibility, nuance, and three-dimensional tone. The fantastic brass section was imposing throughout rather than bombastic, even in that perennial crowd-pleaser, "The Ride of the Valkyries," that opens Act 3. The strings captured the swelling taboo passions of Siegmund and Sieglinde in Act 1 stupendously, while in Act 2 they provided a quilt of sound that enveloped Wotan and Brünnhilde during their weighty exchange. Maestro Davis, a seasoned Wagnerian, led this complex score with irreproachable conviction and terrific sweep.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189175339/2017-11-09---Brandon-Jovanovich_Elisabet-Strid_DIE-WALKU%CC%88RE_37A4281_c.Cory-Weaver.jpg.jpg)
<figcaption>Brandon Jovanovich and Elisabet Strid in *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
Director David Pountney certainly is no stranger to large projects. Having directed LOC's *Das Rheingold* last season, Pountney returns to Chicago with an imaginative and compelling realization of *Die Walküre*. This is a dark and ponderous tale that is driven by the psychologies of the handful of principal characters who share among themselves several lengthy dialogues. Wagner's worlds are inherently immense and overly ambitious (that is, garish) productions of his *Ring* in particular merely distract. For truly gripping Wagner, I believe less is indeed more. In this regard, Pountney's vision was superbly and refreshingly sober.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189202391/2017-11-09---DIE-WALKU%CC%88RE_37A5861_.Cory-Weaver.jpg.jpg)
<figcaption>A scene from in *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
Only one moment stood out for me as questionable, jarring even. When the curtain raised on Act 3, the scene was like something out of Hannibal Lecter's daydreams. Bloodied corpses dangled from a net like Chinese barbequed ducks. The Valkyries, Wotan's nine warrior daughters who bring fallen heroes to Valhalla, were dressed in red surgical scrubs and shuffled around operating tables, atop which laid half-dead bodies in various stages of decapitation. In addition to wings, the mythic steeds of three of the sisters included plastic body-bags plump with blood and limbs. An audible gasp echoed throughout the house. I really didn't understand what this gruesomeness was supposed to add to the story. Considering the artful portrayal of Brünnhilde by soprano Christine Goerke—thoughtful, fierce, and vulnerable in equal measure — this grisly scene struck me as an eyebrow-raising non sequitur.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189228642/2017-11-09---DIE-WALKU%CC%88RE_37A5523c.Cory-Weaver.jpg.jpg)
<figcaption>A scene from *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
Otherwise, the industrial chic look of the production with its charcoal hues and gritty scaffolds stylishly captured the characters' ashen inner-lives. Hunding's home, here a kind of decrepit brick-walled warehouse with a riveted steel door, befit its chauvinistic ogre of an owner who keeps Sieglinde as more of a servant than a wife. Although, I must say, the directorial choice to have Sieglinde shackled to the home's ash tree and to have her tugged hither and thither by a chain seemed a bit on the nose. All the more so in light of [Elisabet Strid](/scene/people/elisabet-strid/)'s visceral impersonation of the clearly traumatized woman. The Swedish soprano, who makes her LOC debut with this role, relishes big repertoire and boasts impressive Wagner bona fides. Her voice, though thin at times, was radiant and dramatically resplendent.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189246629/2017-11-09---Brandon-Jovanovich_Elisabet-Strid_DIE-WALKU%CC%88RE_37A4400_c.Cory-Weaver.jpg.jpg)
<figcaption>Brandon Jovanovich and Eisabet Strid in *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
American tenor [Brandon Jovanovich](/scene/people/brandon-jovanovich/) was magnificent as Siegmund, Sieglinde's long-lost brother/husband. To be sure, the incestuous relationship between the two can be an icky subject (and a grave one for Wotan to deal with in Act 2), but the Strid-Jovanovich duo delivered a captivating performance without sacrificing neither taste nor bliss. Their love was expressed as a heightened recognition of oneself in another: their faces a mutual reflection, their voices a mutual echo. The pair looked and sounded utterly committed as siblings/lovers. Their final consummation at the end of Act 1 was ecstatic and realized as a grand splash of color—the cold stones of Hunding's home gave way to a spectacular backdrop of pure sylvan beauty. Scenery designers Johan Engels and Robert Innes Hopkins deserve special recognition for this master stroke.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189260726/2017-11-09---Eric-Owens_DIE-WALKU%CC%88RE_37A3836_c.Cory-Weaver.jpg.jpg)
<figcaption>Eric Owens in *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
With Act 2, LOC welcomed back American bass-baritone [Eric Owens](/scene/people/eric-owens/), reprising the role of Wotan. In both sound and stature, Owens proved a formidable chief among the gods. Sadly, I was not in town for last season's *Das Rheingold*, so my sense of continuity is limited. But Owens' performance in *Walküre* was gripping from beginning to end. Dressed to the nines in a tuxedo and making his entrance on a suspended platform made to look like a ritzy penthouse, Wotan observes the unfolding events down below, peering through a telescope. His wife Fricka, the goddess of marriage here sung by German mezzo [Tanja Ariane Baumgartner](/scene/people/tanja-ariane-baumgartner/), enters and admonishes her husband for not reprimanding his lascivious illegitimate offspring. With great intelligence and a pointedly cool demeanor, Baumgartner showed us a woman genuinely aggrieved by her husband's infidelities rather than a character who can too easily come across as a shortsighted hausfrau. And she sounded superb! Hers is a smooth mezzo that cuts through the orchestra like a warm knife through butter.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189271519/2017-11-09---Tanja-Ariane-Baumgartner_DIE-WALKU%CC%88RE_37A4667_c.Cory-Weaver.jpg.jpg)
<figcaption>Tanja Ariane Baumgartner in *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
The heart of the act, as well as one of the most challenging of all operatic moments, is Wotan's massive monologue. Davis and Owens were clearly of one mind about these pages of the score. The pacing was so subtly controlled and Owens lived every word of the text. Sitting on the stone steps of his penthouse, his plans unraveling, his power slipping, Wotan never looked more human, ruminative, and pained as he poured his heart to Brünnhilde, his favorite of the Valkyrie daughters he sired with Erda, the earth-goddess. For the remainder of Acts 2 and 3, [Christine Goerke](/talking-with-singers-christine-goerke/) stole the show. What a phenomenal Brünnhilde she makes! It's extraordinary to hear a soprano accomplish the emotional range and full-throated drama demanded by this role while also maintaining a Mozartian clarity and lyricism throughout.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189300430/2017-11-09---Christine-Goerke_DIE-WALKU%CC%88RE_37A5936_c.Cory-Weaver.jpg.jpg)
<figcaption>Christine Goerke in *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
 
For its stellar international cast, visionary direction, and breathtaking staging [LOC's new *Die Walküre*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/die-walkure-opera-tickets) measures up to Wagnerian theatrical ideals. This is a must-see event. The production runs at the Civic Opera House through November 30.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510189377758/2017-11-09---Christine-Goerke_Brandon-Jovanovich_Elisabet-Strid_DIE-WALKU%CC%88RE_37A5056_c.Cory-Weaver.jpg.jpg)
<figcaption>Christine Goerke, Brandon Jovanivich, and Elisabet Strid in *Die Walküre*, Lyric Opera of Chicago, 2017. Photo: Cory Weaver.</figcaption>
</figure>
