+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-06-21T21:05:00-04:00"
lastmod = "2018-06-22T20:24:00-04:00"
preamble = "[dell'Arte Opera Ensemble](http://dellarteopera.org/)  is gearing up for its 16th annual Summer Festival, centred this year on two of music's most notable \"professional rivals\", Mozart and Salieri. On the summer's lineup are productions of the Vienna version of Mozart's *Don Giovanni* (Aug. 11-25), the U.S. premiere of Salieri's *La Cifra* (Aug. 18-26), and evenings of scenes and songs by the two contemporary composers.\n\nWe spoke with Artistic Director Christopher Fecteau about dell'Arte's upcoming season, and the program's unique approach to training opera's young artists."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529629411740/sqRachelHall.jpg.jpg"
primary_image_credit = "Rachel Hall in dell'Arte Opera's production of The Cunning Little Vixen, 2017. Photo: Brian Long."
publishDate = "2018-06-21T22:04:00-04:00"
short_description = "&quot;Because it&#039;s such a long process, and because of the intensity of the repertory/festival format at the end, our training regimen is quite intense for the singers.  Some come away truly ready to leap forward in their careers; others in the ensemble and smaller roles get a real taste of what it takes to do things well - the tremendous amount of work and commitment required.&quot;"
slug = "dellarte-opera-nods-to-mozart-salieri-in-2018"
title = "dell&#039;Arte Opera nods to Mozart &amp; Salieri in 2018"
+++

## What do you think is the function of a summer opera training programme like dell'Arte Opera?

Our program goes beyond the model of most summer programs, where singers are usually expected to arrive with repertoire learned and ready to go.  We intervene earlier in the process with contact designed to improve and engage the role-study process.  We offer language classes that emphasize not only lyric diction, but also translation and syntax skills that help the performer get inside the libretto. 

Chuck Hudson teaches a 15-hour class called "Movement & Acting Skills for Singers" that develops a physical vocabulary for expression. This year, recitative classes introduce a historical background of this important component of opera, as well as providing practical skills for making effective and informed performance choices.  All through the spring, individual coachings bring all the skills together in application to every word and note of the role.  

In short, we try to super-charge the singer's process for more efficient, more engaged, and more expressive work that they can take to the rehearsal room and into performances.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529629263941/KirstiEsch.jpg.jpg)
<figcaption>Kirsti Esch in dell'Arte Opera's production of *La Calisto*, 2017. Photo: Brian Long.</figcaption>
</figure>

## What are some highlights of the 2018 season that you particularly look forward to?

The repertoire this season is centered around not only Mozart and Salieri, but also Da Ponte and the Viennese Court Theater.  I'm looking forward to seeing how audiences experience the Vienna version of *Don Giovanni* (with a seriously crazy Leporello/Zerlina duet, and without the sort of "happy ending" finale we're all used to).  When the final screams of Giovanni and Leporello fade away, I hope audiences are left a little breathless - somehow that would be very fittingly modern for this story in today's climate.  

We're also presenting the American premiere of *La Cifra* by Salieri - it's only had one other modern production in Europe a few years ago, and there are no complete recordings.  On the surface, it's a charming little mystery piece, but it offers has some sharp edges as well.  

[Stage director] Brittany Goodwin returns for her third assignment with us, and is bringing a *commedia dell'arte* approach to the story telling.  It will be a little bit *Cinderella*, a little bit *Pagliacci*, and who knows what else people will find in it.  It's exciting to me that *Cifra* is already selling really well!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529629256570/Fecteau.jpg.jpg)
<figcaption>Chris Fecteau, Artistic Director of dell'Arte Opera.</figcaption>
</figure>

## What do you hope the singers of dell'Arte will take away from their time with the programme?

Because it's such a long process, and because of the intensity of the repertory/festival format at the end, our training regimen is quite intense for the singers.  Some come away truly ready to leap forward in their careers; others in the ensemble and smaller roles get a real taste of what it takes to do things well - the tremendous amount of work and commitment required.  

A small number, even some of our best performers, realize exactly the kind of dedication required to be a great opera performer, and decide to pivot toward other life interests. Some become teachers and administrators, others wonderful moms, one alumna is a fantastic jazz singer who just dropped her fourth album, more than one social activist.  

I couldn't be more proud of the kinds of people that we've gotten to know of our 500-plus singer alumni, and all the wonderful paths they've chosen, informed by some craft, some serious work, and dedication to something special.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1529629207562/FQ3.jpg.jpg)
<figcaption>A scene from dell'Arte Opera's production of *The Fairy Queen*, 2014. Photo: Brian Long.</figcaption>
</figure>

>For full details about dell'Arte's 2018 season, [click here.](http://dellarteopera.org/)
