+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = 2019-11-25T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "The Royal Opera House's production of [_Death in Venice_](https://www.roh.org.uk/tickets-and-events/death-in-venice-by-david-mcvicar-details) runs through 6 December."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1574711234/media/2019/11/sq1415LeoDixonasTadzioinDeathinVeniceROH2019CatherineAshmore_a8oyii.jpg"
primary_image_credit = "Leo Dixon as Tadzio in Death in Venice, ROH, 2019. Photo: Catherine Ashmore."
related_articles = ["articles/6-operas-to-creep-you-out.md", "articles/roh-billy-budd.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/gerald-finley.md", "scene/people/mark-padmore.md"]
short_description = "At first glance, this opera based on the Thomas Mann novella of the same name doesn't lend itself to the stage which could, in part, be the reason Britten sat with the piece for so many years."
slug = "death-in-venice-a-near-perfect-production"
title = "Death in Venice: a near-perfect production "
youtube_url = ""

+++
This new production of _Death in Venice_ joins _Billy Budd_ and _The Turn of the Screw_ in a trio of Britten operas to be performed at the Royal Opera House as a commitment to staging British works and feature British artists. [_Billy Budd_](/transcendent-ambitious-billy-budd-at-roh/) saw a hugely successful run late last season and a new production of _The Turn of the Screw_ will premiere next year in the Linbury Theatre. David McVicar directs this stunning new production of _Death in Venice,_ designed by Vicki Mortimer, which sees the work return to the Royal Opera stage for the first time since 1992.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574711278/media/2019/11/1584GeraldFinleyTravellerMarkPadmoreAschenbach_inDeathinVeniceROH2019CatherineAshmore_cc1qln.jpg){{% /md %}}

<figcaption>(l-r) Gerald Finley (Traveller) and Mark Padmore (Aschenbach) in Death in Venice, ROH, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

It was interesting to see a large-scale production of such an intimate and introspective opera in a space as grand as the Royal Opera House. Something felt off about it, and yet it was incredibly exciting to see that level of intimacy achieved in a production that very quickly swept me away.

> Aschenbach's journey is a heart-wrenchingly painful one and Padmore played him with a sensitivity

At first glance, this opera based on the Thomas Mann novella of the same name doesn't lend itself to the stage which could, in part, be the reason Britten sat with the piece for so many years. But very quickly we begin to see that all of the choices Britten and librettist Myfanwy Piper painstakingly made create a work that is visually and aurally riveting both live and on the page.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574711293/media/2019/11/1601GeraldFinleyastheGondolierandMarkPadmoreasAschenbachinDeathinVeniceROH2019CatherineAshmore_lfohim.jpg){{% /md %}}

<figcaption>Gerald Finley (Gondolier) and Mark Padmore (Aschenbach) in Death in Venice, ROH, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

Britten's swan song and a reflective musing on life and death, this was the composer's final opera, completed just three years before his death in 1976. It is apparent that the potentially controversial subject matter was very personal for Britten, but it is all handled with a deft hand. That would be a key word I would use in describing the piece; deft. The music is atmospheric, suggestive, and playful; it is everything that we have come to expect from the composer plus an added sense of clarity and ease that seems to suggest an arrival point. In many ways, it is among his greatest work.

The production oozed with a heady, youthful energy. An image of early 20th-century Venice was painted with all of its seduction, mystery, and enticement. I was reminded of E.M. Forster's _A Room with A View_; this sense exoticism that was in Italy at the turn of the century, for the hordes of holidaymakers that flooded the city every season, was perfectly represented in this production. McVicar and Mortimer have essentially captured the essence that is at the core of this opera which is a beautiful and rare thing to see on stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574711343/media/2019/11/16741584LeoDixonTadzioinDeathinVeniceROH2019CatherineAshmore_opbxzq.jpg){{% /md %}}

<figcaption>Leo Dixon as Tadzio in Death in Venice, ROH, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

Tenor [Mark Padmore](/scene/people/mark-padmore/) was the ideal Aschenbach. Though rather uninspiring vocally, physically he brought the character to life with a detailed and considered performance. Almost immediately we feel for the aging writer. Though full of doubt, he is drawn to Venice in search of inspiration which he ultimately finds in the youthful and beautiful Tadzio.

> He took on many different voices, showcased some impressive falsetto, and put on an assortment of entertaining accents.

But Aschenbach remains frightened, uptight, and closed off. Sweeping moments of joy and awe at the love he feels for this young man are thrown into contrast with the harsh reality of his situation; he is middle-aged, burnt-out, and utterly unable to rack up the courage to speak to this young man. This only makes the cholera outbreak and his eventual death at the end of the opera all the more tragic; he dies, unfulfilled wrecked with loneliness and remorse. Aschenbach's journey is a heart-wrenchingly painful one and Padmore played him with a sensitivity that had us following alongside him the whole way.

Baritone [Gerald Finley](/talking-with-singers-gerald-finley/) was fantastic appearing as a variety of characters over the course of the opera. We initially see him as the lone traveller Aschenbach encounters in a graveyard, but he goes on to play an elderly fop, a gondolier, a hotel manager, a barber, a leader of an acting troupe, and finally as the voice of Dionysus who appears to Aschenbach in a dream.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574711369/media/2019/11/1877LeoDixonTadzioMarkPadmoreAschenbachinDeathinVeniceROH2019CatherineAshmore_mlr0ii.jpg){{% /md %}}

<figcaption>Leo Dixon as Tadzio and Mark Padmore (Aschenbach) in Death in Venice, ROH, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

Finley brought a distinct and fully realized character to each role but his constant reappearance on stage seemed to suggest that perhaps there was some invisible thread connecting these otherwise unrelated characters; appearing at key moments in the plot, they became spiritual guides on Aschenbach's journey of discovery, nudging him forward, daring him to take a risk. Finley gave a very committed performance in each of these roles.

> I would urge all who have the opportunity to go and see this opera.

A physically demanding endeavour, each character had a well-defined energy that Finley portrayed seemingly with ease. Vocally, the score required him to be all over the map. He took on many different voices, showcased some impressive falsetto, and put on an assortment of entertaining accents. He was the perfect contrast to Padmore's anxious, and introspective Aschenbach.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574711394/media/2019/11/2191MarkPadmoreasAschenbachandGeraldFinleyastheElderlyFopinDeathinVeniceROH2019CatherineAshmore_hgyuym.jpg){{% /md %}}

<figcaption>Mark Padmore (Aschenbach) and Gerald Finley (Elderly Fop) in Death in Venice, ROH, 2019. Photo: Catherine Ashmore.</figcaption>  
</figure>

I would be remiss if I did not mention the wonderful performances by the young male dancers, in particular Leo Dixon, who played the role of Tadzio. Britten's decision to make this a silent role played by a dancer was, I believe, the right one as Aschenbach never says a single word to Tadzio over the course of the entire opera. He becomes a distant and silent character, speaking through movement rather than words, making him all the more mysterious and intriguing both to Aschenbach and to the audience. He becomes a monument to youth and beauty; perfection on a pedestal for our main character to idolize.

Once in a while a production comes around that is near perfection, and this was just one of those productions. It was a delicate and intimate handling of a piece that is incredibly poignant and changing. I would urge all who have the opportunity to go and see this opera.