+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-04-22T13:43:00+01:00"
lastmod = "2016-04-22T14:38:00+01:00"
preamble = "On May 3 and 4 at Toronto's Trinity-St. Paul's Centre, the [Talisker Players](/scene/companies/talisker-players/) present [*Cross'd by the Stars*](http://www.taliskerplayers.ca/crossedbystars.html), a concert filled with music about \"soulmates who are fated to be torn apart.\" Mezzo-soprano [Krisztina Szabó](/scene/people/krisztina-szabo/), baritone [Aaron Durand](/talking-with-singers-aaron-durand/), and reader Stewart Arnott join the Talisker Players for works by Purcell, Gluck, Bernstein, Mahler, and the premiere of [Dean Burry](/scene/people/dean-burry/)'s *The Highwayman*, based on the poem by Alfred Noyes.\n\nWe spoke with Burry about his new piece, about having it premiered by Szabó, a noted champion of new music, and on what he has learned about writing for the voice.\n\nFor full details and ticket information for *Cross'd by the Stars*, follow our box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461329041293/2016-04-22---Burry-pic.jpg.jpg"
publishDate = "2016-04-22T13:55:00+01:00"
related_articles = ["articles/in-review-bluebeards-castle-erwartung.md","articles/canadian-childrens-opera-companys-lullabies-from-kids-for-kids.md","articles/kevin-puts-i-know-who-i-am-as-a-composer.md","articles/talking-with-composers-ivan-barbotin.md"]
related_companies = ["scene/companies/talisker-players.md","scene/companies/canadian-childrens-opera-company.md","scene/companies/canadian-opera-company.md","scene/companies/opera-lyra-ottawa.md","scene/companies/toronto-masque-theatre.md","scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/dean-burry.md","scene/people/krisztina-szab.md","scene/people/aaron-durand.md","scene/people/jacqueline-woodley.md"]
short_description = "On May 3 and 4 at Toronto&#039;s Trinity-St. Paul&#039;s Centre, the Talisker Players present Cross&#039;d by the Stars, a concert filled with music about &quot;soulmates who are fated to be torn apart.&quot; Mezzo-soprano Krisztina Szabó, baritone Aaron Durand, and reader Stewart Arnott join the Talisker Players for works by Purcell, Gluck, Bernstein, Mahler, and the premiere of Dean Burry&#039;s The Highwayman, based on the poem by Alfred Noyes."
slug = "dean-burry-on-the-highwayman"
title = "Dean Burry on &quot;The Highwayman&quot;"
+++

## What appealed to you about Noyes' poem "The Highwayman", and why did you decide it would make a good basis for a musical setting?

The piece is written as 17 distinct songs roughly corresponding to the stanzas of the poem and was also quite influenced by Schoenberg’s *Pierrot Lunaire*. Both poems share a lot of moon imagery and also the same orchestration (piano, flute/piccolo, clarinet/bass clarinet, violin and cello).  Noye’s dark story of passion, sadism, suicide and murder certainly fits in that expressionist vein, so it felt like a natural direction to take.  

I also wrote it as part of my doctoral program at the University of Toronto.  It had been about 17 years since I completed my Master’s degree, and the opportunity came up to go back and get those last few letters.  It was a bit of a surreal experience going back to school after working as a professional composer for almost two decades, but the bottom line is that we are always learning (or should be). Being able to examine my craft as a student again was actually quite liberating and I couldn’t have asked for a better guide for that then my composition teacher and good friend [Christos Hatzis](http://homes.chass.utoronto.ca/~chatzis/).  

Having worked in the opera field and certainly "children’s" opera field for so many years provided the great opportunity to develop my own artistic voice.  But I wanted to try something different…to broaden out.  I’ve written 12 commissioned operas over the years but also had a very small amount of any other repertoire.  Just the way things went (and being a storyteller at heart, I’m obviously not complaining).  After a year of trying some really “out there” things I decided it was time to try and take my own voice and push it out.  So that’s what *The Highwayman* was - really 100% Burry, but hopefully expanded.

*The Highwayman* and I have a long history and it has been sitting in my head waiting to be adapted for a while.  I’ve always loved the poem and I actually recited it at the Kiwanis Music Festival in Gander when I was in grade 5.  I think a lot of people have affection for it even though it is a little sentimental and melodramatic (just like me) and really it is incredibly evocative.  The first stanza…the moon, the road…I totally see it and so scoring it was much more like painting a picture. 

I’d say the last bit of inspiration for the work came from seeing a dramatic staging of Kurtag’s *Kafka Fragments* directed by [Joel Ivany](/scene/people/joel-ivany/) and expertly sung by [Jacqueline Woodley](/scene/people/jacqueline-woodley/) at [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) a few years back.  Just loved the inventiveness of dramatizing a song cycle.  So, to modify my early words, it wasn’t conceived as an opera, but the dramatic elements could certainly be played up.

## Did you know you would be writing *The Highwayman* for Krisztina Szabó to premiere it? How do you balance writing for specific singers, and writing works that can lead to repeated performances by other artists?

I didn’t know that the work was going to be premiered by [Krisztina](/talking-with-singers-krisztina-szabo/) when I wrote it. In fact, like Pierrot, with a few modifications, it really could be sung by a mezzo or a soprano.  That being said, when it came time to put this piece together for my graduate recital, Krisztina was the first person to come to mind.  We’ve actually worked together on a few projects including *The Mummers’ Masque* at [Toronto Masque Theatre](/scene/people/toronto-masque-theatre/) and the serial opera I wrote for CBC, [*Baby Kintyre*](/in-review-baby-kintyre/).  As far as I’m concerned she is everything I look for in a performer: committed, invested, fearless, versatile, authentic, smart, and oh yeah, she has a phenomenal voice.  We also live in the same ‘hood so any chance I get to work with her I leap.  And the Talisker Players seemed like such a logical fit as well.  Their reputation for performing great works for voice and chamber ensemble made them the perfect group to perform the premiere.  I also love that their concerts aren’t limit to one era… I believe there is some Purcell happening alongside my work, and I really appreciate concerts that aren’t "new music" or "period music" but just "music". 

The question of balancing a work between the specific singers who premiere it and those who will perform it later on is an interesting one, though.  Having worked so much in the operatic field, and with great companies like the [Canadian Opera Company](/scene/companies/canadian-opera-company/) and [Canadian Children’s Opera Company](/scene/companies/canadian-childrens-opera-company/) (even closer relations there now as the new Artistic Director!), [Opera Lyra](/scene/companies/opera-lyra-ottawa/) and Toronto Masque Theatre, I’ve had a lot of time to understand the voice.  And I really pride myself on writing music that is comfortable to sing.  That doesn’t mean it isn’t hard (*The Highwayman* is definitely tough), it just means that it takes into consideration what works and doesn’t work for those two little folds of flesh in our throats.  If singers are comfortable with the music, they tend to be much more willing to go the distance dramatically, and that’s when the magic happens.  Unless a singer commissions a work with special or "unique" instructions, I just concentrate on trying to write something that's thrilling but healthy.

## Is there anything unique about the "star-cross’d lovers" in this poem, in context of the theme of this concert?

I think one thing that is unique about these lovers is the character of *The Highwayman* himself.  When we think of a rogue, a scoundrel we think or perhaps or a womanizer, someone who is just using Bess, the landlord’s daughter.  But that’s not the case.  Yes, he’s got the dashing outfit but he really loves her with all his being.  And that helps makes the passion and tragedy all the more real.
