+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = 2019-11-05T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Lyric Opera of Chicago's production of [_Dead Man Walking_](https://www.lyricopera.org/productions/2019-20/dead-man-walking/) runs through November 22."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1572923612/media/2019/11/sqLOCDeadManWalking6531_dy0mye.jpg"
primary_image_credit = "Dead Man Walking, Lyric Opera of Chicago, 2019. Photo: Ken Howard."
related_articles = ["articles/we-took-a-real-chance-with-great-scott.md", "articles/dead-man-walking-makes-its-minnesota-opera-debut.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/ryan-mckinny.md", "scene/people/patricia-racette.md", "scene/people/susan-graham.md"]
short_description = "Graham's performance is gut-wrenchingly sincere and she's as vocally resplendent as ever, even when her voice seems on the verge of breaking with emotion."
slug = "stellar-performances-from-a-star-cast-in-chicagos-dead-man-walking"
title = "Stellar performances from a star cast in Chicago's Dead Man Walking"
youtube_url = ""

+++
Nearly two decades after its world premiere, [_Dead Man Walking_](https://www.lyricopera.org/productions/2019-20/dead-man-walking/) has landed in Chicago. The opera, with music by Jake Heggie and libretto by playwright Terrance McNally, is a dramatization of scenes from Sister Helen Prejean's memoir of the same name.

Since the book's release in 1993, Sister Helen has become the nation's leading advocate for the abolishment of the death penalty. While _Dead Man Walking_ also exists as a play and a movie, the opera is a unique adaptation that carefully eschews a simplified portrait of Sister Helen in favor of a powerful work of theater that illuminates and makes personal the myriad attitudes and viewpoints on all sides of the death penalty debate.

> Racette's endlessly sparkly tone and pitch-perfect diction rendered the supertitles wholly superfluous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572923669/media/2019/11/LOCDeadManWalking674_nkambc.jpg){{% /md %}}

<figcaption>Dead Man Walking, Lyric Opera of Chicago, 2019. Photo: Ken Howard.</figcaption>  
</figure>

With these performances, the exquisite [Patricia Racette](/scene/people/patricia-racette/) makes her role debut as Sister Helen. Racette's earnest portrayal was deeply moving and crucially believable. Moreover, even with a put-on twang, Racette's endlessly sparkly tone and pitch-perfect diction rendered the supertitles wholly superfluous. Onstage for virtually the entire length of the opera, the role of Sister Helen is notoriously difficult in terms of acting and vocal stamina. Racette tackles both with aplomb, delivering a powerhouse performance that is as beautiful to listen to as it is captivating to watch.

> Graham is a committed champion of _Dead Man Walking._

In his debut with the role and at Lyric Opera, bass-baritone [Ryan McKinny](/scene/people/ryan-mckinny/) stuns as death row convict Joseph De Rocher. Vacillating between cynical detachment and raw fear, McKinny's De Rocher never feels trite or straightforward. When we first meet De Rocher, he's selfish and brusk, having invited Sister Helen to Angola with the goal of getting a sympathetic nun to help get his death sentence commuted.

As the opera unfolds and his fate is irrevocably sealed, our original estimation of De Rocher is challenged - he still won't admit his guilt but we also start to see his shame, his frustrated regret, and his human need for connection. It is a testament both to the dramatic arc of the libretto and McKinny's nuanced performance that by the end of the work, De Rocher's deathbed confession and final line, ("I love you"), feel neither predictable nor saccharine.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572923621/media/2019/11/LOCDeadManWalking3375_h59dyw.jpg){{% /md %}}

<figcaption>Dead Man Walking, Lyric Opera of Chicago, 2019. Photo: Ken Howard.</figcaption>  
</figure>

Hunched over and shuffling, with an old pocketbook cradled in her arm, mezzo-soprano [Susan Graham](/scene/people/susan-graham/) disappears into the role of Mrs. De Rocher, Joseph's mother. Graham is a committed champion of _Dead Man Walking_, having created the role of Sister Helen when the work first premiered at San Francisco Opera and previously sang Mrs. De Rocher at Washington National Opera.

> Her big, gleaming voice was simply a joy to hear.

We witness a woman simultaneously in denial and horrified by the crime her son is convicted of, yet who nonetheless pours out her love for her eldest son and implores an appeals panel on his behalf. Graham's performance is gut-wrenchingly sincere and she's as vocally resplendent as ever, even when her voice seems on the verge of breaking with emotion.

Whitney Morrison, a recent alumna of The Patrick G. and Shirley W. Ryan Opera Center, made an impactful professional debut with the company in the role of Sister Rose. Her big, gleaming voice was simply a joy to hear, especially in her Act II scene with Sister Helen.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572923633/media/2019/11/LOCDeadManWalking4430_flplf1.jpg){{% /md %}}

<figcaption>Dead Man Walking, Lyric Opera of Chicago, 2019. Photo: Ken Howard.</figcaption>  
</figure>

McNally's masterful libretto alternates stylized confessional monologues with brief, naturalistic moments of one-on-one dialogue occasionally spiked with a dry, Southern humor. True ensemble scenes are rare but powerful, especially the Act I courtroom scene, in which Sister Helen and the De Rocher family are pushed into the orbit of the parents of the children Joseph murdered. In the roles of the grieving parents, Wayne Tiges, Lauren Decker, Talise Trevigne, and Allan Glassman delivered strongly-sung, emotive performances.

> This show is a testament to the power of operatic storytelling.

While I hope for a future where such things do not require special mention, it is significant to see conductor and new-music specialist Nicole Paiement on the podium, leading the Lyric Opera orchestra through Heggie's tricksy score with agility and passion. While I was well aware she's the first woman conductor I've seen at Lyric since moving to Chicago in 2017, I recently learned Paiement is in fact only the second woman conductor in the company's sixty-five year history. (The first was French conductor Emmanuelle Haïm, who led _Giulio Cesare_ in the 2007-2008 season.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1572923650/media/2019/11/LOCDeadManWalking4335_eg8ixv.jpg){{% /md %}}

<figcaption>Dead Man Walking, Lyric Opera of Chicago, 2019. Photo: Ken Howard.</figcaption>  
</figure>

At the curtain call on opening night, many of the cast members looked to be crying as they took in the roar of the crowd at the Lyric Opera House when composer Jake Heggie escorted Sister Helen Prejean onto the stage. The next-level performances by this cast suggest they have a deeply-felt passion for this opera and a strong belief in its import.

And I share their enthusiasm! Go see _Dead Man Walking_ at Lyric Opera of Chicago. Whether you are a hardcore opera fan or are totally new to the genre, this show is a testament to the power of operatic storytelling.