+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2018-02-25T19:55:00-05:00"
lastmod = "2018-02-25T19:55:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519606104687/sq---whisper02Ian_Douglas.jpg.jpg"
primary_image_credit = "David Lang's the whisper opera, NYU Skirball, 2018. Photo: Ian Douglas."
publishDate = "2018-02-25T19:55:00-05:00"
related_articles = ["articles/in-toronto-david-langs-the-whisper-opera.md"]
related_people = ["scene/people/david-lang.md"]
short_description = "Lang&#039;s music can feel voyeuristic, akin to watching a caged animal on display. The sonic vessel breaths and twitches while staying in place. The listener can examine and probe it at his leisure."
slug = "david-langs-the-whisper-opera-has-intimacy-issues"
title = "David Lang&#039;s the whisper opera has intimacy issues"
+++

Responding to the ability to access an endless digital musical archive, David Lang sought to create a piece "so quiet and so intimate and so personal to the performers that you needed to be right next to them or you would hear almost nothing". Lang's *the whisper opera* in its recent incarnation at the NYU Skirball Center was quiet, even hard to hear, but not intimate.
          	
The production design put the spectators and musicians (from the excellent International Contemporary Ensemble) in close proximity by seating the audience in trenches within the playing area. From any given chair, each patron could only see about half the stage without craning her neck. With a piece that's almost entirely whispered, having the visual information of a moving mouth can be the difference between comprehension and confusion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519606427749/whisper01Ian_Douglas.jpg.jpg)
<figcaption>David Lang's *the whisper opera*, NYU Skirball, 2018. Photo: Ian Douglas.</figcaption>
</figure>
          	
The opera's text is strung together from search engine results. Specifically, how users completed the sentences, "when I am alone I always", "they said I was crazy but I", "when I think of you I think of", and "it's not my fault that I am so". The result is a mostly maudlin amalgamation of thematically connected non-sequiturs that rarely add up to more than their vague parts.
          	
In order to remain an exclusively live experience, the work is never meant to be recorded, but the title track on Lang's 2018 album ["The Day"](https://open.spotify.com/album/6us2dBD31rGA2DPJuWa8si) is a good approximate of *the whisper opera*'s tone and style. Also with a text culled from an incomplete sentence entered into a search engine, his more recent creation has a richer narrative than *the whisper opera* but still disappointingly plays like a half-baked minimalist melodrama.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519606439352/whisper06Ian_Douglas.jpg.jpg)
<figcaption>David Lang's *the whisper opera*, NYU Skirball, 2018. Photo: Ian Douglas.</figcaption>
</figure>
          	
Lang's music can feel voyeuristic, akin to watching a caged animal on display. The sonic vessel breaths and twitches while staying in place. The listener can examine and probe it at his leisure.
          	
New music luminary Tony Arnold took on the opera's thankless protagonist role. Whispering does not engage the vocal folds and is not pitched. That means no melodic content and a reduced palette of articulation. Add to those limitations a stage design that forced Ms. Arnold to exclude half the audience at any given moment. The result, an underwhelming performance from a consistently extraordinary singer.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519606459359/whisper05Ian_Douglas.jpg.jpg)
<figcaption>David Lang's *the whisper opera*, NYU Skirball, 2018. Photo: Ian Douglas.</figcaption>
</figure>
          	
This production generally suffered from a misconception of theatrical intimacy. Bass drums hung over the audience. At each drum, an instrumentalist perched, and, while whispering earnestly and barely tapping the drum head with a finger, locked eyes with the individuals below her. Intimacy requires warmth, friendship, affinity, but this was a confrontation neither party desired. The performer seemed like the prisoner of a kinky taskmaster who demands she whisper his angsty poetry to unwitting strangers as a bizarre act of forced seduction. Her mouth moved obediently while her eyes said, "help."
