+++
author = ["authors/loren-lester.md"]
categories = "Interview"
date = 2023-02-13T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1676255550/media/2023/02/sqDavidLang_tdvi41.jpg"
primary_image_credit = "Photo: Peter Serling."
related_articles = ["articles/in-review-the-whisper-opera.md", "articles/talking-with-composers-cecilia-livingston.md", "articles/kevin-puts-i-know-who-i-am-as-a-composer.md"]
related_companies = []
related_people = []
short_description = "\"When I started giving my pieces silly titles and putting them all in lowercase, it took the pressure off me to be a genius, and then I could concentrate on just writing my music.\""
slug = "david-lang-high-art-in-lowercase"
title = "David Lang: high art in lowercase"
youtube_url = ""

+++
David Lang’s catalog as a composer is astounding for its depth and breadth: choral works, songs, song cycles, orchestral works, ballets, film scores, operas and some things that defy categorization. And yet, during this interview, he proved to be self-effacing and self-deprecating. When he was asked about the enormity of his compositional canon, he offered the humble understatement: "well, I like to write music." Among his many talents, he also proved to possess something rare among some great artists: the ability to discuss his work effortlessly.

In the fifteen or so years since he got onto the worldwide radar by winning the Pulitzer Prize, he has been performed throughout the U.S., Canada, Australia, and Europe. The prize was for his opera _little match girl passion_ – that’s not a typo; all his titles are in lower case. The reason for this goes back to his days in college when he began studying the great composers. He felt the pressure to emulate them, "to write a masterpiece, maybe a piece about life and death, maybe something spectacular that changes music history, or that everyone loves. I found the pressure to write something that was great, before I was ready, was oppressive, and paralyzing. When I started giving my pieces silly titles and putting them all in lowercase, it took the pressure off me to be a genius, and then I could concentrate on just writing my music."

Opera – which Mr. Lang defines much more broadly than many – has consistently held his interest in the decades since his first opera, _modern painters_ (1995). Mr. Lang describes that piece as a more traditional opera: a fully staged narrative with a set, costumes and even "a ballet in the middle." His "operatic" contributions since then have been anything but traditional. Opera, by his estimation, is anything where the music "creates a window into the emotional life of a character."

That's not to say he isn’t a great fan of tradition. In fact, when he was in Latvia, he attended performances of the Latvia National Opera for an entire week seeing long-established productions which were still influenced by the Soviet music education system; the highest of standards, but the opposite of innovative. "I just relaxed and enjoyed it," he remembers, "no one was trying to shock us."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1676255914/media/2023/02/davidlang_peterserling_n4favf.jpg){{% /md %}}

<figcaption>Composer David Lang. Photo: Peter Serling.</figcaption>  
</figure>

He has seen plenty of unusual approaches to works from the past but, as he explains: "People are trying to innovate by changing the way we look at old stories. It's so much easier to innovate by finding new composers and inviting more and more compositional voices." He applauds the Met's announced determination to find such voices.

But as much as Mr. Lang experiments – and he is constantly experimenting – he is a bit of a traditionalist in the sense that he continues to defy the atonal modernism that has gripped serious music for more than half-a-century, and seems to have an unlimited capacity to create original melody and harmony. When asked why it is that young opera composers assiduously avoid such aural pleasures, he replied "It's about what they’ve been exposed to…they write without knowing anything about theatre." Mr. Lang has helped reverse this course a little as a teacher at Yale, inspiring students such as Missy Mazzoli (_Breaking the Waves_, _Proving Up_) and Kevin Puts (_Silent Night_), who aren't afraid of euphonia.

By his own estimation, Mr. Lang has had to "unlearn lessons" from his own modernist teachers.

That's not to say that Mr. Lang hasn’t produced pieces that are essentially recitative. His opera _anatomy theatre_ (2016) is mostly spoken word with a heart-breaking song (appropriately) entitled "my heart" as the climax, and _the loser_ (staged at BAM in 2016) is one long sung-thru monologue for a baritone voice.  In an interesting twist, all the text in _composition as explanation_ (2020), is spoken by the musicians. Mr. Lang had the musicians take some theatre, diction and acting classes to prepare for their roles.

> Mr. Lang likes the idea of leaving "unanswered questions" that are answered with each new production, similar to his _little match girl passion_, which has been presented in a variety of ways over the years, sometimes simply as a concert.

But it's two of Mr. Lang’s most recent operas, _note to a friend_ ([premiered this year](/note-to-a-friend-matters-of-life-and-death/)) and _prisoner of the state_ (soon to be revived in multiple European cities) which prove to be theatrical mini masterpieces (mini only in the sense that they both only run about an hour.)  Mr. Lang hates intermissions and says, "it is better to have an intense hour that doesn't let up than two hours with a lull in the middle." _note to a friend_ and _prisoner of the state_ represent his strongest storytelling to date with linear plots and character arcs, spotlighted, of course, by Mr. Lang’s memorable music. Is this an artistic evolution of sorts? Not really, Mr. Lang, reports. It’s more an evolution of a career. "As you get older and more established," he says, "people start to let you do what you want to do, such as my crackpot theatre ideas. As you get older, you're more concerned about getting things done before shuffling off this mortal coil; art that isn't going to get made if I don't do it."

You would expect nothing less than a quote from Shakespeare since Mr. Lang has been a theatre lover since his college days. In fact, he changed his major from chemistry and pre-med (after two years) to medieval studies and then theatre. Mr. Lang was then at Stanford and planned to become a playwright but his life changed after taking an undergraduate course in composition taught by visiting composer-musicologist Martin Jenni. (Mr. Lang followed Mr. Jenni into grad school.) After college, music and stage almost immediately blended in his life as he became the composer-in-residence at the venerable American Conservatory Theater (ACT) in San Francisco. (Mr. Lang and his wife, the performance artist Suzanne Bocanegra, continue to be avid theatre-goers and even built a 40-seat theatre in their house for rehearsals and private stagings.)

_prisoner of the state_ is a stripped-down version of Beethoven’s _Fidelio_, with a text by Mr. Lang himself, who removed all the subplots. "Beethoven's emotional trajectory is incredibly erratic. That's not an emotional life I want. I like to remain in more or less one state," he says, explaining his decision to focus on four main characters. A powerful and timely story about a political prisoner, there is a slight homage to Beethoven's original in the big orchestrations built on a foundation of tympani. And there are some recognizable conventions here: soprano and basso duets, baritone and tenor arias and choruses. Unconventional, however, are the moving and highly original sounds by Mr. Lang. A highlight is the opening "I was a woman," the haunting soprano aria sung by the "Lenore" character as she laments her disguise as a man, and some thrilling harmonies by the all-male chorus of jailed convicts. (Mr. Lang is looking forward to attending the numerous upcoming productions of the piece where he is happy to say that he doesn't have to do anything except "show up for the performances and the parties.")

> "Music," he explains, "is a good place to explore what you’re curious about that can’t be proved."

Mr. Lang's most recent opera, _note to a friend_ ([reviewed here 1/13/23](/note-to-a-friend-matters-of-life-and-death/)) is an adaptation of a story by Japanese writer Ryunosuke Akutagawa (_Rashomon_). Mr. Lang wrote both the music and libretto, but he left the staging to 89-year-old directing legend Yoshi Oida, who brought the piece to life with exquisite staging, lighting and dance-like movement (which he created with singer Theo Bleckmann, who also starred in the monodrama.) Though it was a fully-realized evening, we may never see it staged this way again. Mr. Lang has written the opera without any instructions at all in this area and the future will be open to the background and imagination of whatever theatre artist takes it on. (Just for the record, this reviewer thought that this interpretation was awfully good, and hopes that it has a future life.) Mr. Lang likes the idea of leaving "unanswered questions" that are answered with each new production, similar to his _little match girl passion_, which has been presented in a variety of ways over the years, sometimes simply as a concert.

_note to a friend_ shines a light on a dark subject – suicide – which in this case, is suicide as an intellectual rather than spur-of-the-moment choice. Through eight arias, the lone singer explains how he has come to this decision and as noted in the review, "the music is tuned viscerally at exactly the right moments to complement the text and vice-versa. The result is both cerebral and emotional." Mr. Lang uses one of his favorite tools: repetition, not musically like Philip Glass (Mr. Lang was once a copyist for Mr. Glass), but in the text which is repeated while the musical line subtly or dramatically changes. "Repetition is really useful," he says. "In singing, the audience may miss something if you only say it once, and then when you change and add things, people notice."

Mr. Lang also returns to one of his favorite themes – not just death, but _the exact moment of death_, which he has explored in a number of his operas, and in his song cycle _death speaks_ (2012). "Music," he explains, "is a good place to explore what you’re curious about that can’t be proved." To him, death is one such unexplained mystery as is music itself.  Despite all his accomplishments, he feels that "it's a mystery how music conveys something."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1676255944/media/2023/02/DavidLang_screamo_czgdc3.jpg){{% /md %}}

<figcaption>Composer David Lang. Photo: Peter Serling.</figcaption>  
</figure>

Although he has written a breathtaking number of compositions, if the past is prologue for Mr. Lang, we can anticipate much more. In addition to an untold number of works-in-progress, he is currently collaborating with poet Anne Carson on an opera based on another story by Akutagawa. He is even writing something for the musical theatre stage and anticipates writing more film scores, which he does every other year or so. For the film _Youth_ (2015), he was nominated for an Oscar and won the Italian Oscar (The David di Donatello award) for both the score and the soul-stirring soprano aria "simple song #3."

Lucky for us, whatever is next, one thing is certain - Mr. Lang will continue making his mark writing for his favorite instrument: the human voice.