+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-08T20:17:00-04:00"
lastmod = "2017-08-10T09:15:00-04:00"
preamble = "On the exciting line-up for this year's [O17 Festival](https://www.operaphila.org/festival/) is the world premiere of [Opera Philadelphia](/scene/companies/opera-philadelphia/)'s Composer in Residence David Hertzberg's [*The Wake World*](https://www.operaphila.org/whats-on/on-stage-2017-2018/the-wake-world/), **September 18-25**. With director R.B. Schlather, Hertzberg's work is designed to give audiences a one-of-a-kind experience of the galleries of The Barnes Foundation, focusing on the fascinating lives of Dr. Albert C. Barnes (1872-1951) and Aleister Crowley (1875-1947).\n\nHertzberg spoke with us about his unique new work, and the \"beyond rad\" experience of writing an opera to feature the Opera Philadelphia Chorus."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502238171140/2017-08-09---Wake-World-square.jpg.jpg"
primary_image_credit = "The Light Court, Barnes Foundation. © Tom Crane & Benjamin Riley, 2012."
publishDate = "2017-08-10T09:15:00-04:00"
related_articles = ["articles/an-organic-integration-the-wake-world.md","articles/feminist-truths-the-mother-of-us-all.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/david-hertzberg.md"]
short_description = "&quot;I hope people enjoy the show (!), maybe even get carried away, and that afterwards they experience the collection, and maybe even opera, or dare I say, art in general, with fresh ears and eyes.&quot;"
slug = "david-hertzbergs-the-wake-world-a-strange-and-sexy-synergy"
title = "David Hertzberg&#039;s The Wake World: &quot;A strange and sexy synergy.&quot;"
+++

## How do the eccentricities of Barnes and Crowley intersect in *The Wake World*?

While both Barnes' and Crowley's biographies paint vivid pictures of two world-class eccentrics (Barnes a cantankerous and avidly anti-establishment scientist, polemicist, and uber-wealthy aesthete who amassed one of the most miraculous private art collections in history and Crowley a fiercely prolific, mountain-climbing, death-defying mystic and libertine), where I felt there existed a strange and sexy synergy between these two figures was in the strikingly similar eccentricities of their creative visions, and the wild, orgiastic, and I think, beautiful chaos that they both managed to express.

If you've ever had the chance to go to the Barnes or look at pictures, you will likely be totally mystified and awestruck by the presentation of the work. The walls of the small interconnected galleries that comprise the collection are festooned almost floor to ceiling with spellbinding art, the arrangements of which are often disorientingly bizarre, and interspersed with cryptic pieces of metalwork that feel to me like inscrutable hieroglyphs from another planet. Barnes created these wonderfully whimsical "ensembles" (as he called them) because he believed that by looking at art arranged in this way, abstracted from genre, media, chronology, and even authorship, one could learn about the essential formal principles (line, color, form) that govern them all, and in turn learn about ones own perception, and about oneself.

In a curious kind of way, I felt that Crowley's work in the seemingly distant worlds of magic (or Magick, as he spelled it) and mysticism - correlating and amalgamating mystical symbols from across time, across different mythic and religions traditions, creating lexicons where colors, numbers, fragrances, and astrological associations dissolve into otherwise indescribable but incredibly precise feelings - seemed like such a clear literary parallel to what Barnes was doing with his Cézannes and pietàs. In dreaming up *The Wake World*, I wanted to create a musical and dramatic journey that would explode this shared quality, and hopefully, illuminate and transform the experience of the collection and the space.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502241382793/2017-08-09---Hertzberg-Schlather.jpg.jpg)
<figcaption>Composer David Hertzberg (left) and director R.B. Schlather. Photo: Dominic M. Mercier.</figcaption>
</figure>

## What kind of musical aesthetic have you imagined for this story?

I think the aesthetic universe of *The Wake World* grew out of a combination of the (for me!) deliciously strange subject matter and story, and the peculiar and particular ensemble that it was realized for. When Opera Philadelphia approached me to write an opera that somehow responded to the mind-bogglingly sublime Barnes collection (an idea that I was stoked about, to say the least), it came with the suggestion that the work somehow feature their (fabulous, fabulous - more on this shortly) chorus. I was intrigued and excited by this creative challenge (not least because I couldn’t really think of a canonical precedent for this kind of thing), and the idea was formative from the earliest stages of the opera's conception.

The result is, I think/hope, quite *sui generis*. The chorus is an omnipresent force in the musical drama: together with the five-person instrumental ensemble, they act as the orchestra, spinning the work's musical through-line and singing in one way or another for most all of the opera. As a unit, they also bridge the non-divide between orchestra and mise en scène by representing the Palace of Names, through which Lola (Maeve Höglund) and her Fairy Prince ([Rihab Chaieb](/spotlight-on-rihab-chaieb/)) journey. 

There are also several characters that are drawn from the chorus, who appear and reappear in different guises, as avatars of aspects or ideas of the palace that unravel throughout the course of the opera. Should be a wild ride!

If you’d like to get a sense of some of my music, here are two titles:
<ul class="nospace">
<li> [*Nympharum*, a cantata for high soprano and orchestra after Ezra Pound](https://soundcloud.com/davidhertzberg/nympharum) - for something more lascivious (Jennifer Zetlan is singing here);
<li>[*Spectre of the Spheres*, for orchestra](https://soundcloud.com/davidhertzberg/spectre-of-the-spheres) - for something more mystical.

</ul>

## Are there any unique challenges in creating a site-specific piece?

While there certainly are challenges in creating a site-specific piece (many of which we likely won't encounter until rehearsals begin!), I found in the various particulars of this project glorious and happily fated creative fodder. In addition to the considerations mentioned above (re: the responsive nature of the work and the suggestion to feature the chorus), there were certain things about the acoustical properties of the Barnes and the way the work would physically behave in the space that had to be thought through and worked out before any of the writing began. A lot of these decisions were made when R.B. Schlather (our oh-so-inspiring director and muse) and I visited the Barnes in September of last year, and these decisions really shaped everything, from the structure of the libretto to the details of orchestration. 

A question I often asked myself while trying to dream this thing into existence was, "How can I make this feel like an organic activation of the space/collection?" and my intuition is that this is something we will be continuing to ask ourselves as this wacky febrile dream comes to life in production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502241283939/2017-08-09---ensemble-view-room-1-north-wall-philadelphia-2012-photo-2017-the-barnes-foundation.jpg.jpg)
<figcaption>Ensemble view, Room 1, north wall. Photo: © 2017 The Barnes Foundation.</figcaption>
</figure>

## What have been the challenges and rewards of writing specifically for the Opera Philadelphia Chorus?

Working with the Opera Philadelphia Chorus has been one of the most rewarding musical experiences ever - and they are so beyond rad, as musicians and as people. While I was super excited by Opera Philadelphia's suggestion to feature the chorus, I was also wary of my musical idiom being too chromatic, and the exuberant histrionics I was imagining being too taxing for chorus (especially considering the duration of the work and lack of precedent). 

But the workshop process was totally affirming and thrilling, thanks to the expertise and choral wizardry of our wonderful conductor Elizabeth Braden, and to the ensemble’s epically intrepid appetite for expressive risk-taking. In addition to being great sports and sharp musicians, they are also all fab soloists in their own right, and there is a full-blooded quality to their singing that I find electrifying. And there will be some ravishing, swash-buckling solos from George Sommerville, John Miles, Jessica Beebe, Jim Gwathney, Rebecca Myers, Veronica Chapman-Smith, and Joanna Gates.

## What do you hope audiences will take away from these world premiere performances?

I hope people enjoy the show (!), maybe even get carried away, and that afterwards they experience the collection, and maybe even opera, or dare I say, art in general, with fresh ears and eyes.

>*The Wake World* runs September 18-25 at Philadelphia's Barnes Foundation. For full details and ticket information, [click here.](https://www.operaphila.org/whats-on/on-stage-2017-2018/the-wake-world/)
