+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-10-09T14:32:00-04:00"
lastmod = "2015-10-13T09:13:00-04:00"
preamble = "Canadian countertenor [Daniel Cabena](/scene/people/daniel-cabena/) will soon head to Vancouver to collaborate with the British Columbia-based [Turning Point Ensemble](http://turningpointensemble.ca/about/history/), and singers Zorana Sadiq and Alexander Dobson on Jürgen Simpson's new opera, [*air india [redacted]*](http://turningpointensemble.ca/tpe-concerts/air-india-redacted/). Presented November 6-11th by TPE and Simon Fraser University Woodward's Cultural Programs, *air india [redacted]* is an operatic telling of the bombing of Air India flight 182 in June, 1985; 329 people, most Canadians, were killed in the bombing, and it's a story that is \"under-represented in our national psyche\". \n\nDaniel Cabena is a wonderfully thoughtful artist; I asked him about his unique vocal Fach, splitting his time between old music and new music, and his \"ardent hope that the experience of hearing *Air India [redacted]* will be a healing one.\" For details and tickets, follow the box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444573044739/Daniel_Cabena_Headshot_2015_5x7Square.jpg.jpg"
primary_image_credit = "Photo: Veronika Roux"
publishDate = "2015-10-13T09:04:00-04:00"
related_people = ["scene/people/daniel-cabena.md"]
short_description = "Canadian countertenor Daniel Cabena will soon head to Vancouver to collaborate with the British Columbia-based Turning Point Ensemble, and singers Zorana Sadiq and Alexander Dobson on Jürgen Simpson&#039;s new opera, air india [redacted]. Presented November 6-11th by TPE and Simon Fraser University Woodward&#039;s Cultural Programs, air india [redacted] is an operatic telling of the bombing of Air India flight 182 in June, 1985."
slug = "daniel-cabena-on-air-india-redacted"
title = "Daniel Cabena on air india [redacted]"
+++

### 1. Can you tell us a bit about your role in *air india [redacted]*?

It's difficult to speak of my "role" in *air india [redacted]* because the distribution of roles in the work is a bit fluid. There are times in which my voice is that of a sort of narrator, a figure who leads the audience through the experience of the piece and sets out some of the work's themes and principles. That narrative voice could perhaps also be seen as the voice of the poet. But there are other moments in the piece during which I take on different roles (or during which one or both of the other singers share with me that narrative responsibility). The 'voice,' in other words, is fluid. And, besides the occasional narrative mode, there are also didactic moments as well as as lyrical and elegiac ones, in which I take on the role of someone who observed, in one instance, the legal proceedings that were undertaken lengthily after the terrible events of June 23rd, 1985.

### 2. Is there any particular significance to your character being a countertenor voice?

I think it is significant that the principal narrative voice has been written for a countertenor. Jürgen Simpson, the composer, could certainly speak more fully to that point; but I'll take the liberty of making at least a couple of observations. For one, I think the lines that I sing in an objective mode, the ones that speak directly to the audience, commenting on the action, have a real authority. And it strikes me as uniquely affecting to have such morally important moments curated in the more ambiguous, less traditionally authoritative tone of a countertenor. Maybe this softens the edges of the thing; or maybe it sharpens them: I'm not sure. But it's strong and touching.

### 3. How does it feel to work on an opera that lives in a world of (fairly) current events, as opposed to more traditional opera-isms like mythology and history?

This question is an increasingly important one to me. Since moving home to Canada, after spending a few years in Europe, working almost exclusively within the early music scene, I've had the honour and the pleasure to spend most of my time singing contemporary works. What sometimes has troubled me in the course of preparing and performing early music is what I've come to call a "relevancy gap," a gulf between the audience's (not to mention the performers') frame of reference and that of the human beings by and for whom those works were originally written. One can span that distance in a variety of ways, through education and careful curation of works, or by re-imagining, creating new and newly revealing contexts in which for them to be experienced. Those are wonderful and enriching processes; and they are a big part of what I wish to do.

But, in contemporary works, there tends simply to be no "relevancy gap," no distance between the concerns or cultural reference of the audience and those of the composers, librettists and performers. Contemporary works on contemporary themes have the potential for immediacy, and they can provide unfiltered engagement with the 'material,' the concerns of our day. I simply love that; and it's an honour to be involved in it.

I could say a couple of other things, too, if I may. One is that it's easy to forget that, previous to the 20th Century, the vast majority of music performed was 'contemporary music.' And, just as writers often write with a specific audience in mind, composers of the past created musical works for what we might call their own 'target audience.' Handel's audiences at the King's Theatre knew the tales (mythological, historical, biblical) upon which his operas were based; and he knew that he could immediately engage them in a retelling of those tales, knew that those stories would be relevant to their education and experience, part of the quotidian language of their culture. But those stories are no longer "ours" in quite the same way as once they were; we read them now, one might say, "as through a glass, darkly." With contemporary music, the engagement can be, I feel, "face to face." And that's how I wish to communicate.

Nor is that to say, I trust, that earlier repertoires are by nature foreign to us; but I do feel that we must reclaim them for our time, retell those tales, re-appropriate the material. For, I think most of us would agree that the themes are universal. At the same time, I absolutely don't feel that earlier works need to justify themselves. They are simply wonderful, a - to borrow a phrase from Wade Davis - "flash of the human spirit"; and I believe that the only advocacy that they require of us is that we frankly and passionately engage with them and claim them as our own.

### 4.  How does the countertenor voice fit into new opera, in your experience? What kind of characters are written for your voice type?

And your next question flows quite naturally from that topic, in the sense that contemporary works are written for contemporary performers. Handel wrote for his singers. So did Puccini. So does Jürgen Simpson, the composer of this wonderful work, *air india [redacted]*. It's a unique pleasure to work directly with a composer and have her or him fashion a role to fit one's one voice; and to sing something that's been inspired by the tonal qualities unique to one's own voice is something very special.

I have a particular interest in the process by which a piece of music is tailored to a voice, because I have a particular interest in tailoring. And I think that, just as every person should have a relationship with a tailor or seamstress, should engage in that fascinating idenitity-discussion in cloth, every singer should have a relationship with a composer, better yet, many!

As to what kinds of new opera roles are written for the countertenor voice, there are all kinds; and, happily, there are new roles appearing every year. Some of those roles follow the tradition of Britten's Oberon, a dark, mysterious, unsettling sort of character. Some of the power of that role, which was written for Alfred Deller, may initially have originated in sexual ambiguity, which the countertenor voice used to be seen to evoke. I think that's changing and that the countertenor Fach has come to take on a much wider range of dramatic possibilities, from the heroic to the villainous. There's also now an embarrassment of riches in the countertenor world - lots of countertenors and lots of different kinds thereof (for, which our Fach there are lots of different Fâcher!).

### 5. *air india [redacted]* is described as a "sensory experience” that "explores issues of silence and longing.” What do you think listeners will get out of hearing this piece?

I think that *air india [redacted]* will be a powerful and transformative experience for the audience, just as it already has been for those of us who participated in the summer workshop rehearsals, during the course of which we had the privilege to speak at length with Renée Sarojini Saklikar, the poet of whose engaging and hauntingly beautiful texts this work is a musical setting. That process of analysis was deeply enriching; and I believe that our performance will be, in turn, enriched by that conversation, which is, after all, a conversation with one who has herself been intimately connected not only with the tragic events of June 23rd 1985 but also with their reverberations, three decades of family trauma, legal machinations and, yes, silence and longing. Those two realities are essential to this work: they inform it, thematically, but they're also somehow integral to its structural. In the course of my own preparations, I have experienced a wide spectrum of emotions, from moral outrage to peaceful resignation, and all kinds of subtle, discreet, momentary joys and sorrows.

None of this describes the piece with any clarity; and maybe it's all by way of saying that I don't know exactly what the audience will take away from the piece, but I know that the experience will be part of an important conversation. And it is my ardent hope that the experience of hearing *air india [redacted]* will be a healing one.
