+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-03-28T16:38:00+01:00"
lastmod = "2017-03-30T23:13:00+01:00"
preamble = "*The Long Walk*, the new opera by composer Jeremy Howard Beck and librettist Stephanie Fleischmann, had its world premiere in 2015 at Opera Saratoga. The work is based on the book of the same name by [Brian Castner](https://briancastner.com/), Iraq veteran and member of an Explosive Ornance Disposal unit; *The Long Walk* is a personal account of Castner's return home, and his struggle with reintegrating himself into the lives of his family while battling with what he calls \"the Crazy\".\n\nBaritone [Daniel Belcher](/scene/people/daniel-belcher/) returns to the role of Brian in [Utah Opera's upcoming production of *The Long Walk*](http://www.utahopera.org/16-17-season/the-long-walk), **March 31 and April 1** at Wagner Center in Salt Lake City. He spoke about what he calls \"a very special and visceral piece of new music theatre\", and his real-life relationship with Castner."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490824057484/2017-03-30---Long-Walk-Square.jpg.jpg"
primary_image_credit = "Daniel Belcher and Megan Marino in The Long Walk. Photo: Utah Opera/Addie Salazar"
publishDate = "2017-03-30T09:51:00+01:00"
related_articles = ["articles/talking-with-singers-christian-bowers.md"]
related_companies = ["scene/companies/utah-opera.md"]
related_people = ["scene/people/daniel-belcher.md"]
short_description = "&quot;The best part is getting to know the man very well over the last four years. When I first met Brian in New York, I was very intimidated and, honestly, worried that he would think, &#039;Who is this guy to play me?&#039; It was quite the opposite; he opened his arms, said, &#039;Opera Brian!&#039; and gave me a hug. He has been nothing but supportive and in fact, over the years we have become very good friends.&quot;"
slug = "daniel-belcher-returns-to-the-long-walk"
title = "Daniel Belcher returns to The Long Walk"
+++

## What about Brian's story makes it work in an operatic setting?

I believe the reason we are drawn to the music theatre is that when ideas or expression become so big, we have to sing it instead of speak it.  Brian's story is extraordinary and his human and familial experiences are extraordinary.  Thus, when I am experiencing his heightened "crazy", I have to sing. Jeremy [Howard Beck] and Stephanie [Fleischmann] have lovingly crafted a very special and visceral piece of new music theatre.  In many ways, think of a film without its score: What would *Star Wars* be without John Williams?  Music truly heightens the expressivity of the storytelling.
 
## Was there anything about psychological trauma, or men and women who serve, that you learned about in preparing the role?

I do have two cousins who returned from roles in Iraq and Afghanistan with PTSD.  In all honesty, I spoke very briefly with them.  This is because Brian has Blast-Induced Traumatic Brain Injury (bTBI), which is not PTSD.  What I learned was from Brian's book and a little from Brian himself.  

In researching a role, first and foremost, I have to know what the librettist and the composer want.  I can have lots of background information, but all I have at the end of the day are the words the librettist wants me to say and the interpretation of those words via the melodic vocal line.  Brian, from the very start, has been a supportive, invaluable partner.  I have not served in the military, I had never held a gun (besides a BB gun in Scouts).  So, my job as an actor — and singer — is to make the audience feel the story, not necessarily me.
 
## What are the unique challenges and positives in playing a real, living person? 

The best part is getting to know the man very well over the last four years.  When I first met Brian in New York, I was very intimidated and, honestly, worried that he would think, "Who is this guy to play me?"  It was quite the opposite; he opened his arms, said, "Opera Brian!" and gave me a hug.  He has been nothing but supportive and in fact, over the years we have become very good friends.  I have visited their house in Buffalo, played games with the kids, had barbecues, went to Royals-Blue Jays playoff games, and had innumerable discussions on life over a couple beers.  He is as generous with his story in life as he was in his book.  He truly is an open page.  My job is to tell his story as honestly, heart-felt, open, and expressively as possible.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490824107758/2017-03-30---Long-Walk-2.jpg.jpg)
<figcaption>Daniel Belcher in *The Long Walk*. Photo: Utah Opera/Addie Salazar.</figcaption>
</figure>
 
## How would you discuss Brian's relationship with "the Crazy", and how is it reflected musically?

"The Crazy" is what Brian calls the dark place that takes him back to flashbacks of his time at war.  It can overcome him at any moment.  Over the years, Brian found running, yoga, and therapy to help him.  There are things that will never come back to Brian because of bTBI.  Mainly, his memories - long-term - memories are gone.  The Crazy is best represented as rather angular music.  "Rather angular" is kind of an understatement.  The melodic line becomes more jagged, the rhythms are heightened, the text is abrupt and flying; it is quite overwhelming.  And it can come on in the blink of an eye.  Jeremy has navigated this terrain beautifully.  There are a couple scenes, which to audiences may seem benign.  One is a dinner scene where the kids are fighting over the salt-shaker and one doesn't want to eat his carrots.  A warning from [Brian's wife] Jessie that she's "going to count to ten" triggers a countdown flashback as his troops storm the room.  It is rather brilliant.
 
## What do you look forward to as you reprise *The Long Walk*?  Have things changed for you in the role?

I am thrilled to be a part of only the second series of performances of this spectacular piece of music theatre.  This is a story that I have lived with for over four years.  We knew from the start this was a special and important piece that our opera companies should be presenting.  We are in this wonderful period of new composition and, more so, in exploring stories that reflect our society now.  

This opera takes place in 2010 (with flashbacks), so it is a living, breathing entity.  The story we are telling could be happening on your street, in your cul-de-sac, with a co-worker, with the family or friends of your children, with members of your church, etc.  That Utah Opera is only the second presenter to perform this work, reflects that it is a leader both regionally and nationally in encouraging these stories of now.  Utah Opera has become an operatic home for me, as this is my seventh role here, and I am returning next season.  I could not be more proud to be a part of something truly "important" here and I hope the public will embrace it as well.  The work will continue on to the Pittsburgh Opera next season and I know of several companies that are coming here to see, hear, and witness our performances.  I sincerely think there is a great life ahead for this opera.

>Utah Opera presents The Long Walk, March 31 and April 1, 7:30pm, at the Wagner Performing Arts Center. For details and tickets, [click here.](http://www.utahopera.org/16-17-season/the-long-walk)
