+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-02-08T20:52:00-05:00"
lastmod = "2018-02-09T14:25:00-05:00"
preamble = "This Black History Month, star tenor [Lawrence Brownlee](/scene/people/lawrence-brownlee/) will sing the world premiere performances of *Cycles of My Being*, a new song cycle by composer Tyshawn Sorey and lyricist Terrance Hayes, co-commissioned by Opera Philadelphia, Carnegie Hall, and Lyric Opera of Chicago's Lyric Unlimited. Brownlee brings the work first to [Philadelphia (February 20)](https://www.operaphila.org/whats-on/events/recitals/2018/cycles-of-my-being/), to [Chicago (February 22)](https://www.lyricopera.org/cyclesofmybeing?gclid=EAIaIQobChMIjtKBoLSX2QIVzrXACh1UqgYFEAAYASAAEgLfHvD_BwE), and to [New York (April 24)](https://www.carnegiehall.org/Calendar/2018/04/24/LAWRENCE-BROWNLEE-MYRA-HUANG-0730PM).\n\nWe spoke with Brownlee about helping to create something with a \"lasting shelf life\", and about using his art as a platform for communication."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518129682849/sq---Lawrence-Brownlee%2C-credit-Shervin-Lainez-01.jpg.jpg"
primary_image_credit = "Photo: Shervin Lainez."
publishDate = "2018-02-08T20:52:00-05:00"
related_articles = ["articles/talking-with-singers-jorell-williams.md","articles/casp-commission-sokolovic.md"]
related_companies = ["scene/companies/opera-philadelphia.md","scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/lawrence-brownlee.md"]
short_description = "&quot;I hope that people will show a great appreciation for the work of this young composer, the work of the lyricist, and the work of the other musicians on stage, but also our commitment to telling this story. I hope it gives a new perspective, and really allows people to see into the psyche and mindset of a young educated black man in America.&quot;"
slug = "cycles-of-my-being-this-is-their-story"
title = "Cycles of My Being: &quot;This is their story.&quot;"
+++

## What can you tell us about *Cycles of My Being*? How have you been involved in its creation?
 
*Cycles of My Being* is meant to look into the experience of being a black man living in America today. I wanted to talk about the many subjects that are important to us, ask questions, and create a song cycle that is the story of so many different people. The people involved, the composer and the lyricist and I, wanted to bring all of our experiences together and create a lasting song cycle. Something that would have tremendous shelf life, that someone could pick up in years to come and feel like this is their story.
 
Over the years I've realized that people do respond to me and the things I have to say, so I wanted to use my art as a platform, and be able to say something meaningful. I knew I had a community that would support me and my talents, so I knew I could do this and really say something. My role in the creation of this project was having the initial desire and consulting with various collaborative partners and artistic organizations to help bring it to pass. Thankfully, these three wonderful organizations were in support of the project ([Opera Philadelphia](/scene/people/opera-philadelphia/), Carnegie Hall, and Lyric Unlimited: A Division of Lyric Opera of Chicago) and were a big part of this becoming a reality.
 
## What do you hope audiences will take away from your performances of the new song cycle?
 
I hope that people will show a great appreciation for the work of this young composer, the work of the lyricist, and the work of the other musicians on stage, but also our commitment to telling this story. I hope it gives a new perspective, and really allows people to see into the psyche and mindset of a young educated black man in America. It should enlighten people, but also it should give people an opportunity to experience a bit of what we go through.

### When companies are urged to program creative seasons and present works that reach 21st-century audiences, what role do you think singers have in opera's evolution?
 
I think singers have to be increasingly more involved with being available, being on the front lines, and being connected with the public. In the day of social media, where accessibility plays such an important role, I think that opera singers need to make themselves available and be a part of the outreach, the marketing, and the community involvement in a very direct way. I have done that with a lot of the places where I've performed, and I think it is an important part of moving the objectives of these companies forward in the 21st century.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518129891218/Lawrence-Brownlee%2C-credit-Shervin-Lainez-04.jpg.jpg)
<figcaption>Lawrence Brownlee, tenor. Photo: Shervin Lainez.</figcaption>
</figure>

## What do you know now about the singing career that you wish you knew 10 or even 20 years ago?

The singing career offers an incredible amount of wonderful things: opportunities to travel and experience new cultures, to meet new people, and to feel like a citizen of the world. But it also comes with a lot of drawbacks like being away from your family, and being forced, sadly, to miss a lot of things at home. 

There are also a lot of outside factors that can affect your performance, such as if you're ill, tired, or distracted by stuff going on at home. If I had known all that 10 or 20 years ago, I would still be pursuing this career, but I think I would have tried to better prepare myself for the obstacles, though I don't necessarily know what that means.

## If you could sing a role that's outside your voice type, which one would it be?
 
I would sing Scarpia from *Tosca*, or Mephistopheles in *Faust*.

>Cycles of My Being premieres in [Philadelphia](https://www.operaphila.org/whats-on/events/recitals/2018/cycles-of-my-being/) on February 20, [Chicago](https://www.lyricopera.org/cyclesofmybeing?gclid=EAIaIQobChMIjtKBoLSX2QIVzrXACh1UqgYFEAAYASAAEgLfHvD_BwE) on February 22, and [New York](https://www.carnegiehall.org/Calendar/2018/04/24/LAWRENCE-BROWNLEE-MYRA-HUANG-0730PM) on April 24. 
