+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-08-01T17:01:00-04:00"
lastmod = "2015-04-23T14:26:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429813563990/Black%20Box.jpg.jpg"
publishDate = "2014-08-01T17:01:00-04:00"
related_articles = ["articles/are-the-good-old-days-of-opera-really-gone.md","articles/idealism-questions-unions.md","articles/whats-on-at-the-met-201617.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
short_description = "Human curiosity should be to opera companies what human insecurity is to the beauty product industry. We all want to snoop, take behind-the-scenes tours, figure out how that magician created that cool illusion. Hell, even I often prefer to watch a show from backstage. It&#039;s special, and unique."
slug = "curiosity-and-the-met"
title = "Curiosity and the Met"
+++

The anticipation grows at the Metropolitan Opera; their negotiation period has been extended by 72hrs as of last night, in the hopes that the Met management and their union workers can do some math and share some hugs. I can't shake the feeling that the Met is hindered from making a respectful decision about the state of their company's books because of that pesky ego factor. The face of grandeur has been a long-standing staple at the Met, from the red-carpeted, Swarovsky-chandeliered lobby, to the very sights and sounds coming from the stage. It certainly is one-of-a-kind, that Met.

The concept of grandeur definitely appeals to the Met management, as well as to the steady audience members that return over multiple seasons, and even donate their cash to keeping it alive and "well". But considering that the Met, like almost all other North American opera companies, are seeking out a new, younger audience, they've made a fairly large oversight. Not everyone wants to do work for their entertainment. I'm not even talking about reading up on the complicated plots of *Le nozze di Figaro* or *Le comte d'Ory*. I'm talking about opera-goers who feel obligated to dress up, sit silently in their seat, and pay a good chunk of cash to do so. 

For many people, these things simply do not outweigh the value of the show they saw that night. It's just not fun. And perhaps plenty of those folk are just not that into opera. Fair. But so many more of them are definitely into live entertainment. I get the sense that plenty of Met management (and donors, let's be honest) feel that if the public is unwilling to see an opera in its original language (albeit performed&nbsp;by spectacular singers and players), in a dark theatre from a far distance, then the Met does not want that public's business. To put it in my most sarcastic way: those who don't want to wear uncomfortable pants for hours, furiously reading surtitles&nbsp;and stifling yawns from the darkness and plush seats, aren't cut out for the opera. What garbage. Opera wouldn't have gotten past Monteverdi if people had been forced to "enjoy" it *only à-la-Met*.

I'm not trying to say that the Met is outdated. It is what it is, and that's big, famous, and perhaps the best. I've personally had as many feasts of my eyes and ears as I have had squirming nights of out-of-tune singing and stage-by-numbers productions of *La bohème*. It's an experience, but it's not the best by default, at least not anymore.

I've written about similar #operaproblems before. I think that the reluctance towards performing an opera in a smaller theatre, perhaps in the audience's native language, comes from a misunderstanding of the general reception of a great piece of opera. I'm the first person to drool over the significance of Verdi's harmonic changes on specific Italian syllables, and friends of mine swoon like enraptured nerds over the Tristan chord. If you're *really* into Mozart, reading the scores of *accompagnato* recits are like eavesdropping on that character's therapy session. These things are awesome. But they will be missed by most. It's the job of the director, conductor, singers, players, etc., to show an audience what these devices all *mean*. 

When black box theatre became a thing in the 60s and 70s, it might have looked cheap and lame to theatre folks. It no longer has that connotation, and opera has already started to adopt the benefits of a black box version of the genre.&nbsp;In a piece about [Against the Grain Theatre](http://atg.schmopera.com/)'s *#UncleJohn*, [Stephen Hunt](http://www.calgaryherald.com/entertainment/festival-guide/Banff+transforms+into+opera+UncleJohn/10076789/story.html) at the *Calgary Herald* put it well: "If food can get slower (and better), if pop culture can shatter into a million different (interesting) microcultures, then Joel Ivany wants to know why can’t opera get smaller, without sacrificing any of its gorgeous sound and thunderous emotion?" 

It's a good question. Some of the most awestruck feedback I've gotten from people raving about opera singers has been after gigs that I considered "no big deal" in scale: cocktail parties, school tours, flashmobs, impromptu aria nights at restaurants with pianos in them. Singing really is something to admire, and we all agree that scaling down will never mean sacrificing great voices.

It's worth considering that watching live theatre at a large distance might not be much different from what those same audiences can get from a big-screen TV. We can watch the BBC Proms, catch the HD broadcasts from the Met, and cheer for Renée at the Superbowl without having to be physically there.&nbsp;A grand theatre with a large distance between audience and performer is almost on par in affect with these televised options. The spectacle that's left to offer (and was offered first, to be clear) is proximity. &nbsp;It satisfies what people really all have in common: curiosity.

Is she&nbsp;really making that sound with no microphone? Look at her breathe! She literally expands! Wow, look at that sweat. It must be so hard to do that!

The impression that great singers make in close quarters can't be replicated. Audience members can *see* the work, the skill that goes into a singer's craft. They can even see the glances a singer may give towards a conductor (be they panicked glances or not), giving them a first-hand look at how this art is pulled off.

Human curiosity should be to opera companies what human insecurity is to the beauty product industry. We all want to snoop, take behind-the-scenes tours, figure out how that magician created that cool illusion. Hell, even I often prefer to watch a show from backstage. It's special, and unique. Paring down opera to a black box scale, or at least out of the expensive theatre may seem like a cheap Plan B, but you'll never lose an audience by placing them smack dab in the middle of the art. Why separate when you can combine? Why go broke over grandeur? And what a way to demand top-notch creativity from the artists? With no place to hide, you're left with honesty. Humans love that, even in their imaginary worlds.
