+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-12-13T16:17:00-05:00"
lastmod = "2018-12-13T16:17:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544735662054/sqGLASSHANDEL1.jpg.jpg"
primary_image_credit = "Anthony Roth Costanzo in Glass Handel. Photo: Dominic M. Mercier."
publishDate = "2018-12-13T16:17:00-05:00"
related_articles = ["articles/the-astonishing-product-glass-handel-at-o18.md"]
related_people = ["scene/people/anthony-roth-costanzo.md"]
short_description = "There was literally something for everyone who enjoys culture. Though many elements tied together, in the end it had the same effect as a large, complex mosaic - no surprise since it was the result of a collaboration between many:  Mr. Costanzo conceived the project in conjunction with the artistic directors of Visionaire and National Sawdust, which is known for its interdisciplinary productions."
slug = "counterculture"
title = "Counter/Culture"
+++

In the performance piece *Glass Handel*, renowned countertenor Anthony Roth Costanzo sang in the middle of a three-ring "circus" of art, dance and music. While his voice was the center of attention, there were a lot of other things to experience, depending on where you were sitting.  But that wasn't a problem, because of the ingenious "people movers" concept, where everyone in the audience was literally picked up in his or her chair and transported, via cart, to other locations during the approximately one-hour program.  

While the artists all commanded our attention, especially the riveting Mr. Costanzo, the small army of people movers were the most fascinating part of the evening (credit goes to Ryan McNamara who developed the idea for other works.) How it's done would prove to be a great math problem on a college entrance exam. Somehow 27 "ushers" moved 312 audience members (in 312 chairs) so that they could experience approximately one third of the show in three different locations. The seats were not assigned, so it didn’t matter where you started when the house lights went down - the people movers, who were as quiet as kuroko in a Kabuki play, somehow knew exactly what you'd experienced and for how long.  With only a gentle touch on the shoulder, they informed patrons that the cart was in place and that they should prepare to tip back and get rolling to somewhere else.

Neatly divided into thirds, the playing space (in this case, the sanctuary of the Cathedral of St. John the Divine,) consisted of a film screen, a concert stage with orchestra, and a dance platform.  Behind the concert stage was a plain white screen and behind that stood artist George Condo, who created an entire painting made of black watercolor. The canvas was lit from behind so we only saw the silhouette of the artist until the curtain call.  Also, Mr. Condo remarkably painted in reverse so that his work would not appear backwards to us from the front of the "canvas."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544735731059/GLASSHANDEL4.jpg.jpg)
<figcaption>Anthony Roth Costanzo in *Glass Handel*, costumed by Raf Simons for Calvin Klein. Photo: Dominic M. Mercier.</figcaption>
</figure>

There was literally something for everyone who enjoys culture. Though many elements tied together, in the end it had the same effect as a large, complex mosaic - no surprise since it was the result of a collaboration between many:  Mr. Costanzo conceived the project in conjunction with the artistic directors of Visionaire and National Sawdust, which is known for its interdisciplinary productions.

The evening itself was also divided neatly into thirds. Titled *Glass Handel* because Mr. Costanzo's arias alternated between those written by George Frideric Handel and those by Philip Glass, you heard three arias at each "station" before you were moved.  Every three arias, Mr. Costanzo wore a different costume from Raf Simons of Calvin Klein. Two of the costumes were hidden under the first and Mr. Costanzo revealed them with a surprise striptease.  He first appeared – or was rather swallowed up in - an enormous period scarlet gown (think Marie Antoinette) with equally scarlet high-heeled boots and long lavender gloves. After a masterful performance of the vocal calesthenics in Handel's "Rompo i lacci", Mr. Costanzo stripped off the gloves a la Gypsy Rose Lee. Then off came the red outer garment to reveal a simpler blue dress underneath with the words "Glass Handel" painted on it. He then launched into a beautiful rendition of Handel's famous "Lascia ch'io pianga." By then, this reporter was lucky enough to have been moved to the second row center and the tears in the singer’s eyes were visible as he sang:

Let me weep over<br>
my cruel fate,<br>
and let me sigh for<br>
liberty.<br>

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544735739761/GLASSHANDEL8.jpg.jpg)
<figcaption>Anthony Roth Costanzo in *Glass Handel*. Photo: Dominic M. Mercier.</figcaption>
</figure>
        	
Mr. Costanzo's final outfit – a simple black and white dress with paintings from Mr. Condo that mirrored the art being created on the screen behind the singer – was preceded by a powerful "Vivi tiranno." Here, the singer got to show off the lowest part of his countertenor range, in contrast to the rest of the programming which was in the mezzo-soprano stratosphere.

The Glass arias were much less impressive (because of the composition not the performance.)  One may wonder why they were chosen other than the fact that Mr. Glass is one of the few living composers who has written for the unique vocal instrument Mr. Costanzo possesses. The final Glass aria, "The Encounter", was the most effective.  There were no lyrics, only Mr. Costanzo's lush, legato notes. It was a deliberate moment of abstraction as the evening came to an end – the final film being shown was the least linear of all, and the somewhat abstract painting created by Mr. Condo's "shadow" was finished.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544735745996/GLASSHANDEL11.jpg.jpg)
<figcaption>Patricia Delgado and Anthony Roth Costanzo in *Glass Handel*. Photo: Dominic M. Mercier.</figcaption>
</figure>

This reporter did not see the first six of the nine films being presented since they were only visible to those in the film area. But all of the films, or rather music videos, (some created by famous names such as Tilda Swinton, Marisa Tomei and James Ivory) were timed precisely to the length of each aria and served as an homage to whatever Mr. Costanzo was singing. The film by AES+F depicted a dystopia where women of all shapes and ages have tied young men (who look like dancers) to various torture devices – this all inspired by Handel's opera *Armadigi di Gaula*, where the young hero finds himself in chains.

Justin Peck choreographed four modern dancers and conductor Eric Jacobson led a tremendous 34-piece orchestra.
