+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2021-09-13T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[Chicago Opera Theater's _Carmen_](https://chicagooperatheater.org/season/carmen) runs September 16 and 18, 2021."
preamble = "This week, Chicago Opera Theater drops its [in-concert production of _Carmen_](https://chicagooperatheater.org/season/carmen) - the one already earning proper buzz. Star American mezzo [Jamie Barton](/scene/people/jamie-barton/) takes on the title role; and instead of the usual tenorial tones of a leading man, Don José will be sung by even-bigger-star mezzo [Stephanie Blythe](/scene/people/stephanie-blythe/), in her drag alter ego, [Blythely Oratonio](https://abcnews.go.com/Entertainment/opera-star-stephanie-blythe-starting-performing-drag/story?id=68799896).\n\nWe had to know more. So, we asked Barton herself, and conductor and COT Music Director [Lidiya Yankovskaya](/scene/people/lidiya-yankovskaya/), about a gender-bent _Carmen_ and the problem with a patriarchy:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1631538919/media/2021/09/JamieBarton_BreeAnneClowdus_mgse7y.jpg"
primary_image_credit = "Bree Anne Clowdus."
related_articles = ["articles/talking-with-conductors-lidiya-yankovskaya.md", "articles/talking-with-singers-stephanie-blythe.md", "articles/talking-with-singers-jamie-barton.md"]
related_companies = ["scene/companies/chicago-opera-theater.md"]
related_people = ["scene/people/lidiya-yankovskaya.md", "scene/people/jamie-barton.md", "scene/people/stephanie-blythe.md"]
short_description = "\"Women who are independent, strong, and sexually liberated have a long history of receiving society's scorn because they refuse to break themselves in order to fit the approved mold. Carmen is many things, but a slutty, evil temptress? Nope.\""
slug = "radical-women-drag-don-jose-chicago-opera-theaters-carmen"
title = "Radical women & drag Don José: Chicago Opera Theater's Carmen"
youtube_url = ""

+++
## What does gender have to do with the story of Carmen?

**Jamie Barton**: "When it comes to the character of Carmen, I think it has a LOT to do with the story. I can only imagine how radical it must have been in 1875 to see an opera created about a woman who was so radically liberated that she would rather die than submit to the life of subservience. Even now, that's a radical stance in some ways..."

**Lidiya Yankovskaya**: "At the time that _Carmen_ was written, women had very few options and very few rights. The opera was unusual in that its title character is a working woman--one who lives separately from society's norms, valuing her freedom to live and love as she chooses above all else. Those are values that we now largely take for granted, but they were absolutely shocking at the time."

**Barton**: "I've heard many personal accounts of female friends who have chosen to stay in their dysfunctional (and sometimes abusive) relationships because the idea of being on their own was either untenable, or more frightening than just staying. The story is driven in large part by the fact that Carmen is 'free as the air,' and will not change that part of her personality for anyone. That radical point of view – in the face of toxic masculinity and the patriarchal notion of ownership over women – has held the fascination of audiences for almost 150 years."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1631539032/media/2021/09/LidiyaYankovskaya_KateLemmon_zsiotp.jpg){{% /md %}}

<figcaption>Conductor Lidiya Yankovskaya, Music Director of Chicago Opera Theater. Photo: Kate Lemmon.</figcaption>

</figure>

## How does this story change by having Blythely Oratonio rather than a traditional Don José?

**Barton**: "Having Blythely Oratonio in as Don José undoubtedly adds a new layer of psychology to the story. And I'm really happy to see this aspect being toyed with! Opera has always been a gender-bending art form, so why not open that door wider to welcome the world we live in now, which includes a variety of gender identities? I personally think it's really interesting to explore the fact that the patriarchy negatively affects us all, no matter our gender identity or whether we buy into the patriarchal narrative. 

**Yankovskaya**: "I don't think the story changes at all--it is still a story of a tumultuous relationship, with possessiveness and jealousy that (spoiler alert) leads to murder. However, I do find that each performer--no matter who they are--brings their own experience and perspective to the character. I am sure that as with anyone else singing the role, Stephanie's personal perspective will illuminate Don José in a unique way. Perhaps this casting will also help bring modern audiences closer to the story, as the social stigma encountered by Carmen and Don José has parallels to what queer couples face in contemporary American culture."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1631539001/media/2021/09/StephanieBlythe_BlythelyOratonio_iwafs4.jpg){{% /md %}}

<figcaption>Mezzo-soprano Stephanie Blythe as Blythely Oratonio.</figcaption>

</figure>

**Barton**: "The character of Don José is the operatic embodiment of what we would call the 'incel' mindset today – the idea that women should be available and happy to be owned was alive and well in a very real way when this opera was created, but it's something we still see today loud and clear. And this comes from a variety of sources – not just men."

## What is something about Carmen's character that you feel is often misunderstood?

**Yankovskaya**: "Highly problematic interpretations of the piece seen throughout the last 150 years have often painted Carmen as an evil seductress, who has taken advantage of an innocent young man and lured him into her trap. In actuality, Carmen is written as an idealistic, independent young girl, who makes it clear from the start that Don José has full choice of whether to join her, and that her own feelings may change at any moment. Whenever he seems wary of the circumstances, she offers him a way out--it is Don José who continually fails to move on, and who eventually destroys her through his own narcissism and jealousy."

**Barton**: "I've always hated the notion that Carmen is a slutty, evil temptress who ruins Don José's life, and I've seen that story told many times across many productions. And yet, it’s not surprising... women who are independent, strong, and sexually liberated have a long history of receiving society's scorn because they refuse to break themselves in order to fit the approved mold. Carmen is many things, but a slutty, evil temptress? Nope – that's a cop-out, and a story perpetuated for ages to keep women away from their own power."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1631539111/media/2021/09/MichaelSumuel_KristinHoebermann_qhhs3r.jpg){{% /md %}}

<figcaption>Bass-baritone Michael Sumuel, who sings Escamillo in Chicago Opera Theater's production of Carmen, 2021. Photo: Kristin Hoebermann.</figcaption>

</figure>

## Why is _Carmen_ such a staple of the canon?

**Yankovskaya**: "Carmen's story and musical writing are exceptionally flexible, and the opera has a history of being adopted to different cultures, traditions, voice types, and performance styles. We see real people on the stage interacting in believable ways, leaving room for different cultural archetypes to be imposed onto the characters. Bizet also writes in a way that allows delivery of the text to shine, again giving room to singer-actors and directors to shape the piece for their particular space and time. The vocal writing also leaves room for performances by different voice types--the role of Carmen alone has been sung by every type of singer imaginable, from contraltos to Callas."

**Barton**: "The combination of the story of a radically liberated woman and the infectious music that Bizet gave us created a piece that people just can't put down. Plus, that 'Habanera' is really catchy!"

**Yankovskaya**: "The orchestrations are lively and varied, giving us plenty of catchy tunes, but also sophistication, nuance, and complexity--something for every palate. The score itself was reshaped by Bizet and his contemporaries many times, leading to great choice and flexibility in performance practice, including different versions of musical numbers, the choice of dialogue versus recitatives, and easy opportunities to make cuts without losing the core of the storyline. Furthermore, the key themes--seeking freedom but being stopped by destiny, obsessive love and abuse, and a search for meaning through love--are timeless."

## What do you hope audiences will take away from Chicago Opera Theater's production?

**Barton**: "I'd love for this to be an inspiring return to live concerts for the people who haven't been in a theater since before the pandemic hit! I think we've got everything you need to put together an electric show, and COT has upped the ante with radical casting and storytelling. How perfectly fitting for such a radical character's story to tell, huh?"

**Yankovskaya**: "More than anything, I hope this will be an uplifting return to communal music-making! I hope that everyone who comes is able to soak in the exhilarating experience of hearing these world-class voices in the relatively intimate space of the Harris Theater. (I know I can't wait!) What better way to return from the pandemic than hearing one of the best-known operas of all time, in all its glory, but rethought and made more relevant for a modern-day context?"