+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2017-10-09T11:02:00-04:00"
lastmod = "2017-10-10T09:19:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507561059063/2017-10-09---Cross332-copy.jpg.jpg"
primary_image_credit = "Rod Gilfry (Walt Whitman) and Alexander Lewis (John) in Crossing, BAM, 2017. Photo: Richard Termine."
publishDate = "2017-10-10T09:19:00-04:00"
related_articles = ["articles/in-review-rocking-horse-winner.md","articles/tarrare-the-freak-i-just-want-to-be-full.md","articles/cautiously-aspirational-book-of-dreams.md","articles/fellow-travelers-is-luminous-in-chicago.md"]
related_companies = ["scene/companies/brooklyn-academy-of-music.md"]
related_people = ["scene/people/rod-gilfry.md","scene/people/alexander-lewis.md","scene/people/jennifer-zetlan.md"]
short_description = "But forgetting this ambiguous relationship for a moment: Crossing is an engaging opera, held together over its generous hour and forty-minute run time (no intermission, thank goodness!) by a cohesive score happily swollen with motivic unity. When a recording becomes available, audiophiles can look forward to listening on repeat like a Wagnerite, collecting and linking more motifs each time."
slug = "cosmic-grandeur-and-human-frailty-crossing"
title = "Cosmic grandeur and human frailty: Crossing"
+++

Now in its second major iteration, Matthew Aucoin's [*Crossing*](https://www.bam.org/opera/2017/crossing) has a chance to transcend the wunderkind fetishism that dominated its 2015 Boston premier. Written, composed and conducted by Aucoin and directed by Diana Paulus, *Crossing* (New York premier at BAM's Howard Gilman Opera House, Oct. 3-8) tells a fictional version of Walt Whitman's genesis story. Using "Memoranda During the War", a book collecting Whitman's notes during the civil war, as a starting point, the opera takes Whitman's essential experience helping wounded union soldiers and shows how it solidified his poetic identity. Though the real Whitman visited many hospitals and sat with many patients, the opera takes a small-scale approach, placing Whitman (played by baritone [Rod Gilfry](/scene/people/rod-gilfry/)) in an isolated make-shift hospital without medical staff. The cabin-like hospital is populated with nearly a dozen wounded union soldiers waiting out the war. Charismatic and empathetic, Whitman takes charge keeping order and maintaining moral.

Trouble begins when a rebel soldier in disguise named John (tenor [Alexander Lewis](/scene/people/alexander-lewis/)) limps into the hospital claiming to be an injured union fighter. He suckers Whitman into taking him in and treating his wounds, praying on the poet's desire to contribute to the war effort. When Freddie, an escaped Carolina slave turned union soldier (bass-baritone Davóne Tines) returns with news that the war rages on, John stirs the injured soldiers into a frenzy, convincing them that hope is futile because the war will never end. Whitman calms the group. As the soldiers return to their idle tasks, John asks Whitman to help with a letter, supposedly for his parents, but really for a confederate commander in Washington. He encodes the hospitals location in the letter, planning to guide the rebel army to the helpless shack. John wants to be annihilated alongside Whitman and the wounded soldiers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507561386076/2017-10-09---Cross226-copy.jpg.jpg)
<figcaption>Davóne Tines and Rod Gilfry in *Crossing*, BAM, 2017. Photo: Richard Termine.</figcaption>
</figure>

Act II begins. Late in the night, Whitman finds John awake. John draws out Whitman's insecurities and seduces him into bed. The next day, a messenger (soprano Jennifer Zetlan) relays the news that the war is over. Whitman approaches John to apologize for violating their healer-patient relationship. In a rage John privately shames Whitman for his homosexuality. Everyone leaves to return home. Whitman discovers John collapsed in the wilderness living out his final moments. John confesses his rebel allegiance. He describes how he loved life while marching with his comrades. Whitman confesses that he loves John. There's a final chorus, and the opera ends.

John is the story's unmistakable villain. He limps into the hospital undetected, immediately marked as an outsider. Gaunt with bagged eyes, he grins when he lies, and revels in the union soldiers' suffering. John resembles Dylan Roof, the young man responsible for the heinous Charleston massacre, in appearance and comportment. He is anti-social and dangerous. Spending time with Whitman and the soldiers, he nonetheless pursues his murder-suicide mission without remorse.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507561439392/2017-10-09---Cross069-copy.jpg.jpg)
<figcaption>Rod Gilfry and Alexander Lewis in *Crossing*, BAM, 2017. Photo: Richard Termine.</figcaption>
</figure>

Yet in John's final moments, Whitman confesses that he "never loved another / Till you". The nature of Whitman's love for the boy is hard to understand. John picks on Whitman, exploiting his insecurity. Both the real Whitman and this fictional version fear that communicating the multitudes of the civil war is impossible. John feeds Whitman's fear asserting that wastefulness of his endeavor. Through insults, he seduces Whitman. The relationship is one sided. Other than a tender hug in bed, John evinces no genuine affection for Whitman. He leverages Whitman's naïveté for his benefit. Could it be that Whitman finds appreciation for contradiction by falling for a manipulating, bigoted opportunist? The message here is hard to decipher.

But forgetting this ambiguous relationship for a moment: *Crossing* is an engaging opera, held together over its generous hour and forty-minute run time (no intermission, thank goodness!) by a cohesive score happily swollen with motivic unity. When a recording becomes available, audiophiles can look forward to listening on repeat like a Wagnerite, collecting and linking more motifs each time. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507561452796/2017-10-09---Cross266-copy.jpg.jpg)
<figcaption>The cast of *Crossing*, BAM, 2017. Photo: Richard Termine.</figcaption>
</figure>

The most memorable texture involves repeating, harmonically shifting polyrhythms in the strings complimented by fluttering arpeggiating lines in the winds. The effect is visual, like a whirlwind swiftly swirling fallen leaves skyward.

For the most part, the score avoids anachronism. Yes, there are hymn-like tunes and a faux-spiritual bookending Freddy's of his aria, but the bulk of the music sounds specific and original enough that it could belong to no other story. The orchestra churns and grinds in its low frequencies evoking the dull relentlessness of war. The score, executed expertly by the Grammy-nominated orchestra A Far Cry, balances cosmic grandeur with human frailty, allowing transcendence in the leaps and sostenutos of the vocal line. The sound world is both unified and expansive and will reward repeated listening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507561466631/2017-10-09---Cross256-copy.jpg.jpg)
<figcaption>Jennifer Zetland (centre) in *Crossing*, BAM, 2017. Photo: Richard Termine.</figcaption>
</figure>

As for the singers, Rod Gilfry as Whitman is musically and dramatically immaculate. As the experienced Whitman, he is professorial, upright, full of dignity, and immediately recognizable as the famous poet. Mr. Gilfry's dramatic journey as Whitman is deliberate yet subtle. His vulnerability over the course of the drama played like rays of light squeezing through thick clouds, so slowly as to be imperceptible, but finally focusing into sharply visible beams. As the war ended and the hospital set cleared, Mr. Gilfry walked upstage picking up and donning his signature hat, for a moment becoming Whitman incarnate.

Mr. Gilfry's superior vocalism never waned. The role requires a vast vocal range; the lower extremes must carry over a thick orchestral texture and the top must be triumphant one moment, tender the next. His falsetto was endless and sublime, blending and surpassing the tenor's upper range during the duet before John dies. A masterful performance from Mr. Gilfry.

As Freddy and John respectively, Mr. Tines and Mr. Lewis both have attention grabbing vocal timbres. Mr. Lewis' role demanded that the singer contend with relentless climactic surges. Ms. Zetlan as the clueless Messenger showed-off her crystalline top in a brief but refreshing appearance. She is the only female voice in the opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507561477739/2017-10-09---Cross280-copy.jpg.jpg)
<figcaption>Rod Gilfry and Alexander Lewis in *Crossing*, BAM, 2017. Photo: Richard Termine.</figcaption>
</figure>

The ensemble of men was outstanding. Harmonies were clear and the tone was unified and agreeable. Two tenors, Sean Christensen and Frank Kelley stood out. In a major choral set piece, the chorus remembers a moonlit rendezvous the night before going to war. Mr. Kelley, who plays a wheel chair-bound elder soldier, began the chorus with startling vocal purity. Mr. Christensen picked up the soloistic role in the middle section. His vocal approach so suited the moment, full of youth, relaxed but vibrant, brimming with a calm passion. With Mr. Christensen leading the way, the chorus bloomed into a transporting musical respite of nostalgic consonance. Dancers marginally aided the story telling with well executed choreography.

Tom Pye's set was tasteful and handsome. The wooden, cabin-like building of the hospital felt specific and clear, and with the help of rearranged beds midway through the piece, never grew tired. Tempered projections (by Finn Ross) and lighting (Jennifer Tipton) enhanced the story telling and sense of environment. The transition from the hospital to the desolate outside stunned the audience. The set flew up into the rafters revealing the ensemble in a line, singing a chorus to our eternally torn world. 
