+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2022-09-19T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1663629338/media/2022/09/sqWSP_CC-10_Kathy_Wittman_Ball_Square_Films_eamfjw.jpg"
primary_image_credit = "White Snake Projects' production of Cosmic Cowboy, 2022. Photo by Kathy Wittman / Ball Square Films."
related_articles = ["articles/star-trek-and-the-opera.md", "articles/opera-and-scifi-the-puritan-intersection.md"]
related_companies = []
related_people = []
short_description = "The score's harmonic language is relatively simple, but it is also quite full of little treasures like this, and I found myself enamoured by it by the end."
slug = "cosmic-cowboy-a-strong-premiere-despite-a-cursed-opening-night"
title = "Cosmic Cowboy a strong premiere, despite a cursed opening night"
youtube_url = ""

+++
In my time as a critic for Schmopera, I have to stress that I have seen a great deal of well-performed opera, where everything goes right and the piece just shines. Thus, I think it is all too easy to forget that the true test of an opera production lies in what happens when things go wrong during performance. After all, opera is a live performance medium, and in live performance there is always an edge of peril, where some things can go wrong at any moment.

Thus we turn to White Snake Project's [new sci-fi opera _Cosmic Cowboy_](https://www.whitesnakeprojects.org/projects/cosmic-cowboy/). Perhaps mirroring the scale of its story, _Cosmic Cowboy_ opted to present itself with a veritable treasure trove of technical wizardry to accompany its story, which takes Sumerian gods, references to terraforming Mars, comet probes, colonialism, and Gary Cooper, and mashes them all in a blender.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1663629825/media/2022/09/WSP_CC-1_Kathy_Wittman_Ball_Square_Films_dexbgp.jpg){{% /md %}}

<figcaption>White Snake Projects' production of Cosmic Cowboy, 2022. Photo by Kathy Wittman / Ball Square Films.</figcaption>  
</figure>

And yes, I say the treasure trove of wizardry, and I do mean it. There is, for instance, a moment where a dancer representing Tia, the daughter of Sumerian gods Tiamat and Apsa, dances with a robotic arm that is meant to be a probe. There were also a few CGI cutscenes that played (and were accompanied by live music from the orchestra) during the show's second half, to open and close it: these cutscenes also employed some digital lip syncing, where the CGI lip synced to the live performers. The opera also opened with a VR film that was accompanied by live performers, and I have to say that it is a strange experience to walk into the opera house and see a table full of Google Cardboards, and an even stranger one to fight your QR code reader to scan the QR code that actually links to the video that opens the performance. It was a story that was told through multiple mediums at once, and if everything were working as intended I imagine it would have been an amazing experience.

> This prompted me to ask "OK, so is this piece still worth it?"

Unfortunately, this production’s opening night was plagued with quite a few technical issues that ran throughout the entire performance. The CGI cutscene that opened the second half of the show showed some impressive lip syncing technology, but unfortunately the moments the singers actually sang were so fast that the CGI film actually sprang super far ahead of the music, which kind of broke what otherwise was a thrilling chase sequence. I also feel the CGI looked quite cheap, although this is somewhat more understandable considering that making it look better would've required a budget that most opera companies simply do not have. Further, the VR film at the beginning loaded at a low enough quality that I could not make heads or tails of some of the visuals, although I concede that I was watching the stream of this film on the 5G network and it possibly had connection issues as a result.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1663629905/media/2022/09/WSP_CC-4_Kathy_Wittman_Ball_Square_Films_q1axwk.jpg){{% /md %}}

<figcaption>White Snake Projects' production of Cosmic Cowboy, 2022. Photo by Kathy Wittman / Ball Square Films.</figcaption>  
</figure>

Ultimately, however, I cannot point at technical ambition as the root cause for these problems, for the technical difficulties presented here proved relatively minor compared to the problems that came up in the parts of opera-making that most opera goers would otherwise take for granted. For instance, there were multiple issues with the subtitles, ranging from subtitles being put in the wrong order and a strange subtitle glitch where multiple subtitles piled onto each other and formed an unreadable mass to an outright "blank" coming on the subtitle screen right at the very end. And for all the technical ambition involved in this production, it is almost comical that the thing that brought the show to a screeching halt–twice, no less!–was the orchestra's keyboard synthesizer, which decided to change settings of its own volition for seemingly no reason. I don't know how the dancing robot arm functioned perfectly but the synthesizer in the orchestra pit did not, but it is the best microcosm for the whole evening that the thing that went the most wrong was one of the least high-tech bits of its many moving parts.

> \[Hilaire's\] warm, sumptuous voice almost added more character to what was already a strong character.

I feel, ultimately, that the performance's issues can be summed up as a curse, and I feel this way because one of the biggest issues was not even confined to the actual performance itself: a water main broke on the street the theater is located on earlier in the day, which caused a traffic jam so bad the Emerson Paramount Theater made the decision to postpone the start of the performance for fifteen minutes to allow patrons enough time to arrive. I almost wonder if someone uttered the name of the Scottish Play backstage at some point, because the amount and source of the technical hiccups cannot be explained merely by ambition.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1663629918/media/2022/09/WSP_CC-5_Kathy_Wittman_Ball_Square_Films__1_ynb39e.jpg){{% /md %}}

<figcaption>White Snake Projects' production of Cosmic Cowboy, 2022. Photo by Kathy Wittman / Ball Square Films.</figcaption>  
</figure>

Fortunately, there is a silver lining: in perhaps what is a strange stroke of foresight, White Snake Projects adds in the program that, amidst all the technical wizardry, one cannot lose the fact they are telling a story. This prompted me to ask "OK, so is this piece still worth it?"

In my estimation, the technical issues actually proved their point, and because of that I can say that indeed, _Cosmic Cowboy_ as a piece is actually quite good! First, its story and libretto by Cerise Jacobs actually come together much better than one would expect. It essentially starts with Sumerian gods Tiamat and Apsa bearing the universe, and Tiamat bearing her lover (and son) Qingu's children in what is essentially a space palace, more or less following how Sumerian myth would have formed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1663629934/media/2022/09/WSP_CC-8_Kathy_Wittman_Ball_Square_Films_fokk1l.jpg){{% /md %}}

<figcaption>White Snake Projects' production of Cosmic Cowboy, 2022. Photo by Kathy Wittman / Ball Square Films.</figcaption>  
</figure>

Enter Marduk, who decides that order is the only way forward for everyone, which leads to him trying to kill everyone, including Tiamat and Qingu's daughter Tia. Tia's journey to eventually meet and fall in love with a space probe would seem improbable just from reading an abridged plot synopsis, but thanks in part to smart decisions on what characters singers should double and implying that Marduk is at least partly responsible for the course of human history that leads to the sci-fi setting of the show's second half, it at the very least makes sense in context. It also for the most part handles its themes very well: having Marduk be the voice of what is essentially Western imperialism, and furthermore framing that voice as a question of "order versus chaos" instead of "right versus wrong" allows the show to flesh this theme out more thoroughly, and in a way that feels integrated with the show. It also helps that, while the whole thing does feel quite silly and on the nose at first, the opera does unfold and reveal its layers to the audience in the way that all great big-idea sci-fi does.

> The score's harmonic language is relatively simple, but it is also quite full of little treasures.

And for another, the score by Elena Ruehr is also quite excellent. The libretto is actually quite fast-paced, so the score has to do a lot of the heavy lifting so the show's emotional beats land; by pretty much all accounts she succeeded at doing this. The score is rather full of riches, in that it manages to be both a good opera score and also fits the sound world of what one might expect of a good score for a sci-fi movie.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1663629946/media/2022/09/WSP_CC-14_Kathy_Wittman_Ball_Square_Films_nwv9f3.jpg){{% /md %}}

<figcaption>White Snake Projects' production of Cosmic Cowboy, 2022. Photo by Kathy Wittman / Ball Square Films.</figcaption>  
</figure>

I especially love the way the score treats Cooper the mining probe: the space probe is set overly robotically when he is first seen on-stage, but this is an over-roboticism the music throws out the window the second Tia shares her memories with it, and his music suddenly becomes much more lively and amorous than before. The score's harmonic language is relatively simple, but it is also quite full of little treasures like this, and I found myself enamoured by it by the end.

> The costume design was quite excellent, in that it pulled together various science-fiction influences from _Star Trek_ to Flash Gordon.

And for the most part, barring the tendency of most of the cast to rush well ahead of the orchestra, the singing was also quite good. The highlight of the evening was Carami Hilaire as Tiamat and the older Tia: she was easily the most in tune with everyone around her, and her warm, sumptuous voice almost added more character to what was already a strong character.

Daniel Moody was every bit her match as Quingu in the first half and then Cooper in the second half: his countertenor was smartly mechanical in some ways, but could switch to tender on a dime, which was no small feat considering how difficult his parts were. Lastly of major note was Tyler Putnam's Marduk. He imbued the character with the right amount of moral ambiguity for the role, while also doing excellently at presenting someone authoritative and strong enough.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1663629967/media/2022/09/WSP_CC-18_Kathy_Wittman_Ball_Square_Films_vxxux6.jpg){{% /md %}}

<figcaption>White Snake Projects' production of Cosmic Cowboy, 2022. Photo by Kathy Wittman / Ball Square Films.</figcaption>  
</figure>

Generally, the production also had a lot going for it as well: the costume design was quite excellent, in that it pulled together various science-fiction influences from _Star Trek_ to Flash Gordon and sort of created a very interesting aesthetic that was pleasing to look at. The projection mapping that doubled as set design also gave a really nice look to the whole production, and it was wonderful to see. The only real snag I could see in how the production was conceived was that I think the ending could have been staged a little more clearly: I had to read the synopsis to really make any sense of what happens when Tia manages to overcome Marduk's attempts to hunt her across the universe, but other than that the storytelling was generally clear and concise.

And yes, I say that even in a production riddled with technical difficulties. I am very sympathetic to the struggles of the production crew: I imagine that if all had gone according to plan, I would have been blown away, and the tone of this review would be quite different. And after all, it is only one performance: _Cosmic Cowboy_ had two other performances, and there is hope that they went off without snags, and others in this city were able to experience all it has to offer. It is still a crying shame that this performance was as cursed as it was, but even amidst the technical errors, I got the sense that it was all in service to a good story told with good music and good singing; the fact this came through at all given the circumstances is a testament to _Cosmic Cowboy_'s worth as an artistic piece.