+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-07-08T06:31:00+01:00"
lastmod = "2016-08-10T08:36:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470814473002/2016-08-10---Cosi.jpg.jpg"
publishDate = "2015-07-09T17:21:00+01:00"
related_articles = ["articles/atg-in-banff-2015.md","articles/meet-the-contestants-of-a-little-too-cozy.md","articles/familiar-exotic-a-brief-history-of-bellinis-norma.md","articles/summer-of-love-bampton-opera-presents-the-school-of-jealousy.md","articles/chauvinism-cynicism-great-singing-cos-fan-tutte.md","articles/stay-warm-with-opera-mariposas-tropical-cos-fan-tutte.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/the-banff-centre.md"]
related_people = ["scene/people/caitlin-wood.md","scene/people/shantelle-przybylo.md","scene/people/pascale-spinney.md","scene/people/brent-calis.md","scene/people/aaron-sheppard.md","scene/people/cairan-ryan.md","scene/people/joel-ivany.md","scene/people/christopher-mokrzewski.md"]
short_description = "The other day I was fortunate to hear Graham Forst speak about Così fan tutte. If Graham&#039;s last name sounds familiar, it&#039;s because his wife is the formidable mezzo-soprano Judith Forst; they&#039;re both gracing The Banff Centre with their presences, she to teach, and he to get our minds a-spinning."
slug = "cosi-fan-tutte-misogynist-unreasonable"
title = "Così fan tutte: misogynist, or just unreasonable?"
+++

The other day I was fortunate to hear [Graham Forst](https://www.sfu.ca/continuing-studies/instructors/e-h/graham-forst.html) speak about *Così fan tutte*. If Graham's last name sounds familiar, it's because his wife is the formidable mezzo-soprano [Judith Forst](http://music.cbc.ca/#!/artists/Judith-Forst); they're both gracing The Banff Centre with their presences, she to teach, and he to get our minds a-spinning.

Graham addressed the big point of debate around *Così*, and that's whether or not the opera is a misogynistic one. He brought up the point in history when Mozart and Da Ponte wrote *Così*, which between the end of the Age of Englightenment and the beginning of the Romantic period. The Englightenment brought the scientific method, moving away from superstitious or religiously-informed explanations for things like meteorology, astronomy, and physics. The Romantic era reminded people of things unexplainable; it wasn't a step backwards in our understanding of the world, but an acknowledgment of the things we didn't yet understand, like love, duty, nostalgia, and conflicting emotions.

Wise man that he is, Graham Forst didn't impress upon us an "answer" to the question of *Così*'s supposed misogyny. When you consider Mozart's Freemason-inspired take on the world (a mix of valuing fairness towards others and unnecessary cult-like elements), the questions about this opera focus more on what Mozart and Da Ponte were trying to say about how we should behave: reasonably, or romantically?

Are they saying that the couples in *Così* would have been able to avoid such messiness, had they exercised more reason in their lives? Perhaps if the men had thought *reasonably* about the fidelity of their girlfriends, and about the cost of such an experiment upon them, they could have maintained enough self-respect and self-security against Don Alfonso's suggestions that *"così fan tutte."*

On the other hand, Don Alfonso's scientific-method approach to the behaviour of creatures as volatile as humans might be the point of ridicule in *Così*. Plus, you could argue that Alfonso's entire experiment is faulty: he threw a huge variable into the pot by presenting the women with options that simply would not have existed without his meddling. Emotions, as we all know, are reactive to each other. When we feel rejected, we become angry, hurt, or spiteful; it doesn't matter if the rejection is false or not. When we're presented with attractive folks who offer everything we want, *plus they're not far, far away "at war"*, it's not fair to equate an interested, flattered woman with one who will commit infidelity.

Graham Forst alluded that Mozart and Da Ponte were saying what lots of post-Enlightenment, pre-Romantic folks were saying, that neither living 100% reasonably and 100% unreasonably (for lack of a better term) are wise. Moderation, that old chestnut, is better than any sort of ideology or -ism.

As a woman myself, it's easy for me to point the finger at the men in *Così* for behaving badly. If the genders were reversed, and the women had pulled the same trick on the men, we most likely would see the men cheat on their partners, without even a need for arias and duets droning on and on about their conflicted feelings about it.

If *Così* is misogynist, I think it's only in that the women were chosen as the experimentees, and the men as the (bad) scientists. There's that line of Despina's acknowledging the double standard, where she says something like, "The men are probably playing the if-it's-in-another-zip-code-it's-not-cheating game, so why shouldn't the women?" Good point, except it's couched in Despina's plan to facilitate Alfonso's trickery.

In Joel Ivany's *A Little Too Cozy*, much of the crazier bits of Da Ponte's libretto are salvaged by setting the story in the equally crazy world of blind-date game shows and reality TV. It solves the problem of baffling the audience with lame disguises and moving from disinterest to sexy duets in a matter of minutes, and hopefully allows listeners to think about some of the larger questions posed by the piece.

It's stuff like this that reinforces my theory that Mozart was a feminist, and that Da Ponte's big life (including a friendship with Casanova himself) probably included dealing with some crazy ladies.

I'm also thrilled that Open Space: Opera in the 21st Century brought Graham Forst back to Banff. Questions about reason and romance are much more interesting than questions of misogyny and chauvinism.
