+++
author = ["authors/blanche-isral.md"]
categories = "Editorial"
date = "2015-07-15T00:06:00-06:00"
lastmod = "2015-07-16T01:30:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436941356258/SulmonaConfetti.jpg.jpg"
primary_image_credit = "Sulmona, Italy, is known for its artistic confetti (or, tasty tasty sweets wrapped up to look like flowers)."
publishDate = "2015-07-15T13:22:00-06:00"
related_articles = ["articles/the-future-of-opera-is-indie.md"]
related_companies = ["scene/companies/cosi-centre-for-opera-studies-in-italy.md"]
related_people = ["scene/people/daevyd-pepper.md","scene/people/lyndsay-promane.md","scene/people/joel-ivany.md","scene/people/iain-macneil.md"]
short_description = "It&#039;s the final week of the Centre for Opera Studies in Italy (COSI), a month-long, comprehensive summer training program that immerses emerging opera artists into the complete world of opera. Nearly a decade old, the program&#039;s illustrious alumni have gone on to grace the stage of the Met, staff the majority of the current COC Ensemble Studio, and launch opera companies."
slug = "cosi-a-day-in-the-life"
title = "COSI: A day in the life"
+++

This evening, when a group of Canadians presents productions of two Italian operas, Mozart's *Cos􏰀􏰁ì fan tutte* and Cavalli's *La Calisto*, no one will be fussing over subtitles. The audience will be made up of residents of the quaint cittadina of Sulmona, and they can manage without a translation.

It's the final week of the [Centre for Opera Studies in Italy (COSI)](/scene/companies/cosi-centre-for-opera-studies-in-italy/), a month-long, comprehensive summer training program that immerses emerging opera artists into the complete world of opera. Nearly a decade old, the program's illustrious alumni have gone on to grace the stage of the Met, staff the majority of the current COC Ensemble Studio, and launch opera companies (*ahem* [Against the Grain](/scene/companies/against-the-grain-theatre/) founder [Joel Ivany](/scene/people/joel-ivany)) and premier opera news sources (*ahem* [Schmopera](http://www.schmopera.com/) creator Jenna Douglas).

Although the participants leave the program with a strong, tangible operatic training experience, [COSI](https://instagram.com/cositaly/)'s activities reach far beyond singing. COSI not only features a demanding rehearsal schedule for the singers and collaborative pianists preparing the operas, but also recitals, chorus work, physical exercise, Italian lessons, a music research symposium and internships in stage management, arts management, directing, and conducting. A typical day at COSI could include:

#### 8 a.m. Zumba

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436940465474/PHOTO-1---Zumba---Photo-by-Blanche-Isra%C3%ABl.jpg.jpg)<figcaption>Zumba! Photo: Centre for Opera Studies in Italy.</figcaption>
</figure>

Veteran COSI participant and soprano Karine White is in Sulmona for the fourth time this year. A certified Zumba instructor, she leads a morning class as part of COSI's Bodyworks program. It is important to Artistic Director [Darryl Edwards](/darryl-edwards-on-teaching-voice/) that singers get in the habit of attending to their physical health early on. *Così 􏰀􏰁fan tutte* music director [Les Dala](/scene/people/leslie-dala/) often makes an appearance. Those who sleep through Zumba can opt to catch a yoga class later in the morning.

#### 9 a.m. Italian Lessons

Split into four levels from Beginner to Advanced, COSI participants and faculty take Italian classes with local teachers. Many participants progress quickly, thanks to the immersive experience of living in Sulmona for a month.

#### 10 a.m. Music Research Workshop and Symposium

Research professionals discuss the best practices and research tools with COSI participants. This initiative, new this year, aims to bridge the gap between music performance (with a specific lens on music education) and the literature and research supporting it.

#### 11 a.m. Coachings and Lessons

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436940536221/Screen%20Shot%202015-07-15%20at%2012.08.46%20AM.png)<figcaption>Daevyd Pepper in coaching with Natalie Doucet. Photo: Centre for Opera Studies in Italy.</figcaption>
</figure>

Singer participants receive a guaranteed number of one-on-one coachings and lessons with faculty members and collaborative piano participants. They can choose to work on their own repertoire if they are here as part of the Independent Study Program (ISP), on arias and recits if they are in one of the operas being presented, or on a solo for one of the upcoming oratorio concerts, masterclasses, or recitals peppered throughout the program.

#### 12 p.m. Lunch at Bar Giardini

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436940574620/Screen%20Shot%202015-07-15%20at%2012.09.28%20AM.png)<figcaption>Photo: Centre for Opera Studies in Italy.</figcaption>
</figure>

Around this time, the caf􏰂􏰁next door gets inundated with hungry, under-caffeinated COSI participants, many of whom ask the lovely Italian staff for help with language practice. This is one of the great things about COSI's Italian setting, which allows participants to subconsciously develop a deep understanding of the culture and language of Italy, and of opera by extension. By having an opportunity to familiarize themselves with the values, customs, and sense of humour of modern-day Italy, singers and pianists leave the program better equipped when approaching the libretti, characterization, and score in an Italian opera.

#### 1 p.m. Chorus Rehearsal

As the town shuts down for the afternoon, retreating from the midday heat for a home lunch and a nap, COSI afternoon activities ramp up. Another new addition this year, COSI's new chorus program provides an avenue for choral singers. With several concerts lined up in and around Sulmona, as well as the chorus needs of the program's two operas, there is no shortage of work for the COSI chorus.

#### 2 p.m. Masterclass

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436940683415/Screen%20Shot%202015-07-15%20at%2012.11.02%20AM.png)<figcaption>Sarah Forestieri sings in a masterclass. Photo: Centre for Opera Studies in Italy..</figcaption>
</figure>

A few times a week, an afternoon masterclass allows select singers to present what they are working on in front of a supportive room of their peers, and explore it with the guidance of a teacher. This time of day features a high volume of "aha!" moments.

#### 3 p.m. Opera Rehearsal 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436941276746/Photo%204%20-%20Opera%20Rehearsal%20-%20Photo%20Darryl%20Edwards.jpg.jpg)
<figcaption>Photo: Centre for Opera Studies in Italy.</figcaption>
</figure>

This week, the orchestra has arrived and the casts of the two operas are in dress rehearsal mode. Each opera will be performed four times, with a rotation in the casts. Two beautiful, historic, outdoor courtyard-type venues provide the backdrop, and admission is free. Locals make sure to have it in their calendars.

#### 7 p.m. Performances

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436940756779/Screen%20Shot%202015-07-15%20at%2012.12.30%20AM.png)<figcaption>Photo via COSI on Instagram.</figcaption>
</figure>

There are a number of performance opportunities for participants, both in the ISP and in the operas. *Viva Rossini!* concerts, oratorios, recitals in neighbouring towns, and opera performances can start as late as 9:30 p.m., so performers must be prepared to sing past midnight. It's all in a day's work, though they may not make it to 8 a.m. Zumba tomorrow.

The demands of flying and jetlag, being away from family and friends, taking care of your instrument and your health while on the road: none of these things can be learned in school. Beyond the robust musical training, COSI provides an insightful introduction into the reality of opera careers.
