+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2024-04-22T00:00:00+01:00"
lastmod = "2024-04-22T00:00:00+01:00"
preamble = "American soprano [Corinne Winters](/scene/people/corinne-winters/) will be performing in [San Diego Opera's _Madama Butterfly_ on April 26 and 28](https://www.sdopera.org/shows/madama-butterfly/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1713791808/sqCorinneWinters_LiliyaNamisnyk.jpg"
primary_image_credit = "Liliya Namisnyk."
postamble = ""
publishDate = "2024-04-22T00:00:00+01:00"
related_articles = ["articles/talking-with-singers-corinne-winters.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = ["scene/people/corinne-winters.md"]
short_description = "We don't sing with good technique just for the fun of it. It's there so that it frees us up to be great artists. The technique has to be there first, so that we can let go and actually do the rest."
slug = "corinne-winters-humans-do-stupid-stuff-and-i-think-art-should-reflect-that"
title = "Corinne Winters: 'Humans do stupid stuff and I think art should reflect that.'"
+++

__Eva Cahen: In your last [chat with Schmopera in 2016](/talking-with-singers-corinne-winters/), you said Madame Butterfly was still on your bucket list, but it was far off because it was one of the holy grails of roles. You've now been singing Madame Butterfly for a few years. How does that feel?__

__Corinne Winters:__ Singing _Madama Butterfly_ feels exactly like what I thought it would feel like back in 2016. I premiered the role in 2021 in Rome. It was an incredible experience to say the least, to be singing Puccini in Italy, outdoors at Circo Massimo, in the Roman ruins. It was a dream come true and it also came about in a very Kismet way. It was right after the lockdowns ended and I didn't have anything for the summer because we were still wondering if we were going to have a business. I had been off the stage for 18 months, sitting around. I got a call from my manager saying can you learn _Butterfly_ in six weeks and go to Rome and sing it. I absolutely could because I'd been informally studying this role for many years. It felt like the perfect time.

"I had thought that being an American singing in Italy would be tricky. It could go either way but it went very well. It was a great omen for doing more Butterflies in the future. After, I had more confidence and I told my manager I'd like to keep booking this role because I think it highlights everything that I do well, and everything that I want to express artistically."

> "I sing because I have no choice."

__EC: Why was the role of Butterfly one of the holy grails to attain?__

__CW:__ "Other than maybe a few of the Wagner roles, this is the stamina role of the soprano repertoire, maybe even more so in the sense that the Wagner roles are spread out over a long evening with breaks. Whereas, this piece is under three hours, but Butterfly is singing, two and a half hours of it. The infamous Act II of Butterfly, which is one of the best acts of opera ever written, is where Butterfly comes on and doesn't shut up."

"There are often discussions on social media amongst opera nerds, and I love these discussions, especially on Twitter where people will say, 'what's your favorite act of any opera?', and I see many people say Act II of _Butterfly_. The whole piece is a masterpiece but act two is really special."

"However, there's also this element of stamina on the part of the singer because Butterfly has this whole arc and journey through that act. It's so dramatic and so emotionally intense that it alone is longer than many of the roles I sing in total. There's the vocal challenge of that as well as the dramatic high stakes. The piece is well-known but it is very different singing it in the music rehearsal with the music stand than it is actually getting up and doing it, with the acting and having the child there with you, feeling and living all these emotions. That makes the vocalism even harder."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1714438446/Corinne-Winters_SDO_KarliCadel-SDO-Butterfly-5025.jpg){{% /md %}}

<figcaption>Soprano Corinne Winters is Cio-Cio-San in San Diego Opera's MADAMA BUTTERFLY. April, 2024. Photo by Karli Cadel.</figcaption>
</figure>

__EC: Is the story of _Madama Butterfly_ and Cio Cio San's sacrifice still relevant today?__

__CW:__ "The hallmark of great art is something where the actual details of the story are not as relevant as the core message, or the core feeling. This piece shows the full spectrum of humanity and what humanity is capable of -- the good, the bad, and the ugly. It is also this arc of experience, and how experience can change you, both on the part of Butterfly and of Pinkerton. She starts out very hopeful and she tries to keep the hope alive, but she becomes very agitated. It is obvious that there is doubt in there somewhere because she is trying so hard to keep hope when it is dwindling. Then this despair at the end, and anger, and wanting to maintain her honor."

"The arc of Pinkerton's character is not discussed much but it is also important. I said this in another interview, and it is important to repeat it. He is often labeled a villain. People boo him at the end like he is a monster but actually he is a young man who makes a stupid choice. It's the standard at the time; it's wrong, but it's something that a lot of young people do, in varying degrees, make stupid and immature and egoistic choices. By the end of the piece, he has grown up a bit and he's remorseful and sees the error of his ways. Unfortunately, it's too late."

"That sort of villain, someone who makes stupid choices, realizes it and is changed forever because of it, is important to highlight. In our society now, we don't leave any room for people to make mistakes. The cancel culture in our world now requires us to have this impossible standard of perfection and integrity in the way that we act all the time. That's not how we are hardwired. Humans do stupid stuff and I think art should reflect that, the spectrum of being human. That's what this piece does so brilliantly, not just with those two characters, but with all the characters."

__EC: You also named Manon Lescaut as one of the holy grails. Is that role coming any closer to happening? Why did you call Manon Lescaut one of the holy grails?__

__CW:__"I'm doing _Manon Lescaut_ in concert next season. The difference with _Manon Lescaut_ as opposed to _Madama Butterfly_ is that _Manon Lescaut_ is not done as often, and it is often done with a particular singer in mind, and a tenor as well, because it is very hard to cast. It is one of those roles which, similarly to _La Traviata_, where the first act is in a light whimsical kind of style, it gets more dramatic as it goes on. You need a singer who has enough drama in the sound to handle the final act, which is quite dramatic, but then to also be able to have the youth and flexibility for Act I. There's this combination and I didn't have the drama in my voice before."

"Even though a role like Manon Lescaut has traditionally been sung by a voice one shade heavier than mine, I'm able to do it because I've trained that way and acting-wise it fits me well. I've fallen more into the roles which fit my personality, and then vocally, I make it work. That's how it's fun for me."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1713791808/CorinneWinters_iliyaNamisnyk.jpg){{% /md %}}

<figcaption>Soprano Corinne Winters. Photo: Liliya Namisnyk.</figcaption>
</figure>

__EC: My introduction to you was in 2016. I saw you singing Violetta at the San Diego Opera and I was so moved I went back for a second performance. How have you and your career evolved since then?__

__CW:__ "I've had a huge vocal evolution and part of that is just growing up. When I was in San Diego last time, I was in my early to mid 30s and now I'm 41 and have lived life a bit more. My voice has matured, and I've had more experience. We -- all artists -- have been through this collective change of the pandemic and reassessing what the career means to us, and having time off, which had its downsides but also its upside. I feel like I came out of all that as a different singer. It started right before the lockdowns with the last contract before that where my voice was really starting to grow. It was heartbreaking when I couldn't capitalize on that growth right away, but it also was good because I was able to take the time to refine things in a calm way.

"My voice has grown a lot and I'm grateful that it's going in the right direction but I also stay on top of it. I'm always studying and coaching, keeping people around me that I trust. I call them trusted sets of ears to make sure I'm on the right track because our instrument is funny. The way something sounds to us isn't always how it sounds out there. This means that even if something sounds good in our own ear, it might not actually be the best sound in the theater. It's important to have people we trust, that keep us honest, that have our best interests at heart, but also tell us the truth if we're going down the wrong path vocally.

"I’ve had more experience since the last time I was here in San Diego. What people like about what I have to offer - and it is about the public at the end of the day, the people who pay for the tickets - that's what I need to give, and luckily, it's what also feels aligned with my own artistry. I feel more energized than ever and more aligned than ever with what I want to convey and express as an artist. I'm very, very grateful.

> "It doesn't matter how talented you are because we are still human beings."

__EC: Why do you sing?__

__CW:__ "I sing because I have no choice. I'll explain what I mean. No choice because this expressing myself in this way, through my voice, through my expression, through being on stage, is a compulsion. I have to do it. I truly think this is why I've been successful. I'm not saying you shouldn't have other things in your life and that it has to be all about the career. I'm not saying that at all, but I do think that the desire to sing, the desire to have that expression come through your throat and express it through the human voice has to be a non-negotiable. If you can take it or leave it, it's going to be hard to last in this career and deal with the trials and tribulations that come along because there are so many. Often, when people quit it's not for lack of talent. It's because it's not a non-negotiable for them. For me, there is no choice. I have to express myself this way. Even if, God forbid, something happened and the career fell apart, I would still sing because I just have to do it."

__EC: What are your thoughts of the San Diego Opera production of _Madama Butterfly_?__

__CW:__ "Maestro Yves Abel is fantastic. I'm loving what he's doing so far. He knows the score inside and out. He conducted the premiere of the _Butterfly_ that I did in Rome. He did the premiere and I did the revival. That was a cool tie in that we were both able to do that production. He's a fantastic musician and a great guy. I'm so happy to be working with him for the first time. The director, Jose Maria Condemi is a wonderful guy. He is amazing. We worked together at Wolf Trap Opera in 2013 and that was fantastic. I loved working with him then and I love working with him now. He's very delicate and specific with handling the Japanese movements, the way the costume department is doing that. He's being very elegant with everything, super well informed so that there are no stereotypes going on stage, the kinds of things that would be offensive. He’s being very mindful of the traditions and doing them in an elegant way while being true to the story as well. It's an old set from Utah Opera's production but we're doing it our way. The costumes are stunning. I like his take on the piece and we're creating something great."

__EC: What motivates you to mentor and teach master classes even as you have such a busy international career?__

__CW:__ "It's helpful for young singers to have vocal technique and career advice from someone who's in the business now, someone who's doing it, but also someone who has experienced enough to have been through things. I've been singing professionally for 15 years and I've seen all aspects of the career and I've also worked internationally in many different places and seen how things go. This is very important because in academia, there are often people teaching who had a career, but they've been out of the business for a long time, or it's people who have studied vocal pedagogy but maybe never actually had a career. It's not to say that's not a valid experience or that these people should not be teaching or educating. But it's also valid and important to have current working artists giving input on the business now. 

"In the last decade especially, but in the last two decades, the career has massively changed with what is expected and what is needed to have a thriving career, both from a vocal standpoint and from a career strategy standpoint. I take a holistic approach with my students and in master classes. My focus is vocal technique, because if the technique isn't there, nothing else matters, in my opinion. You can be going on natural talent for a while and have a lot of charisma and have something unique to offer but eventually, there will come a point where you hit a vocal roadblock. If one doesn't have the tools to navigate that, then there will be a downfall. It doesn't matter how talented you are because we are still human beings. These things happen, like for athletes who would get injured without a good coach or without a good practice regimen. Having the technical tools is the foundation."

"I did a video on social media recently where I said technique is there to serve the art. It's not there in a vacuum. We don't sing with good technique just for the fun of it. It's there so that it frees us up to be great artists. The technique has to be there first, so that we can let go and actually do the rest. That's why I'm so passionate about it. Even though I'm very busy and maybe too busy, and in the prime of my career, I have taken on the job of being a teacher. It's because I think it's that important."