+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-01-21T16:01:55+00:00"
disclaimer = ""
image_gallery = []
postamble = "The Queen of Spades runs through February 1. For details and ticket information, [click here.](https://www.roh.org.uk/productions/the-queen-of-spades-by-stefan-herheim)"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548085420/media/2019/01/sq1351TheQueenOfSpadesProductionImageROH2018.jpg"
primary_image_credit = "A scene from The Queen of Spades, ROH, 2019. Photo: Catherine Ashmore."
related_articles = ["articles/roh-traviata.md", "articles/androgyny-is-sexy-carmen-at-roh.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/evamaria-westbroek.md"]
short_description = "I think it is a good thing to have my sensibilities questioned. An opera score does not always need to be taken at face value and can be up to individual interpretation."
slug = "constructive-frustration-from-rohs-queen-of-spades"
title = "Constructive frustration from ROH's Queen of Spades"
youtube_url = ""

+++
This production of Tchaikovsky’s _Queen of Spades_ designed by Philipp Fürhofer and directed by Stefan Herheim is a highly conceptual piece that places the focus on the composer. Herheim is attempting to create a window into the composer's mind at the time this piece was being written. To assist in establishing this, he made the controversial choice to have the singer cast as Prince Yeletsky also play the role of Tchaikovsky.

> I left the theatre with mixed feelings. I could not say that I enjoyed every aspect of this production but I think we should always be bold in opera.

Over the course of the opera we see Tchaikovsky living out his artistic process of composition which in the case of the _Queen of Spades_, was a 6-week period of isolation during which he wrote scene after scene at a ferocious pace. When completed, he reportedly wept having become so close to these characters that he created only to lose them all at the end. Tchaikovsky died of cholera in 1893 after supposedly drinking a glass of contaminated water some believe, purposely. Suicide by contaminated water featured heavily in this production. The three major character deaths that happen over the course of the opera, happen because the characters drink the contaminated water. This is a central idea for Herheim who has strategically and symbolically placed the cholera infected glasses in key moments of the opera.

This Prince Yeletsky/Tchaikovsky character takes on the role of the observer and puppet master. He conducts and mimes piano playing along to the orchestra as if he is hearing the music in his mind. He often reacts physically to situations the characters find themselves in as if he is feeling everything they are feeling and offers copies of the score so that characters can react to situations accordingly. The themes of fate and prophesy that run throughout the opera are apparent here. The central plot point of the opera is the prophesy that exists around the three cards that only the countess (the queen of spades) knows the identity of. It is prophesied that a young, impassioned man will appeal to her one day, asking for the cards to be revealed and this will cause her death. The countess therefore knows when and how she will die and so her fate is bound by destiny. In the same way, the characters actions are bound by a score, their choices are all predetermined Tchaikovsky and their fates, sealed.

I think it is always bold and interesting when a director chooses to approach a piece like this in such a conceptual way. Herheim purposely bends the limitations of the score to suit staging needs that work with a concept which I think allows the work to come to life in strange and unexpected ways. But where I feel this was slightly unsuccessful was in that the Prince and Tchaikovsky were played by the same person. This made motivation and intention very confusing throughout the opera when baritone Vladimir Stoyanov was on stage as Tchaikovsky versus when he was on stage as the Prince. Intentional confusion I'm sure, but a confusion none the less.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548086393/media/2019/01/0375VladimirStoyanovasYeletskyinTheQueenofSpadesROH2018.jpg){{% /md %}}

<figcaption>Vladimir Stoyanov as Prince Yeletsky/Tchaikovsky in The Queen of Spades, ROH, 2019. Photo by Catherine Ashmore.</figcaption>

</figure>

In general, the opera felt fragmented. There were too many elements converging at the same time. The true heart of the story is the moment when Gherman confronts the Countess in order to learn what the three cards are. This moment took a long time work up to with very little substance leading up to it. The love story between Gherman and Liza which is what initially sparks Gherman's obsession with the chance to win a fortune, is questionable to say the least. There is no history between the two of them, and Liza seems happy enough to marry the Prince until she is manipulated by Gherman into breaking off her engagement when he threatens suicide if she does not. Not an ideal start to a romance. There is an entire scene in the musical style of Mozart which quotes the _Magic Flute_ quite directly. Though I believe this to be Tchaikovsky's tribute to an idealized 18th-century sensibility, I didn't see its relevance to the story and found it distracting and superfluous.

> When we are engaging with a piece of art, frustration can be a perfectly natural response and I think that is a good reminder every so often.

I was, on the whole, very impressed with the level of artistry on stage. Felicity Palmer as the Countess was an absolute joy to watch. It was the right decision to go with a suitably aged voice for an aged character. Despite this, Felicity Palmer gave a powerful, moving, and often comical performance. She exhibited an incredible amount of subtlety and control particularly in her Act II aria in which, fearing her death is near, she reminisces on the days of her youth in Paris. It was sung in a delicate, shimmering piano that sent a noticeable hushed, rapt attention throughout the hall.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548086288/media/2019/01/0303EvaMariaWestbroekasLizainTheQueenofSpadesROH2018.jpg){{% /md %}}

<figcaption>Eva-Maria Westbroek as Liza in The Queen of Spades, ROH, 2019. Photo by Catherine Ashmore.</figcaption>

</figure>

Dutch soprano [Eva-Maria Westbroek](/talking-with-singers-eva-maria-westbroek/) was fantastic in her role as Liza. She has an incredible instrument which she carried with grace and poise. Unfortunately, and through no fault of her own, her storyline didn’t leave a lasting impression. I have had the great fortune of hearing her live in previous productions and would hope to be able to do so again in a role with a greater arc and development. In many ways this was a man’s game (and let’s face it, so much of opera is) and so her storyline seemed to fade into the background.

Gherman, sung by Latvian tenor [Alexsandrs Antonenko](/scene/people/alexandrs-antonenko/) was appropriately brooding and unpleasant. Antonenko had a strong presence on stage and a voice to match but he wavered slightly. There were some truly exciting moments vocally, but many moments where he fell short. It was a large brassy sound that he did not seem to have control over and he had a bad habit of hoisting his voice up into the higher register with somewhat questionable results.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548086252/media/2019/01/0453GoryachovStoyanovandStuckerinTheQueenofSpadesROH2018.jpg){{% /md %}}

<figcaption>Anna Goryachova, Vladimir Stoyanov, and Jacquelyn Stucker in The Queen of Spades, ROH, 2019. Photo by Catherine Ashmore.</figcaption>

</figure>

Baritone Vladimir Stoyanov as Prince Yeletsky provided some of the most accomplished, polished singing of the evening. It was a shame the role wasn't more significant because I would have really liked to see more of him. He deserves a huge commendation for his role as Tchaikovsky as well which I can imagine would have been an extremely draining performance physically. It required him to be onstage for the entirety of the opera which takes an incredible amount of fortitude and acting skill. A very bold performance.

I would be remiss if I did not also mention mezzo soprano Anna Goryachova in the small role of Paulina/Milovzor. She was incredibly engaging and likeable on stage and had one of the most incredible young voices I've heard at the Royal Opera House. It was a mesmerizingly dark mezzo colour and completely captivating. I am very interested to see her in other roles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548086205/media/2019/01/0168TheQueenofSpadesProductionimageROH2018.jpg){{% /md %}}

<figcaption>A scene in The Queen of Spades, ROH, 2019. Photo by Catherine Ashmore.</figcaption>

</figure>

I left the theatre with mixed feelings. I could not say that I enjoyed every aspect of this production but I think we should always be bold in opera. I think it is a good thing to have my sensibilities questioned. An opera score does not always need to be taken at face value and can be up to individual interpretation. Just as Tchaikovsky made additions and changes to the original Pushkin, Herheim took his own liberties creating a conceptual piece that asks a lot of his audience, and rightly so. When we are engaging with a piece of art, frustration can be a perfectly natural response and I think that is a good reminder every so often.