+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-05-10T10:15:00+01:00"
lastmod = "2016-05-10T11:42:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462875191528/2016-05-10---Kronos-Quartet.jpg.jpg"
primary_image_credit = "The Kronos Quartet. (l-r) John Sherba, Sunny Yang, Hank Dutt, and David Harrington. Photo: Jay Blakesberrg."
publishDate = "2016-05-10T11:42:00+01:00"
related_articles = ["articles/music-as-theatre-a-chamber-concert-in-banff.md"]
related_companies = ["scene/companies/kronos-quartet.md"]
short_description = "Though not surprising, based on the Quartet&#039;s history, their concert was one that reminded us that there still exist new sounds, new ways of playing these very old instruments. That included the &quot;show&quot; aspect of a string quartet performance; now a staple element of the music they perform, theirs is an organic use of amplification, helped by sound designer Scott Fraser, and effective lighting design, by Brian H. Scott."
slug = "constantly-new-the-kronos-quartet"
title = "Constantly new: the Kronos Quartet"
+++

Last night's concert at the Barbican Centre was a dense, tangible reminder of why the [Kronos Quartet](http://kronosquartet.org/home) is a leading ensemble in contemporary music. After over 40 years together, Kronos has had over 750 pieces of music written for them; their collaborations reach across borders and genres, including music by Terry Riley, Henryk Górecki, Philip Glass, Wu Man, Alim Qasimov, and Asha Bhosle, and they have shared the stage with everyone from Paul McCartney to Tom Waits to David Bowie.

Though not surprising, based on the Quartet's history, their concert was one that reminded us that there still exist new sounds, new ways of playing these very old instruments. That included the "show" aspect of a string quartet performance; now a staple element of the music they perform, theirs is an organic use of amplification, helped by sound designer Scott Fraser, and effective lighting design, by Brian H. Scott. With no attention taken away from the Quartet's playing, the subtle visual responses to changes in the music kept us listening in the present, and the four players took beautiful advantage of the extended soundscape made possible by amplification.

Four decades of a shared aesthetic showed in their cohesion; it all felt unshakeable, their rhythmic pockets, their exchange of musical roles. At times, it was almost a shock to be reminded that we were listening to live music. The Kronos Quartet played a few picks from their ongoing [*Fifty for the Future*](http://kronosquartet.org/fifty-for-the-future/about) project, which was launched this season; over five years, the Quartet and the Kronos Performing Arts Association commissions fifty works for string quartet by contemporary composers (25 of which are women!). The library of new music is an extraordinary tool for young string quartets, both as a wealth of repertoire, and as practical opportunities to develop a familiarity with the demands of 21st-century music. The best part: the scores and recordings of these commissions are available for download, all [**for free**](http://kronosquartet.org/fifty-for-the-future/about).

The project is exciting in itself, but the best part is that these pieces of music are *really great*. Aleksandra Vrebalov's *My Desert, My Rose* and Garth Knox's *Satellites* are sound-stretching, and totally beautiful; it's exciting to imagine these works taking the spotlight in the string quartet repertoire, alongside Beethoven and Shostakovich. Another pick of ours would be Jacob Garchik's arrangement of *Baba O'Riley*, by Pete Townsend.

Composer Martin Green joined the four players for the world premiere of *Seiche*; the work was commissioned for the Kronos Quartet, and it features the Kronoscillator, an instrument Green invented out of amplified Slinkys (yes, the "everyone loves a Slinky" kind). It became a piece of performance art, a tableau of composer-as-DJ, and an amplified string quartet bordered by two outstretched Slinkys, manipulated by tuning forks and violin bows. Totally neat.

The concert ended with a pick from the Quartet's [*Kronos: Under 30 Project*](http://kronosquartet.org/projects/detail/under_30), a commissioning program for composers under 30. Armenian composer Mary Kouyoumdjian's *Bombs of Beirut* was a heavy piece of multi-disciplinary sound, pairing narrative and evocative writing for the quartet with sound bites of survivors of the Lebanese Civil War, and of the bombings and attacks that took Beirut between 1976-1978.

The concert was something of a reality check for what it means to be a contemporary musician. There was enormous diversity of sound, helped by an equally diverse amount of input from composers of all ages, across the world. Four Western instruments weren't bound by style or geography; the Kronos Quartet simply stepped up to the task of pulling every bit of creativity and beauty out of the music they played. There was no balking at the use of sound amplification, only a recognition of how handy it could be to help their instruments sound like sitars or human voices. 

What we loved most was that no qualifications or precursory comments were necessary; as far as the Kronos Quartet was concerned, this was all under the broad umbrella of "music".

The Kronos Quartet is in the middle of touring the UK, before they head to Toronto, Nicasio, CA, and Amsterdam. [Click here](http://kronosquartet.org/concerts) to snag a ticket.
