+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-06-06T21:53:00-04:00"
lastmod = "2018-06-07T15:46:00-04:00"
preamble = "It has been nearly 20 years since the death of [Matthew Shepard](https://en.wikipedia.org/wiki/Matthew_Shepard), who was a student at the University of Wyoming when he was beaten, tortured, and left tied to a fence in the cold on October 6, 1998. His death brought international focus on hate crime legislation, resulting in the \"Matthew Shepard Act\", passed by US Congress in 2009.\n\nOn top of activism, Matthew Shepard is remembered through art. Composer and conductor [Craig Hella Johnson](http://www.craighellajohnson.com/) has written his choral drama, [*Considering Matthew Shepard*](https://www.fordtheatres.org/calendar/considering-matthew-shepard), performed by GRAMMY Award-winning Conspirare choir on June 15-16 as part of the City of West Hollywood and WeHo Arts' *One City One Pride* LGBTQ Arts Festival. \n\nWe spoke with Johnson about his word, what it means to present it during this year's Pride Month, and what the 20 years since Shepard's death have brought to the lives of those in the LGBTQ+ community."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528336265437/sqCMSCHJdetail_goulden_0898.jpg.jpg"
primary_image_credit = "Photo: James Goulden."
publishDate = "2018-06-07T11:22:00-04:00"
short_description = "I love the word &quot;consideration&quot; - and its meaning to think about something carefully and thoughtfully, to bring one&#039;s attention to something. With this piece, I am inviting people, through music, to consider the story of Matthew Shepard&#039;s life, and in particular, how he died. "
slug = "considering-matthew-shepard-20-years-later"
title = "Considering Matthew Shepard: 20 years later"
+++

### What does it mean to you to consider Matthew Shepard?

I love the word "consideration" - and its meaning to think about something carefully and thoughtfully, to bring one's attention to something. With this piece, I am inviting people, through music, to consider the story of Matthew Shepard's life, and in particular, how he died. 

And I am also inviting people to consider their own lives in relationship to this consideration and to reflect on what is the value of a life...Ultimately, I hope that this consideration, in the form of a shared concert experience, can spark in us some ideas about how we might learn to live together with more love and deep respect for our life together, to try and remember who we are at the core 

### Where do you think we are today in our treatment of members of the LGBTQ+ community, as opposed to 20 years ago?

In so many ways, tremendous progress has been made. I have heard [Matthew's mother] Judy Shepard say that she thinks Matt would be amazed and proud at the progress. And at the same time, we are all dismayed and greatly challenged by this brutal backlash we are all witnessing and experiencing. It is really harsh and is hurting a lot of people right now. I often wonder how Matt might respond to all of this if he were here.

### What musical aesthetic did you find to tell this story?

First of all, we sing this story. It is part classical oratorio, part musical theatre, part opera, but all incredibly intimate. Even though it is a concert length work (about 100 minutes), I like to think of this as one Big Song for Matt. I was very intentional to create a framework in which a wide variety of musical styles could be represented but not in isolation - a broad spectrum of musical styles and expressions that could feel all part of the whole. Musically, I wanted to create something that could connect with a broad and diverse audience.

### What do you hope audiences will take away from these performances during Pride Month?

Mostly, I want for people to have an experience. On a most basic level, we want to share a vibrant musical experience. This is a great privilege for us to sing this work for people during Pride Month. I don't have any pre-set sense of expectations other than a deep hope that people will listen and be open to honoring whatever their own journey is.   

The work and the concert centers initially around the final days of Matt's life, but my intention was to create something that invites an inner journey for each listener. The voice I feel at the center of this piece is fierce and strong and urgent - "in order to heal and regain our essential lives back again, we need to be willing to see and be seen - to allow ourselves to be revealed to one another and to remember who we truly are. We need to do this together. All of Us. No exceptions." 

To be performing this during Pride Month is significant and special for all of us. My fellow LGBTQ+ friends have been the soldiers of love and justice on so many fronts. I hope these performances can be inspiring and nourishing. As performers, we always leave these performances with a feeling of deep connection and joy. We just want to share that.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528336467390/CMSImage.jpg.jpg)
</figure>

>*Considering Matthew Shepard* happens June 15-16 and tickets start at $25. For full details, [click here.](https://www.fordtheatres.org/calendar/considering-matthew-shepard)
