+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2018-04-16T12:57:00-04:00"
lastmod = "2018-04-17T20:03:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523897687427/sqOmahaOne180409ProvingUp4549.jpg.jpg"
primary_image_credit = "Proving Up, Opera Omaha, 2018. Photo: James Matthew Daniel."
publishDate = "2018-04-17T20:03:00-04:00"
related_articles = ["articles/as-one-they-both-took-risks-that-paid-off.md"]
short_description = "Personally, I felt like The Sodbuster was more of a symbolic spectre of death. Death must have been a powerful presence among settlers. It was an extremely perilous way of life, and people died frequently, often isolated and unknown. "
slug = "confusing-creepy-proving-up"
title = "Confusing &amp; creepy: Proving Up"
+++

*Little House on the Prairie* meets *The Shining*. This phrase truly encapsulated the visceral experience that is Opera Omaha's production of *Proving Up*. Composer Missy Mazzoli and librettist Royce Vavrek have crafted an opera that captures the dark side of the American dream that is so often glossed over. Based on the short story by Karen Russell, *Proving Up* focuses on settlers who struggle against adversity, work hard, and still do not succeed. This goes against the vision of the American West that has been idealized for years, but let's be real. For every pioneer that beat the odds, there had to be countless others that failed miserably. (Hell, I can't even make it through The Oregon Trail game without dying of dysentery!)

The set for *Proving Up* was both intimate and striking. Scenic designer Adam Rigg has constructed a makeshift barn-like structure in the KANEKO art gallery with a long trough of dirt as the stage. It is an appropriate focal point since the plot revolves around the concept of land ownership. Everyone is fighting and struggling for a patch of dirt to call their own, and every member of the cast interacts with the dirt throughout the opera. I can only assume that the entire cast has to hose off after each performance because every single one of them was covered in some combination of dirt, blood, and various beverages by the end of the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523897751669/OmahaOne180409ProvingUp.jpg.jpg)
<figcaption>*Proving Up*, Opera Omaha, 2018. Photo: James Matthew Daniel.</figcaption>
</figure>

It felt as if everything about this production was meant to make the audience feel uneasy. The seating was mismatched and uncomfortable. The lighting was eery. The program covers had a texture that made my skin crawl. I'm not sure if it was all intentional, but I think it added to the general ambiance. The experience was so effective that I have a hard time imagining what this opera would be like in a traditional theater space.

Missy Mazzoli's compositional style has a cinematic feel to it, and I could easily see her writing soundtracks for horror movies. The music evoked unease that cannot be described fully. Even in the rare happy moments of *Proving Up*, there is tension lurking in the orchestration. Beauty and anxiety are juxtaposed perfectly.

The opera opened with "Pa" Zegner singing a piece called "Uncle Sam's Farm" which was reminiscent of hymns and patriotic songs without directly quoting anything. During this piece, Pa, portrayed by John Moore, transitions from confident and proud settler into a desperate drunkard in the span of a few minutes. Moore's voice is strong and emotional, displaying rich colors throughout the opera. His acting skills are equally powerful and versatile. There is nowhere to hide in this space, and it felt like all the performers were truly immersed into their characters. This family's life revolves around U.S. Homestead Act and the goal of "proving up" so that they will officially own their homestead claim. They recite the legal requirements needed frequently in the opera: five years on the land, a sod house, acres of wheat, and most absurdly, a window of glass. So much is at stake over something so superfluous. 

At this point you are probably saying to yourself, "Okay, I am getting the *Little House on the Prairie* vibes, but where does *The Shining* come into play?" Well, everything seems pretty normal until the two dead daughters show up on stage, looking nearly identical in their ghostly, white dresses. They provide commentary throughout the opera, even interacting with their brother Miles who seems to be the only one that notices them. Abigail Nims and Cree Carrico portray the sisters with vocals that fluctuate between haunting, abrasive, and playful. Their presence is constant and unnerving, and both singers take on the physicality of their roles with a creepiness that I'm sure would make any horror movie director thrilled.

"Ma" Zegner, sung by Talise Trevigne, was both tragic and fierce. Trevigne's vocal lines managed to be lyrical and heartbreaking even during physically demanding staging. In a particularly jarring scene, she pulls her daughters' corpses out of their graves and clutches them while she laments. It was disturbing and unexpected, but it didn't come across as something done for shock value. 

The older brother, Peter Zegner, played by Sam Shapiro, was a rather thankless role. He was covered in blood for most of his performance, being stitched up by Ma for his first scene and then brutally shot in the finale. 

Miles Zegner is the youngest brother and appears to be the least downtrodden of the family. Michael Slattery sang the role with an air of innocence tainted by uncertainty. It was in the second half of the opera during his journey to deliver the window of glass to some neighbors that the character develops more complexity. Slattery's vocals finally got a chance to shine in his final dramatic scene, facing his own mortality and asking desperately, "What makes a home? Who owns the land?" No one answers him.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523897737128/OmahaOne180411ProvingUp6557.jpg.jpg)
<figcaption>*Proving Up*, Opera Omaha, 2018. Photo: James Matthew Daniel.</figcaption>
</figure>

On his journey, Miles runs across The Sodbuster, portrayed by Andrew Harris. It seems such an unassuming name for such a deeply unsettling character. Harris' menacing bass voice commands the stage immediately. His music hits you with instantaneous foreboding. Harris shows vocal flexibility in this role as well. His music is mainly dark and low, but the portions that were high in his range came across as even more unnerving. The character of The Sodbuster leaves the audience with many questions. We see him murder Miles onstage, and he makes references to other deaths in the area. Is this guy some sort of pioneer serial killer? 

Personally, I felt like The Sodbuster was more of a symbolic spectre of death. Death must have been a powerful presence among settlers. It was an extremely perilous way of life, and people died frequently, often isolated and unknown. The American West is the land of "infinite new beginnings" according to The Sodbuster, and at the end of the opera, when death has taken everyone else in the Zegner family, Pa seemingly takes The Sodbuster's place and leaves them behind.  The ambiguity of the ending is true to the horror movie sensibilities. I was confused and creeped out, and I loved every minute of it.
