+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2020-12-23T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "_Confessions_ is available now on [Yarlung Records](https://www.yarlungrecords.com/product/confessions/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1608595717/media/2020/12/195448187984_wfxon6.jpg"
primary_image_credit = "Photo: Arielle Doneson. Album cover design: Jennifer Bruce."
related_articles = ["articles/la-nilsson-celebrating-birgit-nilsson-at-100.md", "articles/orlando-gender-bending-and-the-sound-of-androgyny-in-vienna.md", "articles/the-medium-opera-as-film-noir.md"]
related_companies = []
related_people = ["scene/people/laura-strickling.md"]
short_description = "When contemplating the content for Confessions, soprano, Laura Strickling's recent recording of contemporary art songs by American composers, all of whom occupy the highest ranks of the genre, she was guided by a keen ear for quality and vocal suitability. She was also guided by a commitment to create, out of these fragile entities, a strong and satisfying musical program."
slug = "confessions-art-songs-that-are-deeply-personal"
title = "Confessions: Art Songs That Are Deeply Personal"
youtube_url = ""

+++
An art song is by nature deeply personal. A poem or a passage of prose ignites the composer, melding with the composition. Eschewing the conventions of popular song, and in relatively free form, it consumes a few moments in which it distills a fleeting and quite particular essence. What emerges is wholly unique in form and content. It is also fragile.

When contemplating the content for [_Confessions_](https://www.yarlungrecords.com/product/confessions/), soprano [Laura Strickling](/scene/people/laura-strickling/)'s recent recording of contemporary art songs by American composers, all of whom occupy the highest ranks of the genre, she was guided by a keen ear for quality and vocal suitability. She was also guided by a commitment to create, out of these fragile entities, a strong and satisfying musical program.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1608595602/media/2020/12/5H3vPjcg_csosug.jpg){{% /md %}}

<figcaption>Soprano Laura Strickling and pianist Joy Schreier take time out for a pic during the Confessions recording session. Photo: Laura Strickling.</figcaption>  
</figure>

Perhaps Strickling's most influential guide however, was personal experience. This extraordinarily expressive and versatile singer has with courageous specificity chosen songs that brim with delineations of her life. Strickling performs with an intelligent combination of restraint and letting go. Her voice is full and lustrous and then bright and nimble as she weaves her way through the four cycles and two individual songs that she has selected. Each song is an individual story beautifully rendered. Collectively they make a strong statement about the status of contemporary art songs and her commitment to them.

The soprano's opening gambit, Clarice Assad’s deceptively comedic three-song cycle, "Confessions," which prompts the recording's title, concerns itself with such things as social manners, ice cream and looking good. With words by Naomi Major, Alissa McLaughlan and Catherine Maxymuk, the songs are edged with insecurity, lack of self-control and the pressures of seeking perfection. Strickling veers from the rollicking to the frenzied with energized flair, keeping the underlying desperation close beside her glib and often funny interpretations.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1608595763/media/2020/12/p_xm1rqs.jpg){{% /md %}}

<figcaption>Soprano Laura Strickling performing at a recent Friday Morning Music Club gala. Photo: FMMC Inc.</figcaption>  
</figure>

The lyrics to Gilda Lyons' "Songs of Lament and Praise," are drawn from Irish texts written between the 10th and 12th centuries. Three are from anonymous sources and the remaining two from the writings of ancient Irish churchman and writer Mael Ísu Ua Brolcháin and Saint Patrick. Together they present a story based on the female figures of Eve, Deirdre (a tragic heroine in Irish myth) and Mother. They form a picture of the human condition that Lyons finds has changed very little over time.

"A Mother’s Lament," from an anonymous 11th-century source is perhaps the most tragic expression of familial loss set to music since Samuel Barber's "Andromache's Farewell". Singing Barber's seminal piece, the great Martina Arroyo found the nobility in Euripides' verse which is precisely what Strickling does in the Lyons song. It isn't so much a sound, though the ritualistic rhythm Strickling employs is certainly a part of it, but more a haunting feeling inherent in every word she sings that hangs over this emotionally wrenching work. Conversely "An Even-Song", the last in Lyons' cycle, feels close to a lullaby, albeit an intense one. Lyons composes a plea for our better angels or, as Saint Patrick put it, "thy holy angels" to guide us, which Strickland delivers as a beautifully embellished benediction.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1608595805/media/2020/12/p_1_a64obz.jpg){{% /md %}}

<figcaption>Soprano Laura Strickling performing live in a 2019 WFMT- Chicago radio recital. Photo by Daniel Schlosberg.</figcaption>  
</figure>

Tom Cipullo settings of Marilyn Kallet's four poems under the heading "How To Get Heat Without Fire", show just how perfectly their words and music coalesce. For Strickling they present one vocal opportunity after another which she handily seizes while creating opportunities of her own in the process.

Cipullo's music is bound by virtually nothing. Its boundlessness makes it continually exciting and unpredictable. As an added pleasure the songs are wonderfully polished. Kallet's love poems require exactly that energy and sophistication to show them off as their flirtatious, happy, erotic, and sad selves. The cycle's title poem and its final work, "Saying Goodbye", are staggeringly elegiac.

"The Pocketbook" shows just how psychologically sound this composer/poet team is, not that there was a doubt, and that they are theatrically inclined as well. Unfolding like an unhinged oratorio it is played to comic heights only to come crashing down to halting reality. Strickling traverses the Cipullo/Kallet terrain with ballet-like precision and utter naturalness. But rather than repeat what she does so well it is simply best to acknowledge that admiration for her voice and interpretative prowess grows as this program moves forward.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1608595828/media/2020/12/p_2_sq4bhu.jpg){{% /md %}}

<figcaption>Soprano Laura Strickling performing at a Brooklyn Art Song Society recital at the Brooklyn Historical Society.  Photo by Harold Levine.</figcaption>  
</figure>

Ophelia has been the subject of two works by Amy Beth Kirsten with her "Ophelia Forever", a performance piece in which three singers portray aspects of the heroine's personality. Strickling takes on "To See What I See", an aggressively atonal work with text drawn from Shakespeare. It visits Ophelia's reaction to her disintegrating relationship with Hamlet and encroaching insanity with a lucid moment before her suicide. The strength of its atonality diminishes any image of Ophelia as a weak victim. Pianist, Joy Schreier’s accompaniment is especially crucial to establishing the changing moods of the piece that Strickling conveys so effectively.

Schreier is an indispensable accompanist. She is either preternaturally intuitive or has achieved perfect communication with Strickling in preparing this nuanced program. Perhaps a bit of both. The pianist is provided spacious and atmospheric latitude within "The Teasdale Songs" by composer, Michael Djupstrom, himself a pianist of international stature, from poems by Sara Teasdale. Her renditions of the songs are ravishing.

"I Would Live In Your Love", "Absence", and "Spring Rain", which comprise the cycle, are laced with images of undulating sea-grass, the sounds of insects on a hot night and painful memories spurred by a spring rain. With intense insight they tell stories of love and loss, their messages remaining impeccably clear amid the pervasive imagery. At this point we would expect Strickling and Schreier to do nothing less than capture the essence of each, and they do.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1608595878/media/2020/12/p_3_mcf2wo.jpg){{% /md %}}

<figcaption>Soprano Laura Strickling. Photo: courtesy Laura Strickling.</figcaption>  
</figure>

If "Lament" is the tragically profound take-away from _Confessions_ and "I Would Live In Your Love" its most sensuous and romantic, then Libby Larsen's "Rightly" with text by Michele Antonello Frisch, is its pinnacle of sweet recollection. Beautifully observed, with a thorough knowledge of baseball and its cultural meaning, Frisch's spirited and spiritual remembrance set to Larsen's animated music is a most appealing coda to _Confessions_. Akin to _Knoxville: Summer 1915_, but wholly original in its execution, it possesses Barber's level of musical vibrancy and balance of the abstract and representational. It pulls on the mind as well as the heart.

Not to be overlooked in “Rightly” is the subtle and expressionistic flute accompaniment by Sarah Eckman McIver. It comes trotting in after Strickling impressively sustains the word throw, flautist and singer flaunting the accuracy and strength of the narrator's throwing arm.