+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-09-09T12:44:00-04:00"
lastmod = "2015-09-11T09:08:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441976008909/BernsteinSquare.jpg.jpg"
primary_image_credit = "Leonard Bernstein with the Cincinnati Symphony in 1977. Photo: James Garrett, New York Daily News via Getty Images."
publishDate = "2015-09-11T09:08:00-04:00"
related_articles = ["articles/potential-orchestra-mutiny-and-conductor-envy.md","articles/does-new-opera-raise-the-bar-for-performers.md","articles/new-opera-more-singer-input-needed.md","articles/watch-learn-maestros-at-work.md"]
short_description = "When George Martin and The Beatles made Sgt. Pepper&#039;s Lonely Hearts Club Band in 1967, they made history by using the recording studio itself as a sort of &quot;instrument.&quot; Songs like &quot;A Day in the Life&quot;, or even &quot;With a Little Help from My Friends&quot; aren&#039;t easy to reproduce on a live stage, and the album isn&#039;t meant to be a preserved concert in the same way that Please Please Me is. "
slug = "conductors-what-else-do-they-tell-us"
title = "Conductors: what else do they tell us?"
+++

When George Martin and The Beatles made *Sgt. Pepper's Lonely Hearts Club Band* in 1967, they made history by using the recording studio itself as a sort of "instrument." Songs like "A Day in the Life", or even "With a Little Help from My Friends" aren't easy to reproduce on a live stage, and the album isn't meant to be a preserved concert in the same way that *Please Please Me* is. What's cool about *Sgt. Pepper* and all the inspired albums after it, is that the album itself is the medium; it's not a holding place until you can see a band live, but its own piece of art, like a novel. When you write music with the possibilities of a recording studio or other technology at your disposal, the palates of sound and rhythm can be endless; the playing field becomes exponentially immense. 

This is sort of what the role of the conductor has given classical music, if you think about it. When a composer knows a conductor will be part of an ensemble, they are more free to write music that's more complex; rhythms can be wackier, ensembles can be larger. I don't even mean complexity as in Messaien's *Turangalîla-Symphonie* or Stravinsky's *L'histoire du soldat*; most of Mozart's accompanied recits would be perilous without someone waving his arms. Puccini's fluid tempos, Strauss' counterpoint, Wagner's size, *bel canto* rhythm: all of these styles assume a conductor.

When it comes to contemporary music, the presence of a maestro has come to mean that technically, anything is possible as long as you can show it in a beat pattern. I've worked on opera where singers need to watch a conductor for what they know are the musical basics, like tempo and when to come in. Sometimes that's because the singers and the orchestra can't hear each other, and sometimes it's because there's something unintuitive about the music. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441976197060/toscanini-at-la-scala.jpg.jpg)
<figcaption>Toscanini.</figcaption>
</figure>

Now, the Mozart and Strauss and Puccini I mentioned above *do* have something intuitive about their scores. It doesn't necessarily mean that an orchestra doesn't need a conductor to play this music, but with skilled musicians and enough rehearsal time (ha!) they just might be able to play it *senza maestro*. I can't always say the same about new music, and I think it might be a curious link to a piece's audience reception.

Simply put, if trained musicians can't find something intuitive, something human about a piece of music, doesn't it make sense that the uninformed public won't find it either? If singers and players need constant metronomic help, will the audience hear anything transcendent?

I've spoken in broad strokes, I'm sure. Composers are constantly challenged to write something that stays with listeners, and that's difficult because the criteria is vague. I often wonder if the role of a conductor is a tangible point of reference; a more objective version "will it speak to an audience," it's about asking, "what is natural about this music?" Because, what's natural in art will always move people.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441976399693/Boulez.jpg.jpg)
<figcaption>Pierre Boulez.</figcaption>
</figure>

Now, music simply isn't played without someone leading the way. If it's not a maestro with a baton, it's a concermaster, a singer, someone breathing an upbeat; in every case, everyone is listening to each other. The power to lead can be fluid, and I think that extends both to the conductor, and to the music itself. Puccini is a great example of the latter; you couldn't find music more intuitive than that in *La bohème*, but a conductor holds group intuition into one point.

When listening to each other doesn't solve ensemble problems, the piece is considered difficult. Does that mean that there's a point, within the range of music possibilities in music that's conducted, at which a maestro becomes a crutch, rather than a leader? Does that end up excluding pieces like Messaien's *St. François d'Assise*, or even George Benjamin's *Written on Skin*? I don't want that to happen; but I also don't expect those works to become household hits like Verdi and Wagner.

I do think there's a link between how an audience takes in a piece of music, and how difficult it would be to perform said music without a conductor. I feel like there's a hypothetical Venn diagram, and conductors share some overlap with audiences; that overlap is organicism, intuitiveness. Perhaps in the vague question directed at composers ("Will people like this music?"), a conductor is indicative of human instinct.

