+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-07-05T10:32:00-06:00"
lastmod = "2015-07-06T22:29:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436117906014/Lohengrin.jpg.jpg"
primary_image_credit = "A scene from Hans Neuenfels' production of Lohengrin, Bayreuth Festival, 2010. Photo: Michaela Rehle/Reuters."
publishDate = "2015-07-07T07:00:00-06:00"
related_articles = ["articles/who-cares-what-bring-on-the-why.md","articles/in-review-tcherniakovs-don-giovanni.md","articles/mrozewski-delight-wonder.md","articles/the-real-reason-to-bring-teens-to-the-opera.md","articles/don-giovanni-in-2018-in-search-of-a-concept.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/canadian-opera-company.md","scene/companies/deutsche-oper-berlin.md","scene/companies/tapestry-opera.md"]
short_description = "Instead of the lazy/meta/shock-value tactic, just commission an opera that tells the story you want to tell. Yep, that&#039;s a big ask, I know. It&#039;s a longer, riskier, more difficult process than slapping rape scenes onto Rossini, but I think it&#039;s the more creative way. Plus, it could be a serious killing of two birds with one stone; the stories would be organic (and still shocking, if you want - I&#039;m no Victorian with what I want to see onstage), and it would be a great motivator to fuel the need for more contemporary operas."
slug = "concept-production-real-reason"
title = "&quot;That concept production didn&#039;t work,&quot; &amp; here&#039;s the real reason why"
+++

I came across two articles, talking about - wait for it - shockingly controversial opera productions. [*The Telegraph*](http://www.telegraph.co.uk/culture/music/opera/11707537/William-Tell-gang-rape-scene-causes-uproar-at-Royal-Opera-House.html) was one of several news outlets that reported on the outrage over Damiano Michieletto's current production of [*William Tell*](http://www.roh.org.uk/productions/guillaume-tell-by-damiano-michieletto) at the Royal Opera House; the source of the backlash seemed concentrated over a gang-rape scene, in which a woman is assaulted by a bunch of men onstage. 

With *William Tell* as a current example, *The Guardian* published ["Nudity, Nazis and nipple-slicing: 12 controversial opera productions"](http://www.theguardian.com/music/2015/jun/30/opera-controversy-william-tell). [Andrew Clements](http://www.theguardian.com/profile/andrewclements) and [Alex Needham](http://www.theguardian.com/profile/alexneedham) list a delicious collection of YouTube clips and photos from the weirdest of the weird, like Hans Neuenfels' *Lohengrin*, Calixto Bieito's *Die Entführung aus dem Serail*, and Dmitri Tcherniakov's *Eugene Onegin*.

I've [discussed](/regietheater-ja-oder-nein/) [at length](/panel-regietheater/) the concept of Regietheater and bizarre operatic productions, and I've settled on the following truths: art is subjective, opinions are just that, and opera-lovers have a reputation for being seriously resistant to the unexpected. Reading about the upset and disgust earned by some of these wacky productions is entertaining, and I often share the same exasperation with what feels like gratuitious shock tactics superimposed on traditional operatic repertoire.

The fact is, most arguments against these types of productions entirely miss the point. Critics and audience members are offended by crazy concepts that are objectively sensationalist, but even if they come to a conclusive opinion that I share, they do it for the wrong reasons.

The real argument against *Lohengrins* full of human-sized rats and *Masked Balls* full of toilets is this: these directors are simply telling a different story than the opera itself tells. There's indeed a blurry line between interpreting a story and flat-out changing it, but for the sake of argument, let's focus on the latter half of that line. Another great example is Dmitri Tcherniakov's [*Don Giovanni*](/in-review-tcherniakovs-don-giovanni/), at the Canadian Opera Company this past season. I didn't like the production one bit, and it was because Tcherniakov created dozens of practical, logistical problems for himself by fabricating character relationships that simply don't exist, over a time-line that also doesn't exist.

I think it's a combination of laziness and trend that allows directors to use traditional repertoire, and mess with it in this sort of meta way, in which the audience only fully appreciates the weird production if they know of its traditional counterpart. Tcherniakov's *Giovanni* was exactly that; if you'd never seen a *Giovanni* before, this one is a weak version of a great story. But Tcherniakov, like Neuenfels, Bieito and Michieletto, are actually relying on their audience's knowledge of the "real" *Lohengrin* or *William Tell*. If they proclaim otherwise, I think they're being largely dishonest.

Look. If a director wants to tell the story about a *Royal Tenenbaums*-type family, or a man who accidentally shoots himself instead of his friend, he or she simply *cannot do it* using the stories of *Don Giovanni* or *Eugene Onegin*. It's just not in the score; you've told a different story, period. I get the strong sense that they've decided on a story they want to tell, then found an opera that could kind of, sort of, fit their desires. I don't think it counts as thoughtful and interpretive dramaturgy to use existing repertoire to tell a new story, especially when there are objective conflicts (Egyptian god references in not Egypt, Leporello in "disguise" in front of his supposed family, with no mask on, etc.).

Instead of the lazy/meta/shock-value tactic, there are two options. The first is to change the libretto, something that makes opera folks squeamish. Another, more complete solution is to *just commission an opera that tells the story you want to tell*. 

Yep, that's a big ask, I know. It's a longer, riskier, more difficult process than slapping rape scenes onto Rossini, but I think it's the more creative way. Plus, it could be a serious killing of two birds with one stone; the stories would be organic (and still shocking, if you want - I'm no Victorian with what I want to see onstage), *and* it would be a great motivator to fuel the need for more contemporary operas. No, all these new operas won't mean they'll each be fantastic, but we're clearly not racking up hit after hit with concept productions either.

Is it naïve to suggest that the money put into (probably expensive) productions like these be redirected into workshopping new pieces? Is it crass to suggest that these directors are skipping huge parts of the creative process with freaky productions *and* making opera more and more of an in-crowd type of deal by relying on an audience who already goes to lots of opera?

Like I said, when it comes to a production that's too weird to truly work, any offended listeners and myself could come to the same conclusion despite how we got there. It isn't, however, because of shock-value elements or updated settings. It's because (to make an analogy) the director is trying to tell the story of Harry Potter by reading aloud Dr. Seuss. 
