+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-05-01T15:59:00-04:00"
lastmod = "2017-05-02T08:47:00-04:00"
preamble = "Toronto-based [Collectìf](/scene/companies/collectif/) is the product of creativity, artistic independence, and musical curiosity. Its core team includes singers [Jennifer Krabbe](/scene/people/jennifer-krabbe/), [Whitney O'Hearn](/scene/people/whitney-ohearn/) and [Danika Lorèn](/scene/people/danika-loren/), and pianist Tom King; using the medium of art song, Collectìf creates original, immersive performances that have our interest officially piqued.\n\nWe spoke with Jennifer, Whitney, and Danika about the creation of Collectìf, the work they're proud of, and their favourite songs (for now, anyway)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493669740389/2017-05-01---CollectifHeadshot.jpg.jpg"
publishDate = "2017-05-02T08:47:00-04:00"
related_articles = ["articles/quintus-4-has-no-choice-but-to-have-a-unique-sound.md"]
related_companies = ["scene/companies/collectif.md"]
related_people = ["scene/people/whitney-ohearn.md"]
short_description = "&quot;We were all coming to the end of our academic careers at around the same time. We were looking to create something interesting, and we wanted to be our own bosses. Each of us adds something totally unique to the dynamic of the group, and we are completed by Tom King, who has been out pianist for every show.&quot;"
slug = "collectif"
title = "Meet the folks: Collectìf"
+++

## How did Collectìf begin?

We were all coming to the end of our academic careers at around the same time. We were looking to create something interesting, and we wanted to be our own bosses. Each of us adds something totally unique to the dynamic of the group, and we are completed by Tom King, who has been out pianist for every show.  Our shows wouldn't be the same without out him – his background in tango, jazz, improv theatre, as well as classical music facilitates our every creative whim. He's truly our missing link. 

## What is Collectìf all about, and what can audiences expect from your shows?

Collectìf is all about creating immersive theatre experiences, using art song as our medium. 

Every Collectìf show is unique, in part due to our site-specific productions (none of our shows are designed for a traditional theatre set-up – we choose diverse venues that allow for an immersive audience experience).  We also make a point to use multi-media to enhance the narrative of our shows.  For example, in *As A Stranger* (our staged production of Schubert's *Winterreise*) we created a short film that combined cinematography with a live translation of the German text, allowing our audiences to follow the story word for word.  

Ultimately our goal is to bring a new audience into the classical music world by breaking down some of the barriers that we feel no longer serve the art form.  But really, the best way to understand what we're about is to come and see one of our shows.   

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1493669856517/2017-05-01---Collectif-at-the-RBA.jpg.jpg)
<figcaption>Collectìf at the Richard Bradshaw Amphitheatre.</figcaption>
</figure>

## How do you connect art songs with larger-scale theatrical concepts?

**Whitney**: Sometimes the concepts are inherently there, especially in song cycles that have a linear narrative such as Schubert's *Winterreise*.

**Jennifer**: In other instances we use art song to explore existing literary works, such as our very first pastiche, *Le Rossignol et la Rose*. In that show, we took Oscar Wilde's short story *The Nightingale and the Rose* and brought it to life with French melodie and vocalises.  

**Danika**: Our most recent project, Fête, was an exploration of Paul Verlaine's set of poetry *Fêtes galantes*, which revolves around characters from the commedia dell'arte threatrical tradition – one of the pillars of modern theatre.  

## What are some projects you hope to do in the future (realistically or otherwise)?

In our past few seasons we've had an awesome time doing our Collectìf Cabarets in which we explore the more "adult" side of classical music (**Whitney**: They are decidedly NSFW). There is so much dirty rep out there and so very few appropriate venues so we're looking forward to a few more of those in the coming year. 

This winter we're bringing our *As A Stranger* production from last season to the incredibly fitting Quebec wilderness of the Festival Pontiac Enchanté in the Pontiac region of Quebec.   
		
Our current project in the works is a high-fashion representation of the life of King Henry VIII, using music he wrote himself. You can look for it in our 2018/2019 season. 

## Do you have a favourite song?

Of course this is an impossible question, but here's what we're digging right now:  

**Jennifer**: *Hymnen an die Nacht* by Claude Vivier (love me some Sprechstimme)

**Whitney**: *The Sealman* – Rebecca Clarke (I always precede it with a spoken monologue - in the best Irish accent -  taken John Masefield's short story by the same name)

**Danika**: *Ideale* by Tosti (but only when it's being sung to me) 

And as a group, we always love the irreverence of Tom Lehrer's *I got it from Agnes*.

>To stay in the loop with Collectìf, follow them on [Facebook](https://www.facebook.com/collectiftoronto/), [Twitter](https://twitter.com/CollectifTO), and [Instagram](https://www.instagram.com/collectifto/).
