+++
author = ["authors/greg.md"]
categories = "Review"
date = 2022-05-15T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "The [COC's production of _La traviata_](https://www.coc.ca/productions/23083) runs through May 20, 2022."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1652706078/media/2022/05/sqCOC_Traviata_21-22-01-MC-D-0398_i9jqdc.jpg"
primary_image_credit = "Amina Edris (in front) as Violetta and Matthew Polenzani as Alfredo in the Canadian Opera Company’s production of La Traviata, 2022, photo: Michael Cooper."
related_articles = ["articles/talking-with-singers-matthew-polenzani.md", "articles/la-traviata-shows-houston-how-to-arise.md", "articles/installation-la-traviata-intimate-and-effective-production.md"]
related_companies = ["scene/companies/houston-grand-opera.md", "scene/companies/lyric-opera-of-chicago.md", "scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/jamie-groote.md", "scene/people/gregory-dahl.md", "scene/people/adam-luther.md", "scene/people/matthew-polenzani.md", "scene/people/simone-piazzola.md"]
short_description = "Legato in spades and a magnetic presence on the stage that was at times hypnotizing, her \"Sempre libera\" (an aria that holds a particularly special place in the hearts of Queers in my generation) brought the house down."
slug = "review-the-cocs-prima-la-musica-la-traviata"
title = "Review: the COC's \"prima la musica\" La traviata"
youtube_url = ""

+++
Hello, Schmop-Tops!

While still riding the high from my first trip across the boards since the world shut down two years ago, my first fully-staged opera as an audience member/reviewer — in person — happened to be one of the best ones any opera lover could have asked for: Verdi's _La traviata_.

The Canadian Opera Company is currently mounting their [co-production with Houston Grand Opera and Lyric Opera of Chicago](https://www.coc.ca/productions/23083), which we last saw in 2015, directed by Arin Arbus and with COC Music Director Johannes Debus leading the orchestra. This production — while not particularly pushing many theatrical boundaries but employing some great lighting and use of shadow, thanks to the lighting team of designer Marcus Doshi and associate Siobhan Sleath — works well for such a highly focused storyline.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652706237/media/2022/05/COC_Traviata_21-22-01-MC-D-021_eydq4a.jpg){{% /md %}}

<figcaption>(l-r) Amina Edris as Violetta and Midori Marsh as Annina in the Canadian Opera Company’s production of La Traviata, 2022, photo: Michael Cooper.</figcaption>  
</figure>

The story of Alfredo, a young, impetuous man who falls in love with Violetta Valéry (a woman of questionable repute but quite wealthy) at a party. They agree to marry. Violetta is ill, because opera. Word gets back to Alfredo's dad, Giorgio Germont, of their upcoming union, of which he will be having none. Arguments and arias ensue, then in the most operatic of finales, our heroine expires from excess of emotion leaving the two men to deal with their words and actions.

As far as opera plots go, this is one of the least convoluted. It is completely focused on one storyline; which opens it up to more intense scrutiny.

> A strong, steely sound that is very at home in the Verdian milieu, he delivered an astounding "Di miei bollenti..."

The singing was, for the most part, splendiferous. The COC Chorus shows once again why they are one of the best in the biz, and I think it's high-time we had a COC Chorus gala concert where we get to let them really strut their stuff and be in the spotlight, but I digress.

I found these tempi to be a little on the safe side. While they allowed for lots of bloom and ring in the house, we kinda missed out on one of the most thrilling parts of a Verdi score, which are the _presto_ and _prestissimo_ tempo markings — but this is a personal taste situation. (As is the whole review, if we're being honest friends. And I like being honest.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652706268/media/2022/05/COC_Traviata_21-22-01-MC-D-167-170_fnaxuo.jpg){{% /md %}}

<figcaption>Matthew Polenzani as Alfredo and Amina Edris as Violetta in the Canadian Opera Company’s production of La Traviata, 2022, photo: Michael Cooper.</figcaption>  
</figure>

Making her COC mainstage debut was soprano [Amina Edris](/scene/people/amina-edris/), and what a debut it is. A warm, dark, full lyric tone that still manages brightness and some remarkable agility throughout Verdi's (sometimes) relentless melisma. Legato in spades and a magnetic presence on the stage that was at times hypnotizing, her "Sempre libera" (an aria that [holds a particularly special place in the hearts of Queers in my generation](https://youtu.be/ZreZzV7y18Y)) brought the house down.

> Midori Marsh as Annina is another standout among the comprimario roles.

Also making a COC mainstage debut is our Alfredo, tenor [Matthew Polenzani](/talking-with-singers-matthew-polenzani/). A strong, steely sound that is very at home in the Verdian milieu, he delivered an astounding "Di miei bollenti..." and musically the whole role was on point. However, I found his characterization of Alfredo to be a little too old. It read more as though he and Germont were brothers rather than father and son. I have no problem with a mature tenor singing Alfredo, as long as the impetuousness that comes from Alfredo's youth is in the forefront of thought at all times. It takes a mature voice to sing this role, and mature voices tend to come in mature bodies — which is great! — but the characterization needs to be accountable to given circumstances in the plot and narrative.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652706294/media/2022/05/COC_Traviata_21-22-01-MC-D-0282_epn81f.jpg){{% /md %}}

<figcaption>Amina Edris as Violetta and Simone Piazzola as Germont in the Canadian Opera Company’s production of La Traviata, 2022, photo: Michael Cooper.</figcaption>  
</figure>

A third notable debut comes in the form of baritone [Simone Piazzola](/scene/people/simone-piazzola/) in the role of Giorgio Germont. Easily viewed as the villain of the piece, as he's the one most aggressively driving our lovers apart, there's a lot in the story for the audience to find sympathy for this stressed-out patriarch. Piazzola's Germont had some issues. Whether it was fatigue, or brought on as a side effect of his aged characterization of Germont, my ears — and I'm not particularly gifted in this manner myself — seemed to hear some intonation concerns. Very clearly a skilled singer with a beautiful instrument, I personally felt this wasn't Mr. Piazzola's best night. And I _have been there_ — so much love!

> There's a very "prima la voce" attitude towards the presentation.

The supporting cast was all outstanding! And to see it loaded with Canadian players (a few who could very easily step into any of the above roles) was the cherry on the sundae. I have to say [Adam Luther](/scene/people/adam-luther/)'s Gastone was well-sung and engaging, [Gregory Dahl](/scene/people/gregory-dahl/)'s Barone was excellent — as we expect from Mr. Dahl. He's rarely (if ever?) not understood the assignment. [Jamie Groote](/scene/people/jamie-groote/) as Flora Bervoix was lovely and particularly adept at portraying elegant gossip — which is something dear to my heart. [Midori Marsh](/scene/people/midori-marsh/) as Annina is another standout among the comprimario roles. Always exquisitely sung, Marsh has a certainty and thorough understanding of her character that just puts you at ease as an audience member.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652706343/media/2022/05/COC_Traviata_21-22-01-MC-D-0497_shntto.jpg){{% /md %}}

<figcaption>A scene from the Canadian Opera Company’s production of La Traviata, 2022, photo: Michael Cooper.</figcaption>  
</figure>

Overall, with a few standout performances and a lovely — if too obscured — performance by a quartet of lovely dancers (bravi!) I found the drama to be a little absent. The music was (mostly) thrilling, but I felt there was storytelling missing.

In my humble opinion: "Libiamo" is really the test in this show. Take it from a Broadway baby, an opening number sets the pace. Yes, there's a prelude, there's some chatter where we get the important exposition that Violetta is ill (read: a female character in an opera), but the "opening number" is "Libiamo!" And what an opening number it is. It brings the audience to the top of the rollercoaster before the carts are let go to have inertia and physics take you on a ride to the denouement. This one, kinda just passed by well-sung. There was no sense of "party" — and in the era that the gorgeous design by Cait O'Connor on costumes and puppetry and Riccardo Hernandez on sets — these people _knew_ how to party.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1652706385/media/2022/05/COC_Traviata_21-22-01-MC-D-0969_gm9dbe.jpg){{% /md %}}

<figcaption>Amina Edris as Violetta and Matthew Polenzani as Alfredo in the Canadian Opera Company’s production of La Traviata, photo: Michael Cooper.</figcaption>  
</figure>

Overall, I think the success of this production is in its musicality, even if it felt like everyone was just trying to keep up with the women on the stage — Edris in particular. There's a very "prima la voce" attitude towards the presentation, and given that this is considered to be among the height of _bel canto_, I get that — but we know these voices are gorgeous. I really lean into "prima la storia" — tell us the story; if you tell us the story well, we'll listen more closely to your beautiful singing.

And the singing is really beautiful. Especially in Edris, it's a voice tailor-made for Violetta.

If you want a grande dose of grand opera, [check this out](https://www.coc.ca/productions/23083), the music is glorious.