+++
author = ["authors/greg.md"]
categories = "Review"
date = "2024-02-12T00:00:00+01:00"
lastmod = "2024-02-12T00:00:00+01:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1707867217/sqCOCVixen_23-24-03-MC-D-0422.jpg"
primary_image_credit = "Jane Archibald as the Vixen and Carolyn Sproule as the Dog (behind) in the Canadian Opera Company's production of The Cunning Little Vixen, 2024, photo: Michael Cooper."
postamble = ""
publishDate = "2024-02-12T00:00:00+01:00"
related_articles = ["articles/talking-with-singers-christopher-purves.md", "articles/jane-archibald-more-than-the-sum-of-all-those-notes.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/jane-archibald.md", "scene/people/christopher-purves.md", "scene/people/adam-luther.md", "scene/people/carolyn-sproule.md", "scene/people/megan-latham.md"]
short_description = "While the direction was creative and clear for the most part, I felt the show was trying to tackle too many struggles in a way that I think somewhat detracted from what I assume the primary allegory is: the need for feminism."
slug = "archibald-shines-in-COCs-whimsical-physical-vixen"
title = "Archibald shines in COC's whimsical, physical Vixen"

+++
Long time no see! Have no fear, your friendly neighbourhood Greg is back! 

We stepped out to catch the Canadian Opera Company's latest offering: Janácek's _The Cunning Little Vixen_. The COC last presented this 25 years ago, yet this production is markedly different.

The story tells the tale of a young Vixen who is captured by The Forester and brought home in an abusive attempt to domesticate her. This does not bode well, and the Vixen is put out of the house, where she is rescued by fellow foxes. The Vixen continues on to liberate the hens from their domineering rooster; they usurp the Badger's massive estate where he lived alone, then she meets a handsome young Fox, has a large brood and settles down. We then meet a Poacher who encounters the Forester setting a trap for the Vixen. However, being raised by humans, she teaches her brood about the trap and how to beat it. The Poacher sees the Vixen and after she saves her brood from him, he takes her life and her pelt to make a wedding muff for his future bride. The Forester is then seen contemplating his choices in the forest.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1707867221/COCVixen_23-24-03-MC-D-0875.jpg){{% /md %}}

<figcaption>(l-r) Ema Nikolovska as the Fox and Jane Archibald as the Vixen in the Canadian Opera Company's production of The Cunning Little Vixen, 2024, photo: Michael Cooper.</figcaption>
</figure>

The story was taken from a graphic novel and is fleshed out in this self-referential, rather humorous at times, fairy tale. While the direction was creative and clear for the most part, I felt the show was trying to tackle too many struggles in a way that I think somewhat detracted from what I assume the primary allegory is: the need for feminism. 

There's discussion about class divide - both in the way the Vixen is punished for the actions of the Dog and the Children (representing the upper-classes) while living with the Forester, when the Vixen is living with the Forester, and in the very real threat of gaslighting in a patriarchal society in the Vixen's - um, interaction? - with the Rooster when she liberates the hens. There's also a scathing review of capitalism in a very "eat the rich" moment when the Badger is driven from his home. There's comments on climate change, there's comments on this, there's comments on that. These are all very important topics, but I think it lacked a bit of focus that these disruptions amongst the animals were being perpetrated and executed successfully by women. I think that an overarching theme of "the patriarchy is kind of at the root of all our problems" could have been established more strongly, if a throughline of the powerful feminine remained in the forefront. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1707867220/COCvixen_23-24-03-MC-D-1231.jpg){{% /md %}}

<figcaption>(l-r) Wesley Harrison as the Schoolmaster, Christopher Purves as the Forester, and Charlotte Siegel as the Innkeeper’s Wife in the Canadian Opera Company's production of The Cunning Little Vixen, 2024, Photo: Michael Cooper.</figcaption>
</figure>

These very human-like scenes amongst animals are juxtaposed against much more philosophical scenes with the humans. We see the frailty of toxic masculinity when the Forester stays out too late with the Priest and the Schoolmaster - two who later find themselves at risk of "losing their principles". The fantastical design of the fauna in this universe slammed hard against the drab, monotone themes of the human's dress and environment in a very creative and practical way. 

Dead-centre stage was a highlight of the design for me: a seemingly never-ending fabric scroll, painted to depict the happenings of the story, as though they were illustrations in a children's book. It was creative and captivating, as was their use of similar scrolls to create the trees of the forest and employ a really creative way of showing the deforestation being caused. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1707867220/COCVixen_23-24-03-MC-D-1304.jpg){{% /md %}}

<figcaption>Christopher Purves as the Forester in the Canadian Opera Company's production of The Cunning Little Vixen, 2024, photo: Michael Cooper.</figcaption>
</figure>

As the title character, Sharp Ears, COC regular and Toronto favourite Jane Archibald was at the top of her game. She sang with her usual ease and flair, with fabulous control of both her dynamic range and the consonant-rich Czech. What I was particularly excited by was her incredible physicality. Archibald ate the scenery up, proving that you can use your whole body quite intensely on stage and not sacrifice any beauty of sound or nuance of technique. 

As the Forester, Christopher Purves was an excellently-sung portrait of a man who has grown up a product of one time-period struggling to keep up in a new one, without much ability or experience in changing his ways. We see that he genuinely does care for Sharp Ears in the beginning both through his characterization and his singing, but is driven to treat her the way he does from the pressures of his household. The scene where he takes from the house I found quite emotional. His rich, thick voice was prominently on display and employed a wide variety of colour during his epilogue/aria that ends the show. Some really fantastic singing. 

And speaking of fantastic singing, I was blown away by mezzo Ema Nikolovska in the role of The Fox - Golden Stripe. A pants role - is this the right term here, do male foxes wear pants? - she sang it with a strong, bright, steely tone that danced wonderfully with Archibald's warmer rounder tone.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1707867220/COCvixen_23-24-03-MC-D-0600.jpg){{% /md %}}

<figcaption>Jane Archibald as the Vixen (left) and Giles Tomkins as the Priest in the Canadian Opera Company's production of The Cunning Little Vixen, 2024, photo: Michael Cooper.</figcaption>
</figure>

Tenor Adam Luther definitely donned my favourite costume of the show as the Rooster. Alongside his rich, full lyric tone, he too showed some real creativity and commitment to his physicality in this role. Carolyn Sproule as the Dog is definitely in the running for best fit. Encased in a massive spherical flood, she sang with a lovely legato that was often at odds with what was being asked of her physically. Her work with Archibald was one of my favourite interactions in the show. Bass-baritone Giles Tomkins sank his teeth firmly into The Badger as well as the Priest. As always, his singing was top-notch and really seemed to be having fun with the role. Paired nicely with Wesley Harrison as the Schoolmaster, their interplay with Purves during the inn scene was a joy to watch. Megan Latham as the Forester's wife returns later fabulously garbed as well as the Owl, sang beautifully and moved well. I also really enjoyed her interplay with the children Frantik and Pepik (Iliana Zarankin and Ariane Cosette respectively) and Archibald's Sharp Ears. 

As is to be expected when the Canadian Children's Opera Company shows up, they absolutely stole the show. Their characterizations of the various forest creatures and later the brood of foxes was a real treat! Great job! 

I have to say, actually ALL the singers on the stage were phenomenal movers in this piece. I think the fantastical nature of the material allowed them to give themselves permission to dive into really embodying these characters, both in their staging and choreo. In my mind, this engaged physicality only served to enhance the quality of the singing. It was really exciting to see this kind of work on the COC stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1707867220/COCvixen_23-24-03-MC-D-0291.jpg){{% /md %}}

<figcaption>A scene from the Canadian Opera Company's production of The Cunning Little Vixen, 2024, photo: Michael Cooper.</figcaption>
</figure>

The COC Chorus is no exception here. The sopranos, mezzos and altos as the hens deserve a special kudos, but they all performed wonderfully, as always. Under Johannes Debus, the orchestra could be a bit hefty at times, but the musicality and skill was top-drawer. 

This year the Canadian Czech Institute is celebrating 2024 as the year of Czech Music, so keep an eye out for many other Czech offerings on tap around Toronto and across Canada.