+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-11-17T13:23:00-05:00"
lastmod = "2015-11-20T11:09:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448035765824/2015-11-20%20-%20Two%20Doors.jpg.jpg"
publishDate = "2015-11-20T10:40:00-05:00"
related_articles = ["articles/star-repetiteur-there-is-such-a-thing.md","articles/how-to-play-for-singers.md","articles/teaching-in-the-arctic-5-things-that-one-singer-learned.md","articles/whos-afraid-of-the-aging-singer.md"]
short_description = "The system still appeared odd to me. Why weren&#039;t these voice teachers, in their lessons full of exercises and tone production, also pointing out wrong rhythms, missed entrances, and poor diction? And why did these pianists feel that they had so much to offer someone who is probably much more advanced at singing than they are?"
slug = "coaches-voice-teachers-and-the-grey-area-in-between"
title = "Coaches, voice teachers, and the grey area in between"
+++

When I was in university, I remember being very confused by the voice majors and their "coaches". Almost everyone had a weekly lesson with their piano/violin/bassoon teacher, but these singers had an extra lesson-type thing, in a practice room for some reason, and with a pianist. Of course, this pianist was usually their accompanist for things like masterclasses, lessons, and recitals; I assumed they would rehearse together, but I didn't really understand why the singers referred to them as their coaches.

The academic structure of having a regular voice teacher, as well as a regular coach, is something that begins fully for singers in their post-secondary training. As I began to work as a coach for voice students in the faculty, my own teacher put a lot of emphasis on the difference between teacher and coach. I understood the line to be in what the singer learns from each; a voice teacher works with vocal technique, breath, often diction and style, and a coach deals with details of rhythm, text expression, and often more detailed attention to the specifics of a language.

The system still appeared odd to me. Why weren't these voice teachers, in their lessons full of exercises and tone production, also pointing out wrong rhythms, missed entrances, and poor diction? And why did these pianists feel that they had so much to offer someone who is probably much more advanced at singing than they are? The division seemed unnecessary to me, until I considered my own training as a pianist; I had a piano teacher, but I also went elsewhere to learn theory and music history. I suppose my piano lessons weren’t the only place I learned my craft.

I looked at it like this: in the same way that my theory teacher didn't supervise my practicing of scales and arpeggios, a coach won't tread on the singer's technical process. I must have asked my teacher why it was such a sensitive subject, because I remember being told strongly something like "because you can mess up their throat if you don't know what you're doing." Fair enough.

Luckily, my early coaching years included sitting in hundreds of lessons with my singers and their voice teachers. Like most pianists would, I started to pick up a few things about vocal technique. Every teacher has a different style and a different teaching vocabulary, but eventually I was able to identify things that were constants. I watched as singers learned to sing legato and staccato, master portamentos and coloratura; I learned about vowel modifications in different vocal registers, about the passaggio, and what it meant to sing on consonants. Most importantly, I was able to associate what I learned with how it eventually “should” sound.

A voice teacher knows all of these technical steps, and all their variations in different voices. From their teachers, singers eventually learn to identify the vocal demands of what they're singing, and draw upon their store of technique to use the tools that will help. As a result, coaches often have the luxury of asking for the end result, leaving the necessary steps to the singer. I can ask a singer to sing a phrase slower, and in theory, that singer can adjust his breath accordingly. Half of coaching is actually about learning how to ask for what you want, and I've found it's safer and more encouraging to assume that the singer can give it to you. For example, saying, "I can't hear the rolled R at the end of that word," rather than offering a list of tips to make the R louder.

Of course, voice teachers also know a thing or two about how to get what they want out of a student. They too know that sometimes talking about style or diction can solve an underlying technical problem. I was once told about coaching singers, "you should only ask a singer to do what you could demonstrate for them." That was easy to stick to when I didn't know anything about singing, but the more I learned, the more I strode into territory that I had considered the voice teacher's. It's ironic, maybe; for voice teachers and for coaches, when they get more experienced in their work, their methods can become less and less distinct from each other.

Outside of academia, the distinction becomes irrelevant, frankly. Singers call coaches and teachers they trust, and the smart ones play the field. They go to technicians, bel canto experts, Czech language gurus, breath specialists and dramaturgs without discrimination, because they know they can learn what they need. The background of these teachers, be it singing, piano, or hardly musical at all, isn't important. 

I've known teachers who saw the "coach line" in a different place than I did, and I've known some who prefer their students stay monogamous. I doubt that kind of attitude has much to do with student growth, since multiple opinions are a constant of a professional singer's life. It's one more instance of music being a microcosm of life: teamwork is more efficient than working alone, and humility is worth more than getting credit.
