+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2018-06-08T11:56:00-04:00"
lastmod = "2018-06-09T21:35:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528473120267/CMIMFinals.jpg.jpg"
primary_image_credit = "Clockwise from left: Canadian mezzo-soprano Emily D'Angelo, Canadian tenor Andrew Haji, and South Korean tenor Konstantin Lee in the 2018 CMIM Aria Finals. Photo: Tam Lan Truong Photography. "
publishDate = "2018-06-08T12:19:00-04:00"
related_articles = ["articles/anticipation-cmim-aria-semifinals-part-i.md","articles/the-2018-cmim-begins.md"]
related_people = ["scene/people/emily-dangelo.md","scene/people/andrew-haji.md","scene/people/john-brancy.md","scene/people/rihab-chaieb.md","scene/people/julien-van-mellaerts.md"]
short_description = "Even for me, I was quite errant in my guesses for the winners of this year&#039;s Concours musical international de Montréal. "
slug = "cmim-finals-one-out-of-three-aint-bad"
title = "CMIM Finals: one out of three ain&#039;t bad?"
+++

I am historically terrible at predicting the winners in voice competitions. Actually, my weakness is more specific than that: I am terrible at predicting what jurors will deem winner-worthy. Sometimes I'm so off that I feel as though I'd seen different performances altogether - either that, or I'm being naïve and not reading between the invisible lines that always seem to exist with these high-stakes competitions.

Even for me, I was quite errant in my guesses for the winners of this year's Concours musical international de Montréal. 

The good news first: mezzo-sopranos [Emily D'Angelo](/scene/people/emily-dangelo/) and [Rihab Chaieb](/scene/people/rihab-chaieb/) took the awards for Best Canadian Artist in the Aria and Art Song categories, respectively, and Canadian tenor [Andrew Haji](/scene/people/andrew-haji/) won the Oratorio Award. People's Choice Awards went to Clara Osowski (Art Song) and Emily D'Angelo (Aria), and baritones [John Brancy](/scene/people/john-brancy/) and [Julien Van Mellaerts](/scene/people/julien-van-mellaerts/) each took prizes for Best French Mélodie and Best German Lied.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528473214408/WinnersGroupPhoto-1.jpg.jpg)
<figcaption>(l-r) Julien Van Mellaerts, Clara Osowski, and John Brancy, winners of the 2018 CMIM Art Song Prizes. Photo: Tam Lan Truong Photography.</figcaption>
</figure>

Emily D'Angelo was on my list of top picks from the very beginning, and stayed there after her Finals round. Her set of arias (picks from *Il barbiere di Siviglia*, *Vanessa*, *Cendrillon*, and *Ariadne auf Naxos*) seemed calculated, designed to check boxes of coloratura, lyricism, linguistic variety, and big fat high notes. After wowing her way into the Finals with jaw-dropping performances of Handel, Berg, and Mozart, D'Angelo earned herself a bit of strategic care. The 23-year-old took Second Prize in the Aria Category, capping off two weeks' worth of unreal singing with her winning smile. 

John Brancy took First Prize in Art Song, a well-earned award for the American; I thought his Semifinals programme was what cinched it, including his terrifying *Erlkönig* with the tireless Peter Dugan at the piano. He was one of two singers who competed in both divisions, and he too sang in the Aria Finals. I'd spent a lot of time impressed by Brancy in this competition, yet this final set of arias didn't seem put the icing on the cake. His throaty, modern sound was refreshing in his Rameau pick, and I loved the richness that came with his aria from *Eugene Onegin*. I admit was itching to hear his "Per me giunto" from *Don Carlo*, yet it seemed to confirm that Brancy isn't - yet, anyway - a Verdi baritone. One of the highlights of the whole competition, I thought, was Brancy's singing of "Look, through the port" from *Billy Budd* in the Aria Semifinals; I wondered why he veered so far from the style that suited him so well.

So, after Brancy's Art Song win, and D'Angelo's placing in the top three of the Aria division, the CMIM jurors and I seemed to part ways.

In a sad surprise, British soprano [Gemma Summerfield](/scene/people/gemma-summerfield/) took no prize in the Art Song category. The four finalists - Summerfield, Brancy, Clara Osowski, and Julien Van Mellaerts - certainly made for a tight race, yet I thought her polished, heartfelt singing got slighted by these jurors.

Andrew Haji, I thought, sang his best round in these Finals. The Canadian tenor does not often run on the single tenorial pillar of High Notes™, and still he justly made it this far without hurling high Cs at the jurors. Yet his Finals round included "Che gelida manina" (*La bohème*) and "La donna è mobile" (*Rigoletto*), arias which come with notoriously, unavoidable high notes. And they were there, no doubt - but perhaps it was too little, too late. Bafflingly, Haji didn't place in the top three of the Aria Prize. I really, really don't understand why.

Also overlooked was Russian bass Mikhail Golovushkin. He spent three rounds giving us undeniably beautiful sound, with a level of care and finesse in his technique that is hard to find among true basses. Sandwiched between two great Russian picks, Golovushkin gave us Verdi's delicious "Ella gammai m'amò" (*Don Carlo*), which earned him a spot in my personal top three. Perhaps the jurors didn't like the passing moment of Golovushkin's being out of sync with conductor Graeme Jenkins - indeed, the bass had to turn his attention away from his performance and toward the collecting of ensemble, a task that shouldn't have been his to do. It wasn't the first time I was frustrated with Jenkins' sluggish reaction time to the singers' lead. Golovushkin didn't place, either, which was a real shame.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528473246084/WinnersGroupPhoto-2.jpg.jpg)
<figcaption>(l-r) Emily D'Angelo, Mario Bahg, and Konstantin Lee, winners of the 2018 CMIM Aria Prizes. Photo: Tam Lan Truong Photography.</figcaption>
</figure>

So, who took the Aria prizes, then? Emily D'Angelo's Second Prize turned out to be flanked by the two South Korean Tenors, Konstantin Lee (Third Prize) and Mario Bahg (First Prize). Lee and Bahg both have beautiful instruments, and they both pulled out the strategic stops, singing their way into the Finals with big-gun tenor picks from *Faust*, *L'arlesiana*, and *La traviata*. 

Maybe I'm confused by these tenors' prizes because they didn't offer the complete performance package that other finalists did. There were a few high Cs offered by Lee, Bahg, and fellow tenor Haji; but only Haji gave us a story, a personality, and a real performance. *Prima la voce*, I suppose, but I'll take fewer decibels any day if it gets me a charismatic, engaged performance.

So, maybe I'm not bad a predicting the habits of competition jurors. Maybe I'm bad at identifying what a voice competition is about. Certainly, it *can't* be about only making beautiful sound; if sound is their governing criterium, these jurors are frustratingly out of touch. I figure a voice competition is about giving a still-life snapshot of a singer who's ready to make a splash in the professional world. I really hope we're not encouraging parking or barking in this 21st century.

The good news: all of these singers brought their admirable work to a large public platform. I'm sure I'm not the only one who wants to hear more of the likes of Gemma Summerfield or Mikhail Golovushkin, and one hopes that they and their fellow CMIM competitors are on the industry's radar more than ever before.

In case you missed it, watch the Aria Finals here:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/9X2zFG7W5R4"
frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>
