+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-05-22T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1558537727/media/2019/05/P1570316.jpg"
primary_image_credit = "Silla, Cambridge Chamber Ensemble, 2019. Photo courtesy of Cambridge Chamber Ensemble."
related_articles = []
related_companies = []
related_people = []
short_description = "If the themes are supposed to be timeless (and, indeed, as clear and obviously sketched out as they are in the opera's text), then should it not stand to reason that those themes would still ring true regardless of whether or not it was set in Ancient Rome or in America in 2019?"
slug = "clumsy-silla-victim-of-inept-direction"
title = "Clumsy Silla victim of inept direction"
youtube_url = ""

+++
My frequent readers here at Schmopera will likely notice that I often make reference to how the stage and music directors will interpret a work, for better and worse. In my estimation, this is necessary in talking about opera: the role of the directors of any production cannot be understated, for without a solid grasp of either the musical side or the dramatic side of an opera, an entire production can fall apart before anything else gets accounted for. Thankfully, it is exceedingly rare that both aspects fail so spectacularly that the production as a whole suffers for it, but when this happens it invariably leads to failure.

> The night was plagued with numerous synchronization issues between the four-person orchestra and the rest of the vocal ensemble.

Thus, we come to the Cambridge Chamber Ensemble's recent performance of Handel's rarely-performed opera _Silla_. The company states in their mission statement that they hope to make rarely-performed gems accessible to the community: you would not know that _Silla_ was an underrated gem in this production judging solely from the directionless, meandering performance of Handel's score.

To begin with, on a pure musical performance level things seemed to be going wrong left and right. The night was plagued with numerous synchronization issues between the four-person orchestra and the rest of the vocal ensemble, both within the orchestra itself and in relation to the singers. Sometimes an aria would start at a tempo, before noticeably slowing down by its end. Sometimes, the players of the orchestra scrambled to get on the beat after a shaky entrance. There were times I even caught music director Juliet Cunningham whispering beat counts to the rest of the players, even if I suspect that people sitting further away from the orchestra would have missed this.

Worse, this orchestra was able to elicit absolutely zero amount of contrast between the various dramatic moods Handel conjured up: in general, it was rather soulless playing, and it felt monochromatic and dull.

> Ingrid Oslund's work as stage director only added to how directionless the rest of the production felt.

One might initially place the blame on the orchestra, but my suspicion is that the fault lies elsewhere: in speaking to an acquaintance who was in the orchestra during the intermission, it was made apparent to me that the non-piano players of the orchestra were severely underrehearsed due to an unusual lack of rehearsal time, and that Cunningham's conducting left a lot to be desired: in music as reliant on stylistic sensitivity as Handel's is, these things are a death sentence for any orchestra, particularly an orchestra on modern instruments that need to work harder to get the nuances of the style down.

Additionally, Ms. Cunningham's playing on the electronic keyboard that doubled as a harpsichord (and sometimes an organ and, bafflingly, a celesta) completely lacked in dramatic urgency, spontaneity, and variety, and this dragged the pacing of practically every recitative in the show to a slow, grey morass of nothingness. Ms. Cunningham's credentials on the program do not mention whether she has any experience with Baroque repertoire, or indeed with any form of conducting: because of this, it's clear to me that she was rather out of her depth as the conductor, and it showed with how dramatically inert the music felt as a whole.

> The director's notes mention that this was an intentional decision to try not to make the opera about today, in an attempt to highlight the opera's universal themes.

This is already bad enough, but Ingrid Oslund's work as stage director only added to how directionless the rest of the production felt. This is astonishing considering the program seemed to indicate that the production did have a clear direction: in order to make it relatable to audiences, this production was updated to 2019. This is actually rather fitting considering our current political climate when you factor in that the opera's basis is in the life of real-life Roman dictator Lucio Cornelio Silla, and that his mistreatment of women and abuses of power can be used to comment on political themes that are very relevant today.

However, the production could not seem to fully commit to this conceit: it was decided decided to place this production in an alternate 2019 where the Roman Empire never fell. The director's notes mention that this was an intentional decision to try not to make the opera about today, in an attempt to highlight the opera's universal themes: this, however, ends up coming off rather disingenuous for anyone who bothers to ask themselves why this supposed alternate universe version of the Roman Empire is otherwise coded exactly like modern-day America.

> The execution left me feeling that, quite frankly, it should have been left on the cutting room floor.

If the themes are supposed to be timeless (and, indeed, as clear and obviously sketched out as they are in the opera's text), then should it not stand to reason that those themes would still ring true regardless of whether or not it was set in Ancient Rome or in America in 2019? This essentially made the whole production feel like it was trying to have it both ways.

This would have been more forgivable, had the production not made decisions on how to build this world that even the trashiest Bayreuth production of _Parsifal_ from the past decade would have avoided like the Plague. Perhaps the most obvious detail on this front was a subplot about Silla killing refugees from wars outside of Rome's borders. This is certainly a smart idea to comment on issues going on at the US border, but it runs into the singular problem that, for some incredibly perplexing reason, the only indication that anybody in the audience has that Silla is doing this is that the supertitle projections tell us he is.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558538257/media/2019/05/P1570001.jpg){{% /md %}}

<figcaption>Silla, Cambridge Chamber Ensemble, 2019. Photo courtesy of Cambridge Chamber Ensemble.</figcaption>

</figure>

There is literally nothing in the opera's text to reflect these notes in the supertitles, and what does not help is that the one reference to Silla killing innocents in the actual text of the opera refers to these innocents as "citizens", which refugees gathered at a country's border categorically are not. This makes the implementation of this theme come off as incredibly insincere and woefully amateurish, and the execution left me feeling that, quite frankly, it should have been left on the cutting room floor.

The problems do not stop there, for there are other clumsy extra-textual decisions that do not work: none are as silly or as clumsily-done as how this production decided to end the work. Silla is humbled by a shipwreck at the end that comes right after his plans completely fall apart, and in the general rejoicing at the end it seems that Silla is making an attempt to at least change before leaving to go into exile with his wife Metella. (He allows a woman he's been hounding down the entire work to marry the man she actually loves, after all!)

> Handel's over-reliance on da capo form in his operatic music is undoubtedly a stage director's worst nightmare to begin with.

And then, for some reason, Silla walks offstage, after which Metella instructs her and Silla's head of security Scarbo to walk offstage and shoot Silla to death. This is clearly not indicated anywhere in the translated text or in how the actors moved about on the stage, and it is certainly not supported by Metella's text throughout the whole work, both of which seemed to support a reading that Silla could see the error of his ways and does try to actively change. The result thus felt tacked on in a way that short-changed the audience, and felt almost like an out-of-place Hayes Code edit. It did not help that the moment was made possible with maladroit staging, from the fact it happened offstage to even the obviously fake (and far, far too quiet) gunshot sound from the venue's speaker system.

The production thus felt completely out of its depth. This then amplified how inept the staging in general was: Oslund's inexperience with staging Baroque opera came roaring in at full force once the crowbarred in details were no longer around. Handel's over-reliance on da capo form in his operatic music is undoubtedly a stage director's worst nightmare to begin with, but Oslund's solution involved stage movement that very frequently felt awkward, poorly paced, and poorly thought out.

> Nobody ever seemed completely sure of where they were supposed to be owing to how awkward the timing on the entrance and exits generally was.

For instance, there's an aria in which Flavia seemingly calls Silla out for propositioning her, as it would be inappropriate considering she is another man's wife. However, for some reason, she addresses the first part of this aria to her actual husband Lepido: why is she addressing the person who is trying to defuse the situation and not the object of her anger? Why does Silla's ward Celia do her make-up when Metella holds a mirror to her face while singing an aria to her to boost her confidence against Silla? Why did Celia's lover Claudio's rage in the first act manifest in the ridiculous cat-on-the-iPad-keyboard antics that it does?

Why is it that Silla carries himself with poise through most of the opera, but then acts like a bratty child in the middle of an aria that precludes a dream sequence? Why were several characters constantly making rather loudly spoken asides that were inevitably bulldozed over by the music and the stage movement from other singers?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558538271/media/2019/05/P1570032.jpg){{% /md %}}

<figcaption>Silla, Cambridge Chamber Ensemble, 2019. Photo courtesy of Cambridge Chamber Ensemble.</figcaption>

</figure>

And then there are all manner of awkward entrances and exits throughout the show: nobody ever seemed completely sure of where they were supposed to be owing to how awkward the timing on the entrance and exits generally was, and this culminated in the entire cast just standing around looking lost on what to do next in the production's finale, with people noticeably unsure of where to go.

> This production wastes an outstanding young cast: they all at the very least made Handel's punishingly virtuosic writing seem easy.

The staging was therefore an absolute mess, and the issues there combined with the lack of dramatic urgency in the music to produce a very inert and dull evening. Nowhere was this more concentrated than in a moment where Claudio, played here by Lucas Coura, gestures to Metella to get on with it in the middle of one of her arias. I could not help but feel that Coura's hand gesture was speaking for the audience: the whole work seemed to drag on for ages, and the fault lies in the fact that nobody in the creative team seemed to know how to approach Handel's operatic language and inject it with the vitality that it can have when performed right.

It is really a shame, because this production wastes an outstanding young cast: they all at the very least made Handel's punishingly virtuosic writing seem easy, but they also made the best of a bad hand in how they portrayed their characters. Roselin Osser was actually quite believable as the authoritative Silla, letting her uptight mannerisms complement a rather full voice in forming the character, for instance. Theresa Egan also made for a thoroughly human Metella, as a woman who is both scorned by her husband and also wanting his forgiveness. Ann Fogler brought the right amount of bravado to Lepido, and managed to craft the single best character arc of the night in believably crafting a character who starts thinking that Silla's indecencies will pass to someone who swears revenge at all costs. Fran Daniel Laucerica's Mars only sang for one brief number, but he made the most of his brief appearance and was the one clearly having the most fun.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558538285/media/2019/05/P1570323.jpg){{% /md %}}

<figcaption>Silla, Cambridge Chamber Ensemble, 2019. Photo courtesy of Cambridge Chamber Ensemble.</figcaption>

</figure>

Among the rest of the cast Gyu Yeon Shim made for a soulful Celia, Lucas Coura's Claudio was equal parts tender and brave, and Stephanie Mann's Flavia was very much a great dramatic centerpiece for Lepido and others to play off. It is remarkable that these singers were able to craft anything resembling a group of believable characters considering what they were trapped in, but they made the most of a really difficult set of circumstances, and their professionalism in the face of such adversity should be applauded to high heaven.

Unfortunately, their gumption alone was not enough to save a production of Silla that was fundamentally broken in every other way. It was a rare display that showed why good direction is often one of the unsung heroes of an opera production, and unfortunately it displayed as much by getting just about everything wrong. It is indeed a valiant thing to want to make opera like this accessible to the audience: however, in my estimation, part of accessibility is showing the audience that works like these can be dramatically activated with music that can have dramatic urgency, and this just did not happen here. With as great an operatic composer as Handel can be, this is a downright shame.