+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-10-10T21:22:00-04:00"
lastmod = "2017-10-18T19:39:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507916109485/2017-10-13---Callas-Live-SQ.jpg.jpg"
publishDate = "2017-10-18T19:39:00-04:00"
related_articles = ["articles/opera-technology-hither-and-yon.md","articles/maria-by-callas-destiny-is-destiny-there-is-no-way-out.md"]
short_description = "What does an opera lover in the 21st century do with something like Warner Classics&#039; recently released Maria Callas Live Remastered Recordings (1949-1964)? The first thing would be to squeal with glee: the box set includes live recordings of 20 full operas, 5 filmed recitals, and a book detailing each of the iconic roles sung by Callas."
slug = "cleanedup-callas-the-remastered-live-recordings"
title = "Cleaned-up Callas: the remastered live recordings"
+++

For many younger opera fans - the kind who have a balance of love and reverence for the art and its artists - getting a big stack of remastered live recordings of Maria Callas presents as much joy as it does a sense of responsibility. The art (or science, even) of listening to recordings has changed in recent decades; it's an activity that has shifted for many from a slow and methodical process of collecting and comparing long-form media (like full-length opera recordings), to a ravenous grasping at the endless small bites available online (like instantly turning up 50+ different versions of "Sempre libera" on YouTube).

What does an opera lover in the 21st century do with something like Warner Classics' recently released [*Maria Callas Live Remastered Recordings (1949-1964)*](https://www.maria-callas.com/)? The first thing would be to squeal with glee: the box set includes live recordings of 20 full operas, 5 filmed recitals, and a book detailing each of the iconic roles sung by Callas. 

A generous follow-up to [Warner's 2014 remasterings of Callas' complete studio recordings](http://www.warnerclassics.com/release/4603771,0825646339914/maria-callas-remastered-maria-callas-complete-remastered-edition), *Maria Callas Live* is a delicious selection of her operatic and concert work, performances of which there is no studio recording. Bertrand Castellani, Vice President of International Catalogue at Warner Classics, sees these live remasterings as an opportunity "to complete the portrait as much as we could with the opera performances in the studio."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508369950454/2017-10-17---Callas3D-narrow.jpg.jpg)
</figure>

Though I can't call myself an expert on the original sound of these live recordings, the remastered experience of live Callas is really thrilling. There's clarity enough for details to come through (including the lovable din of the prompter's mumblings), yet there's still the raw, fallible ring of a one-of-a-kind performance.

"You can see Callas at her prime, of course, in her best period; you can also see the evolution of the voice, and the way that she plays the characters that she performs," says Castellani, who resists labelling Callas and her work as a historical resource. Rather, "I think she is really one of the most modern performers of her time. I think she's one of the best interpreters."

It's certainly a stunning thing to hear Callas' performance range, plucked from a vital 15-year period of her career, and to hear it all in one box set. There's delicacy in her Gilda (Mexico City, 1952), and Piero Campolonghi's Rigoletto is a heartbreaking thing to hear. That raw edge that we associate with her Aida (Mexico City, 1951) or Norma (London, 1952), proves to be just one of her endless tools, easily traded for a gleaming, youthful sound, or even a borderline-ugly sound of desperation. (The *Norma*, by the way, features Joan Sutherland as Clotilde - very cool indeed.)

Particularly interesting are Callas' recordings of Gluck's *Alceste* (Milan, 1954) and *Ifigenia in Tauride* (Milan, 1957), and of Wagner's *Parsifal*, (Rome, 1950). In an era of obsessively drawn *Fach* borders and score reverence, hearing Callas sing Gluck and Wagner in Italian is totally refreshing. Perhaps it takes someone like her to remind us that having something to say as an artist is more powerful than any rules of style, or perhaps even integrity of the original-language libretto. There's certainly something to be said for someone like Callas singing these roles with her own voice - Italianate as it may be - and living inside these characters above all.

The three concert DVDs, from Paris (1958), Hamburg (1959 and 1962), and London (1962 and 1964) are deliciously old-school in the best way. The idea of starting a concert with "Casta diva" - no warming up necessary - speaks to Callas' nerves of steel, and to an audience that's ready to dive into a scene along with her. Her voice sounds with that familiar solid column of sound, and to watch her is to get sucked into her stage presence, almost like a cliché. It's neat to see her sing the pants out of - but be decidedly un-funny - in "Una voce poco fa" from *Il barbiere di Siviglia*; she even toes an edge with Leonora's Act IV scene from *Il trovatore*, making you feel torn between her too-loud singing in the "Miserere" and the incredible arc she builds starting from "D'amor sull'ali rosee".

It's an embarrassment of riches, this box set, and perhaps an overwhelming one for younger opera fans. Where does one start? 

"I would certainly advise listeners to start with *Lucia*," offers Castellani, referring to her performance with Herbert von Karajan in Berlin, 1955. His second pick is *La traviata*, performed under Franco Ghione in Lisbon, 1958. For him, it's a clear example of her status as a great interpreter, "how she becomes Violetta in every single note, every single inflection." *Tosca* is an easy next choice, and the box set offers both her Royal Opera House performance from 1964, as well as video footage of Act II from the same production, "where you can really feel the incredible aura and life onstage."

My personal pick surprised even me: *Parsifal*, in which Callas sang Kundry at just 26 years of age. It's completely fascinating to hear.

"We took time and great care to remaster, one by one, all these performances," says Castellani. Pressed to offer a favourite among the collection, he says with a laugh, "it's difficult to say that you prefer one of your children over another."

[*Maria Callas Live Remastered Recordings (1949-1964)*](http://www.warnerclassics.com/release/333,0190295844707/maria-callas-maria-callas-live-remastered-recordings-1949-1964) is available in its 42-disc box set or for download via [Warner Classics](http://www.warnerclassics.com/release/333,0190295844707/maria-callas-maria-callas-live-remastered-recordings-1949-1964).


