+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-04-16T19:23:00-04:00"
lastmod = "2015-04-23T10:32:00-04:00"
preamble = "This post originally went up [Musical Toronto](http://www.musicaltoronto.org/2015/04/20/schmopera-the-cultural-divide-between-classical-and-popular-music/). For more Schmopera via Musical Toronto, [click here](http://www.musicaltoronto.org/category/schmopera/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429752313631/2_2.JPG"
primary_image_credit = "Shujaat Khan, sitar player"
publishDate = "2015-04-23T09:26:00-04:00"
short_description = "It&#039;s important to note that to North Americans, European Classical music is something that&#039;s already once removed, culturally speaking. I wondered if it was different in India, where both the art music and popular music are fostered in the same place.\n"
slug = "classical-vs-popular-music-is-it-a-global-thing"
title = "Classical vs popular music: is it a global thing?"
+++

In the West, one of our ongoing cultural discussions is the divide (which seems to grow wider) between audiences of Classical music and popular music. I had always vaguely wondered if this perceived divide exists elsewhere in the world, or if it was unique to Europe and North America. 

I had the chance to meet journalist [Aparita Bhandari](http://www.aparita.com/), who inadvertently reminded me of the topic; in the context of a larger conversation, she referred quickly to the difference between Indian Classical music and the popularity of Bollywood songs. Bhandari began her journalistic work in New Delhi, and moved to Toronto in 1998. I thought she would be a great person to ask about the difference between the role of Classical music in Indian culture, versus Western Classical traditions.

It's important to note that to North Americans, European Classical music is something that's already once removed, culturally speaking. I wondered if it was different in India, where both the art music and popular music are fostered in the same place.

Bhandari senses that, in Western culture, the separation between Classical and popular music is stronger, "whearas in India I think it's a bit more fluid." In terms of the musicians, often popular singers or players are Classically trained, and there's a nod to these roots in their music. "It’s still seen as something one aspires to learn, because a lot of popular Indian music finds its basis in Classical music."

There's also a fair amount of fusion, combining Classical elements with popular music, including from the West. "A lot of Classical musicians...they take things like the tabla and do fun things with it….putting electronic music over it, that type of thing."

I wondered if things like age, education, and social class had anything to do with Classical music audiences in India. "The appreciation of this tends to cut across class," says Bhandari, explaining that it has more to do with a connection to the church. "Because a lot of Indian Classical music is associated with devotional music, a lot of Classical musicians will have devotional songs in their repertoire."

It's an interesting parallel with Western Classical music; I sense that it's similar to the popularity of a piece like Handel's *Messiah*, which fills churches with people who may not otherwise be concert-goers.

When it comes to the age question, Bhandari assures me that it's the same story across the globe. "It tends to be people who are older who will appreciate [Classical music] more than the younger population, where there’s Bollywood, Indian popular music. And popular music these days also takes in elements of Western popular music, so now there’s hip hop...that type of thing."

The closer connection between popular and Classical music was interesting to me, and I asked Bhandari how it applied to kids and music education. "There is a sense that it plays into their education," she says. "If you have piano lessons, it might help you with math. That sort of thing is known." 

Parents do value the education, but perhaps not the professional pursuit of music. "When we think of education, it tends to be very academic-oriented, you learn your math and science. The music is like a nice after-school hobby to have, it’s not something you would take on as a career."

That certainly sounds familiar. Bhandari adds that music education is a way to teach kids about their heritage, especially in Indian families living in Europe or North America. "You can have your average life at school, but Sunday you’re gonna have Classical Hindustani music class, or Classical Indian dance class, and that will teach you culture, that will teach you respect, that will teach you about your heritage."

The simple answer is that a child's exposure to music, Classical or otherwise, depends largely on the parents' appreciation for it. Bhandari explains, "it tends to be more if there’s a general interest in the family, if you come from a family of appreciators of culture, appreciators of Classical music."

These Classical music appreciators may or may not be in greater numbers in India than they are in North America. Regardless, the cultural connection to music is like a bonus when it comes to music education; when it comes to finding a reason to give a kid music lessons, I'm not too picky about which one convinces parents.

That link to our heritage isn't quite the same in the West. Like I said before, to North Americans, Western Classical music is an adopted cultural element. When we enrol our kids in music class, it's not generally associated with a reaching out to our roots. The connection may be closer in Europe (Italy's tradition of opera is a good example), although I don't sense the same amount of reciprocity between Western Classical and pop music.

I think it's interesting to see what the West has in common with India's Classical and popular music scenes. Even more interesting are the differences, which lie largely in the realm of music's cultural significance. The closeness of Indian music and heritage, in a sense, highlights the fact that as North Americans, our cultural connection to Western Classical music is comparatively diffused. We're younger and more diverse, and this kind of diffusion seems natural. It simply makes me return to the fundamental question of *why* Classical music (from everywhere) is important.
