+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2018-04-08T20:44:00-04:00"
lastmod = "2018-04-08T20:44:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523234528949/sq---ENO1718-The-Marriage-of-Figaro---Rhian-Lois%2C-Thomas-Oliemans-1-Alastair-Muir.jpg.jpg"
primary_image_credit = "Rhian Lois and Thomas Oliemans in *The Marriage of Figaro*, ENO, 2018. Photo: Alastair Muir."
publishDate = "2018-04-08T20:44:00-04:00"
related_articles = ["articles/second-opinion-the-marriage-of-figaro-at-the-coc.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/lucy-crowe.md"]
short_description = "It was most heartwarming to see the relationship between Lois and Thomas Oliemans as Susanna and Figaro. Oliemans seemed to go for a more casual Figaro, not quite the charismatic showman that one sees in other productions (or in The Barber of Seville for that matter). His was an unobtrusive Figaro, more content to go along with the schemes of others than to make up his own."
slug = "classic-for-good-reason-the-marriage-of-figaro"
title = "Classic for good reason: The Marriage of Figaro"
+++

Each time I see another production of [*The Marriage of Figaro*](https://www.eno.org/whats-on/the-marriage-of-figaro/) I remember why it is done so often. Not only does it lend itself immensely well to scenic adaptation, the music and story are just so darn good. This one, a revival of Fiona Shaw's 2011 staging for English National Opera, particularly brings out the hilarious elements of the opera. Jeremy Sams' English translation works remarkably well, as usual. 

What a delight to have seen such strong ensemble casts at ENO this entire season. From *Midsummer* to *Iolanthe* and now *The Marriage of Figaro*, it is hard to find a weak link in any of the casting done in the Coliseum. I have been especially impressed with the ENO Harewood Artists this year, with Rhian Lois as a cunning Susanna and Katie Coventry as a captivating Cherubino.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523234303008/ENO1718-The-Marriage-of-Figaro---Alison-Rose-and-the-ENO-Chorus-Alastair-Muir.jpg.jpg)
<figcaption>Alison Rose and the ENO Chorus in *The Marriage of Figaro*, ENO, 2018. Photo: Alastair Muir.</figcaption>
</figure>

It was most heartwarming to see the relationship between Lois and Thomas Oliemans as Susanna and Figaro. Oliemans seemed to go for a more casual Figaro, not quite the charismatic showman that one sees in other productions (or in *The Barber of Seville* for that matter). His was an unobtrusive Figaro, more content to go along with the schemes of others than to make up his own. I did feel like during "Aprite un po' quegli occhi" he didn't actually believe that women were the devil - at the bottom of his heart he never really turned on Susanna. Although this may seem to make Figaro a weaker character, in a way it actually makes him stronger: his commitment to Susanna and unwillingness to lean towards misogyny updates Figaro out of the 18th century.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523234326393/ENO1718-The-Marriage-of-Figaro---Katie-Coventry%2C-Ashley-Riches%2C-Rhian-Lois-Alastair-Muir.jpg.jpg)
<figcaption>Katie Coventry, Ashley Riches, and Rhian Lois in *The Marriage of Figaro*, ENO, 2018. Photo: Alastair Muir.</figcaption>
</figure>

Ashley Riches was everything you want to see in a Count - arrogant, aggressive, commanding when he needed to be and satisfyingly humble at the very end when all turn against him. This production gives no redemption to the Count's action, as the final picture we are left with is the Countess outside the house, packed suitcase in hand, directing herself towards Cherubino. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523234347322/ENO1718-The-Marriage-of-Figaro---Katie-Coventry%2C-Thomas-Oliemans-Alastair-Muir.jpg.jpg)
<figcaption>Katie Coventry and Thomas Oliemans in *The Marriage of Figaro*, ENO, 2018. Photo: Alastair Muir.</figcaption>
</figure>

For me, [Lucy Crowe](/scene/people/lucy-crowe/)'s performance didn't really start until Act 3, when she came in with a heart-wrenching "Dove sono" almost out of nowhere. This is not to say that she was in any particular trouble during the second act, I just wished that her entrance aria had the same quality as her singing in the rest of the opera. Dramatically, she did fall a bit into the trap of giving one emotion to the Countess throughout the whole opera, which is a shame, as I know Crowe for her dramatic power.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523234356732/ENO1718-The-Marriage-of-Figaro---Lucy-Crowe-Alastair-Muir.jpg.jpg)
<figcaption>Lucy Crowe in *The Marriage of Figaro*, ENO, 2018. Photo: Alastair Muir.</figcaption>
</figure>

A highlight for me was Katie Coventry singing the page boy, Cherubino. Her character was passionate and fun-loving all at once - a Cherubino with a real desire to enjoy the juice of life. Paul Sheehan and Alison Rose were hilarious as Antonio and Barbarina, equally drunk yet, oddly charming as country folk.

Shaw's staging remains pleasant to watch, with the rotating stage giving us a multi-dimensional awareness of the ongoings of the Almaviva household. It was because of the ensemble cast that all of the humor worked, with perfect timing and an overall keen sense for slapstick choreography.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523234368685/ENO1718-The-Marriage-of-Figaro---Alison-Rose%2C-Thomas-Oliemans-Alastair-Muir.jpg.jpg)
<figcaption>Alison Rose and Thomas Oliemans in *The Marriage of Figaro*, ENO, 2018. Photo: Alastair Muir.</figcaption>
</figure>

[*The Marriage of Figaro*](https://www.eno.org/whats-on/the-marriage-of-figaro/#prod-discover) runs at the London Coliseum through April 14th. People say that *Figaro* is a great first show for a non opera-goer, and in light of this production I have to agree.

