+++
author = ["authors/blanche-isral.md"]
categories = "Review"
date = "2018-01-24T11:08:00-05:00"
lastmod = "2018-01-24T11:08:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809837446/sq---3476_enrico04_gross.jpg.jpg"
primary_image_credit = "Holger Falk plays the title role in Enrico, Oper Frankfurt, 2018. Photo: Barbara Aumüller."
publishDate = "2018-01-24T11:08:00-05:00"
related_articles = ["articles/misnomers-interstellar-sex-scenes-vasco-de-gama.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/bjorn-burger.md","scene/people/angela-vallone.md","scene/people/samuel-levine.md","scene/people/juanita-lascarro.md","scene/people/holger-falk.md","scene/people/sebastian-geyer.md"]
short_description = "After suffering trauma to the head while in character as Henry IV, Enrico (Holger Falk) regains consciousness still believing himself to be the 11th century emperor. So as not to rattle him, Enrico&#039;s relatives maintain an elaborate lie involving costumes, alternate personas and staff trained to appease him."
slug = "clairvoyant-art-enrico-at-oper-frankfurt"
title = "Clairvoyant art: Enrico at Oper Frankfurt"
+++

A man suffering from cognitive damage exerts a tyrannical rule over the people around him. He believes himself to be a powerful leader. His entourage plays into this delusion, at first as a joke, then out of fear. The man is volatile and unpredictable. He strips down to his skivvies and sexually assaults a young woman. His traumatized and obedient relatives and staff tiptoe around him as if on eggshells. They lay careful plans when he is out of earshot to coax him in their favour. A doctor is brought in to evaluate his cognitive function. Despite his erratic speech and behaviour, the man declares that he is not crazy, and is in fact well aware of the lie that is being kept up for him. What started as a game has become a years-long living nightmare, and everyone is just trying to avoid a catastrophe.

Sound familiar? 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809871730/3473_enrico07_gross.jpg.jpg)
<figcaption>(l-r) Frederic Jost (Ordulfo), Holger Falk (Enrico) and Björn Bürger (Arialdo) in *Enrico*, Oper Frankfurt, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>

No, I am not describing the latest in the American news cycle, but I might as well be. This is the world of *Enrico*, a contemporary opera by Manfred Trojahn in a new production at Oper Frankfurt's alternate space, the Bockenheimer Depot. 

I get a strange sense of comfort from clairvoyant art. This 1991 opera based on a 1922 play does not need much coaxing to reflect the 2018 real-life political situation in the U.S. Works that are decades old but that seem to closely examine a current situation have a special validity for me - they somehow soothe my worries about the world. The bird's eye view and denouement they offer, even when they end in unresolved tension or tragedy, hand a certain degree of control back over to the audience. 

After suffering trauma to the head while in character as Henry IV, Enrico (Holger Falk) regains consciousness still believing himself to be the 11th century emperor. So as not to rattle him, Enrico's relatives maintain an elaborate lie involving costumes, alternate personas and staff trained to appease him. Two decades into this charade, the umpteenth doctor is brought in to examine Enrico. The doctor prescribes shock therapy, in which portraits of characters in Enrico's world are replaced with live relatives in an effort to get him to snap out of his delusion.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809882143/3477_enrico03_gross.jpg.jpg)
<figcaption>(l-r) Peter Marsh (Landolfo), Samuel Levine (Bertoldo), Björn Bürger (Arialdo), Frederic Jost (Ordulfo), Juanita Lascarro (Marchesa Matilda Spina), Holger Falk (Enrico; kneeling) and Dietrich Volle (Dottore) in *Enrico*, Oper Frankfurt, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>

Enrico then declares that he has, in fact, been aware of his true identity for some time, but has consciously chosen not to return to the scary reality of the 20th century. (Here, Enrico removes his robes - ["the emperor has no clothes"](https://en.wikipedia.org/wiki/The_Emperor%27s_New_Clothes). As he still exhibits all the same deranged symptoms, it is unclear whether Enrico is a cool and calculated manipulator or a deluded, confused victim. When the emboldened visitors finally confront Enrico, he becomes violent, assaulting Frida ([Angela Vallone](/scene/people/angela-vallone/)) and stabbing Belcredi (Sebastian Geyer). 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809896330/3469_enrico11_gross.jpg.jpg)
<figcaption>Juanita Lascarro (Marchesa Matilda Spina; front left), Holger Falk (Enrico; front right), Sebastian Geyer (Barone Tito Belcredi); in background: Peter Marsh (Landolfo), Samuel Levine (Bertoldo), Björn Bürger (Arialdo) in Oper Frankfurt's *Enrico*. Photo: Barbara Aumüller.</figcaption>
</figure>

Holger Falk was troubling and precise as Enrico, melding impossible falsetti with curdling screams, nauseating sighs and aggressive quips, and infusing the score with personality and backstory. Falk's Enrico is always suspended in the balance between mentally unstable and coolly manipulative - you never truly know whether he is crazy or conniving. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809910687/3474_enrico06_gross.jpg.jpg)
<figcaption>
Holger Falk plays the title role in *Enrico*, Oper Frankfurt, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>

As for the supporting roles, Oper Frankfurt's strong Ensemble served the company very well in this production. In an arrangement that is a staple of European opera companies but that has not made it across the pond, Ensemble (also known as Fest) singers are employed year-round by opera companies to play an assortment of roles in different productions throughout the season. I find that this arrangement provides a much more even, across-the-board quality in all of Oper Frankfurt's productions, as opposed to the superstar guest vs. local Joe divide that is more common in North American productions. Seven Ensemble members and a couple of guests - [Juanita Lascarro](http://www.juanita-lascarro.de/) (Marchesa Matilda Spina), [Sebastian Geyer] (Barone Tito Belcredi), Theo Lebow (Carlo di Nolli), Dietrich Volle (a great Dottore, [once again](/a-dreamy-psychological-thriller-vanessa-at-oper-frankfurt/)), Peter Marsh (Landolfo), [Samuel Levine](/scene/people/samuel-levine/) (Bertoldo), Frederic Jost (Ordulfo), and Doğuş Güney (Giovanni) tackled Trojahn's kick-your-butt difficult score with cohesive flourish, and provided a plush proverbial throne for Falk in the title role. I was especially drawn to [Angela Vallone](/scene/people/angela-vallone/) (Frida) and [Björn Bürger](/scene/people/bjorn-burger/) (Arialdo), both standouts for their attractive, milky voices and, above all, their spot-on characterization. The entrancing, dissonantly crystalline barbershop quartet-like moment shared by Marsh, Levine, Jost and Bürger was the work's musical highlight.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809923650/3478_enrico02_gross.jpg.jpg)
<figcaption>(l-r) Peter Marsh (Landolfo), Holger Falk (Enrico; seated), Samuel Levine (Bertoldo), Björn Bürger (Arialdo) and Frederic Jost (Ordulfo) in *Enrico*, Oper Frankfurt, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>

The lack of English surtitles (a feature new to Oper Frankfurt that has been appearing in certain productions since November with a view to internationalizing itself) and ensuing language barrier (for me) meant that I knew right away whether the direction, costume and scenery elements were doing their job. In that regard, for the first several scenes of Enrico, I might as well have been reading the libretto - the visual elements were unclear and slow to develop. This was redeemed in the later scenes, however, with the various manipulations by set designer Britta Tönne of the hundreds of books stacked against the wall: the striking discovery by Enrico of a window behind the dusty encyclopedias that overlook the contemporary Frankfurt skyline, and the transformation of the books into a giant portrait of Matilda. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809935861/3460_enrico20_gross.jpg.jpg)
<figcaption>(l-r) Holger Falk (Enrico; laying down), Samuel Levine (Bertoldo), Björn Bürger (Arialdo), Frederic Jost (Ordulfo) and Peter Marsh (Landolfo), *Enrico*, Oper Frankfurt, 2018. Photo: Barbara Aumüller</figcaption>
</figure>

Maybe it's my North American perspective showing, but I wish more parallels were drawn with the real political situation that this work is just begging to mirror. A deluded ruler possibly suffering cognitive damage, traumatizing his staff, sexually assaulting women and declaring that he isn't crazy? Come on! I'm not saying they should have spray painted Enrico's face orange and slapped a comb-over on him, but a few stronger nods would have elevated the work's core message.

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516809954118/3471_enrico09_gross.jpg.jpg)
<figcaption>Holger Falk plays the title role in *Enrico*, Oper Frankfurt, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>

Trojahn's score is challenging in an academic, rather than moving, kind of way. That the singers were able to make sense of the score and infuse it with such individual identity, and not just park and bark with one eye squarely on the conductor, was in itself impressive. Under conductor Roland Böer, the orchestra stole the show with its impeccable precision, musicality and dynamic range throughout. Tönne's stage's layout, with a semi-circular pit carved out of the stage and leaving two catwalks on either side, was not only visually striking but acoustically advantageous for the orchestra.

Catch Trojahn's *Enrico* at the Bockenheimer Depot until February 4. Information and tickets [here](http://www.oper-frankfurt.de/en/season-calendar/enrico/?id_datum=1023).
